/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.multipart;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.Header;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.IResponseStream;
import com.tssap.dtr.client.lib.protocol.multipart.IResponsePart;
import com.tssap.dtr.client.lib.protocol.streams.PartitionInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;

public class ResponsePart
implements IResponsePart {
    private String contentID;
    private String contentType;
    private long contentLength = -1L;
    private HashMap headers;
    private byte[] boundary;
    private String boundaryStr;
    private PartitionInputStream content;
    private IResponseEntity entity;
    private static final boolean APPEND_TO_EXISTING_HEADER = true;
    private static final boolean SKIP_WHITESPACE = true;
    private static final boolean REPORT_WHITESPACE = false;
    private static final boolean SKIP_EMPTY_LINES = true;
    private static final boolean REPORT_EMPTY_LINES = false;
    private static final String END_OF_LINE = "\r\n";
    private static final boolean FINAL_BOUNDARY_FOUND = false;
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$multipart$ResponsePart == null ? (class$com$tssap$dtr$client$lib$protocol$multipart$ResponsePart = ResponsePart.class$("com.tssap.dtr.client.lib.protocol.multipart.ResponsePart")) : class$com$tssap$dtr$client$lib$protocol$multipart$ResponsePart));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$multipart$ResponsePart;

    public ResponsePart(byte[] boundary) {
        this.boundary = boundary;
        this.boundaryStr = new String(boundary);
    }

    public IResponseStream getContent() {
        return this.content;
    }

    public String getContentID() {
        return this.contentID;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Header getHeader(String name) {
        if (this.headers == null || name == null || name.length() == 0) {
            return null;
        }
        return (Header)this.headers.get(name.toLowerCase());
    }

    public String getHeaderValue(String name) {
        if (this.headers == null || name == null || name.length() == 0) {
            return null;
        }
        Header header = (Header)this.headers.get(name.toLowerCase());
        return header != null ? header.getValue() : null;
    }

    public String getHeaderValue(String name, String defaultValue) {
        String value = this.getHeaderValue(name);
        return value != null ? value : defaultValue;
    }

    public Iterator getHeaderNames() {
        if (this.headers == null) {
            return null;
        }
        return new Iterator(){
            private Iterator iter;
            {
                this.iter = ResponsePart.this.headers.keySet().iterator();
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                Header header = (Header)ResponsePart.this.headers.get(this.iter.next());
                if (header != null) {
                    return header.getName();
                }
                return null;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public InputStream getStream() {
        return this.content;
    }

    public void releaseStream() throws IOException {
        if (this.content != null) {
            this.content.endPart(false);
        }
    }

    public IResponseEntity getEntity() {
        return this.entity;
    }

    public void setEntity(IResponseEntity entity) {
        this.entity = entity;
    }

    public boolean initialize(PartitionInputStream source) throws IOException, HTTPException {
        String line = null;
        line = source.readLine(true, true);
        if (line.startsWith(this.boundaryStr)) {
            if (line.endsWith("--")) {
                return false;
            }
        } else {
            throw new HTTPException("Invalid multipart body: boundary " + this.boundary + " expected");
        }
        Header currentHeader = null;
        line = source.readLine(true, true);
        while (line != null && !line.equals(END_OF_LINE)) {
            if (Character.isWhitespace(line.charAt(0)) && currentHeader != null) {
                currentHeader.appendPart(line.trim(), " ");
            } else {
                currentHeader = new Header(line);
                this.setHeader(currentHeader, true);
            }
            TRACE.debugT("initialize(ResponsePart)", line);
            line = source.readLine(false, false);
        }
        TRACE.debugT("initialize(ResponsePart)", " ");
        String length = this.getHeaderValue("Content-Length");
        try {
            this.contentLength = length != null ? Long.parseLong(length) : -1L;
        }
        catch (NumberFormatException e) {
            TRACE.catching("initialize(PartitionInputStream)", (Throwable)e);
            this.contentLength = -1L;
        }
        this.contentType = this.getHeaderValue("Content-Type");
        this.contentID = this.getHeaderValue("Content-ID");
        this.content = source;
        return true;
    }

    private void setHeader(Header header, boolean append) {
        String name = header.getName();
        if (name != null && name.length() > 0) {
            if (!append || this.headers == null) {
                this.setHeader(header);
            } else {
                Header existingHeader = (Header)this.headers.get(name.toLowerCase());
                if (existingHeader == null) {
                    this.setHeader(header);
                } else {
                    existingHeader.appendPart(header.getValue(), ", ");
                }
            }
        }
    }

    private void setHeader(Header header) {
        String name = header.getName();
        if (name != null && name.length() > 0) {
            if (this.headers == null) {
                this.headers = new HashMap();
            }
            this.headers.put(name.toLowerCase(), header);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

