/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.multipart;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IRequestStream;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResponseEntityBase;
import com.tssap.dtr.client.lib.protocol.multipart.IPartParser;
import com.tssap.dtr.client.lib.protocol.multipart.IRequestPart;
import com.tssap.dtr.client.lib.protocol.multipart.IResponsePart;
import com.tssap.dtr.client.lib.protocol.multipart.RequestPart;
import com.tssap.dtr.client.lib.protocol.multipart.ResponsePart;
import com.tssap.dtr.client.lib.protocol.streams.PartitionInputStream;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import com.tssap.dtr.client.lib.protocol.util.GUID;
import com.tssap.dtr.client.lib.protocol.util.Pair;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class MultiPartEntity
extends ResponseEntityBase
implements IRequestEntity,
IResponseEntity {
    public static final String MULTIPART_RELATED = "multipart/related";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    public static final String MULTIPART_ALTERNATIVE = "multipart/alternative";
    private static final String CRLF = "\r\n";
    private static final byte[] FINIS = "--".getBytes();
    private byte[] boundary;
    private String boundaryStr;
    private String multipartType;
    private String start;
    private String type;
    private List requestParts;
    private Map responseParts;
    private List contentIDs;
    private List headers;
    private boolean supportsReset = true;
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$multipart$MultiPartEntity == null ? (class$com$tssap$dtr$client$lib$protocol$multipart$MultiPartEntity = MultiPartEntity.class$("com.tssap.dtr.client.lib.protocol.multipart.MultiPartEntity")) : class$com$tssap$dtr$client$lib$protocol$multipart$MultiPartEntity));
    public static final String ENTITY_TYPE = "MultiPartEntity";
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$multipart$MultiPartEntity;

    public MultiPartEntity(String multipartType) {
        super(multipartType);
        this.multipartType = multipartType;
        this.boundaryStr = this.getBoundary();
        this.boundary = this.getBoundary(this.boundaryStr);
        this.contentType = this._getContentType();
    }

    public MultiPartEntity(String multipartType, String startID, String startType) {
        super(multipartType);
        this.multipartType = multipartType;
        this.boundaryStr = this.getBoundary();
        this.boundary = this.getBoundary(this.boundaryStr);
        this.start = startID;
        this.type = startType;
        this.contentType = this._getContentType();
    }

    public MultiPartEntity(String multipartType, String boundary) {
        super(multipartType);
        this.multipartType = multipartType;
        this.boundary = this.getBoundary(boundary);
        this.boundaryStr = boundary;
        this.contentType = this._getContentType();
    }

    public MultiPartEntity(String multipartType, String boundary, String startID, String startType) {
        super(multipartType);
        this.multipartType = multipartType;
        this.boundary = this.getBoundary(boundary);
        this.boundaryStr = boundary;
        this.start = startID;
        this.type = startType;
        this.contentType = this._getContentType();
    }

    public MultiPartEntity(IResponse response, IPartParser parser) throws HTTPException {
        super(response);
        int i = 0;
        while (i < this.contentTypeParams.size()) {
            Pair param = (Pair)this.contentTypeParams.get(i);
            String pname = param.getName();
            if ("boundary".equalsIgnoreCase(pname)) {
                this.boundaryStr = param.getValue();
                this.boundary = this.getBoundary(this.boundaryStr);
            } else if ("start".equalsIgnoreCase(pname)) {
                this.start = param.getValue();
            } else if ("type".equalsIgnoreCase(pname)) {
                this.type = param.getValue();
            }
            ++i;
        }
        try {
            PartitionInputStream in = new PartitionInputStream(response.getContent());
            in.beginPart(this.boundary);
            in.skipContent();
            in.endPart(false);
            this.responseParts = new HashMap();
            this.contentIDs = new ArrayList();
            ResponsePart part = new ResponsePart(this.boundary);
            while (part.initialize(in)) {
                long contentLength = part.getContentLength();
                if (contentLength > 0L) {
                    in.beginPart(this.boundary, contentLength);
                } else if (!parser.isSelfDelimiting(part)) {
                    in.beginPart(this.boundary);
                }
                IResponseEntity entity = parser.parse(part);
                part.setEntity(entity);
                part.releaseStream();
                String contentID = part.getContentID();
                this.responseParts.put(contentID, part);
                this.contentIDs.add(contentID);
                part = new ResponsePart(this.boundary);
            }
            in.skipContent();
        }
        catch (IOException ex) {
            this.contentType = null;
            throw new HTTPException("Unable to parse multipart response.", ex);
        }
    }

    public static boolean isMultiPartEntity(IResponseEntity entity) {
        return ENTITY_TYPE.equals(entity.getEntityType());
    }

    public static MultiPartEntity valueOf(IResponseEntity entity) {
        return MultiPartEntity.isMultiPartEntity(entity) ? (MultiPartEntity)entity : null;
    }

    public String getEntityType() {
        return ENTITY_TYPE;
    }

    public String getContentType() {
        if (this.contentType == null) {
            this.contentType = this._getContentType();
        }
        return this.contentType;
    }

    public void addRequestPart(String contentID, IRequestEntity entity) {
        this.addRequestPart(new RequestPart(contentID, entity));
    }

    public void addRequestPart(IRequestPart part) {
        if (this.requestParts == null) {
            this.requestParts = new ArrayList();
            this.headers = new ArrayList();
            this.contentIDs = new ArrayList();
            this.contentLength = this.boundary.length + FINIS.length;
        }
        this.requestParts.add(part);
        this.contentIDs.add(part.getContentID());
        byte[] header = this.getPartHeader(part);
        this.headers.add(header);
        long partContentLength = part.getContentLength();
        if (this.contentLength >= 0L) {
            this.contentLength = partContentLength < 0L ? -1L : (this.contentLength += (long)(this.boundary.length + CRLF.length() + header.length + CRLF.length()) + partContentLength);
        }
        this.supportsReset &= part.getEntity().supportsReset();
    }

    public void addRequestParts(IRequestPart[] parts) {
        int i = 0;
        while (i < parts.length) {
            this.addRequestPart(parts[i]);
            ++i;
        }
    }

    public int countResponseParts() {
        return this.contentIDs.size();
    }

    public List getContentIDs() {
        return this.contentIDs;
    }

    public IResponsePart getResponsePart(int index) {
        IResponsePart result = null;
        if (index < this.contentIDs.size()) {
            String contentID = (String)this.contentIDs.get(index);
            result = (IResponsePart)this.responseParts.get(contentID);
        }
        return result;
    }

    public IResponsePart getResponsePart(String contentID) {
        return (IResponsePart)this.responseParts.get(contentID);
    }

    public Iterator getResponseParts() {
        return new Iterator(){
            private int i = 0;

            public boolean hasNext() {
                return this.i < MultiPartEntity.this.contentIDs.size();
            }

            public Object next() {
                if (this.i < MultiPartEntity.this.contentIDs.size()) {
                    String contentID = (String)MultiPartEntity.this.contentIDs.get(this.i);
                    ++this.i;
                    return MultiPartEntity.this.responseParts.get(contentID);
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void write(IRequestStream destination) throws IOException {
        if (this.requestParts != null && this.requestParts.size() > 0) {
            int i = 0;
            Iterator iter = this.requestParts.iterator();
            while (iter.hasNext()) {
                destination.write(this.boundary);
                destination.write(CRLF.getBytes());
                IRequestPart part = (IRequestPart)iter.next();
                destination.write((byte[])this.headers.get(i));
                destination.write(CRLF.getBytes());
                part.getEntity().write(destination);
                ++i;
            }
            destination.write(this.boundary);
            destination.write(FINIS);
        }
    }

    public void reset() throws IOException {
        if (!this.supportsReset) {
            throw new IOException("Entity does not support reset.");
        }
        if (this.requestParts != null && this.requestParts.size() > 0) {
            Iterator iter = this.requestParts.iterator();
            while (iter.hasNext()) {
                IRequestPart part = (IRequestPart)iter.next();
                part.getEntity().reset();
            }
        }
    }

    public boolean supportsReset() {
        return this.supportsReset;
    }

    private byte[] getPartHeader(IRequestPart part) {
        StringBuffer sb = new StringBuffer();
        Iterator iter = part.getHeaderNames();
        if (this.headers != null) {
            while (iter.hasNext()) {
                String name = (String)iter.next();
                String value = part.getHeaderValue(name);
                if (value == null || value.length() <= 0) continue;
                sb.append(name).append(": ").append(value).append(CRLF);
            }
        }
        try {
            return Encoder.getBytes(sb.toString(), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Java Runtime does not support ISO-8859-1 encoding");
        }
    }

    private byte[] getBoundary(String boundary) {
        try {
            if (boundary == null) {
                return Encoder.getBytes(this.getBoundary(), "ISO-8859-1");
            }
            return Encoder.getBytes(boundary, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            TRACE.catching("getBoundary(String)", (Throwable)e);
            return new byte[]{45, 45, 45, 45, 45, 80, 65, 82, 84};
        }
    }

    private String getBoundary() {
        return "-----PART." + this.getGUID();
    }

    private String getGUID() {
        return new GUID().toString();
    }

    private String _getContentType() {
        StringBuffer sb = new StringBuffer(this.multipartType);
        sb.append("; boundary=").append(this.boundaryStr);
        if (this.start != null) {
            sb.append("; start=\"").append(this.start).append("\"");
        }
        if (this.type != null) {
            sb.append("; type=\"").append(this.type).append("\"");
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

