/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.entities;

import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IRequestStream;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResponseEntityBase;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLDOMEntity
extends ResponseEntityBase
implements IRequestEntity,
IResponseEntity {
    private Document document;
    private int standalone = -1;
    public static final String ENTITY_TYPE = "XMLDOMEntity";

    public XMLDOMEntity(Document document) {
        this(document, "UTF-8");
    }

    public XMLDOMEntity(Document document, String contentCharset) {
        super("text/xml");
        this.contentCharset = contentCharset;
        this.document = document;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone ? 1 : 0;
    }

    public XMLDOMEntity(IResponse response, DocumentBuilder builder) throws HTTPException {
        super(response);
        try {
            this.read(response.getStream(), builder);
        }
        catch (Exception ex) {
            this.document = null;
            throw new HTTPException("Failed to parse response body.", ex);
        }
    }

    public static boolean isXMLDOMEntity(IResponseEntity entity) {
        return ENTITY_TYPE.equals(entity.getEntityType());
    }

    public static XMLDOMEntity valueOf(IResponseEntity entity) {
        return XMLDOMEntity.isXMLDOMEntity(entity) ? (XMLDOMEntity)entity : null;
    }

    public String getEntityType() {
        return ENTITY_TYPE;
    }

    public Document getDocument() {
        return this.document;
    }

    public void write(IRequestStream destination) throws IOException {
        if (this.contentCharset == null) {
            this.contentCharset = "UTF-8";
        }
        OutputStreamWriter writer = new OutputStreamWriter(destination.asStream(), this.contentCharset);
        this.serializeNode(this.document, writer);
        ((Writer)writer).flush();
    }

    public void reset() {
    }

    public boolean supportsReset() {
        return true;
    }

    public void read(InputStream source, DocumentBuilder builder) throws IOException, SAXException {
        if (source != null) {
            this.document = builder.parse(source);
        }
    }

    private void serializeNode(Node node, Writer writer) throws IOException {
        if (node == null) {
            return;
        }
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 9: {
                writer.write("<?xml version=\"1.0\" encoding=\"");
                writer.write(this.contentCharset);
                if (this.standalone >= 0) {
                    writer.write(" standalone=");
                    if (this.standalone == 0) {
                        writer.write("\"no\"");
                    } else {
                        writer.write("\"yes\"");
                    }
                }
                writer.write("\"?>");
                Node child = node.getFirstChild();
                while (child != null) {
                    this.serializeNode(child, writer);
                    child = child.getNextSibling();
                }
                break;
            }
            case 7: {
                writer.write("<?");
                writer.write(node.getNodeName());
                String value = node.getNodeValue();
                if (value != null && value.length() > 0) {
                    writer.write(32);
                    writer.write(value);
                }
                writer.write("?>");
                break;
            }
            case 10: {
                String internalSubset;
                DocumentType docTypeNode = (DocumentType)node;
                writer.write("<!DOCTYPE ");
                writer.write(docTypeNode.getName());
                String systemID = docTypeNode.getSystemId();
                String publicID = docTypeNode.getPublicId();
                if (publicID != null) {
                    writer.write(" PUBLIC \"");
                    writer.write(publicID);
                    writer.write("\"");
                }
                if (systemID != null) {
                    if (publicID == null) {
                        writer.write(" SYSTEM");
                    }
                    writer.write(" \"");
                    writer.write(systemID);
                    writer.write("\"");
                }
                if ((internalSubset = docTypeNode.getInternalSubset()) != null) {
                    // empty if block
                }
                writer.write(">");
                break;
            }
            case 8: {
                writer.write("<!--");
                writer.write(node.getNodeValue());
                writer.write("-->");
                break;
            }
            case 1: {
                NodeList children;
                writer.write("<");
                writer.write(node.getNodeName());
                NamedNodeMap attributes = node.getAttributes();
                if (attributes != null) {
                    int i = 0;
                    while (i < attributes.getLength()) {
                        Attr attribute = (Attr)attributes.item(i);
                        writer.write(" ");
                        writer.write(attribute.getNodeName());
                        writer.write("=\"");
                        writer.write(Encoder.encodeXml(attribute.getValue()));
                        writer.write("\"");
                        ++i;
                    }
                }
                if ((children = node.getChildNodes()).getLength() > 0) {
                    writer.write(">");
                    int i = 0;
                    while (i < children.getLength()) {
                        this.serializeNode(children.item(i), writer);
                        ++i;
                    }
                    writer.write("</");
                    writer.write(node.getNodeName());
                    writer.write(">");
                    break;
                }
                writer.write("/>");
                break;
            }
            case 3: {
                writer.write(Encoder.encodeXml(node.getNodeValue()));
                break;
            }
            case 5: {
                writer.write(38);
                writer.write(node.getNodeName());
                writer.write(59);
                break;
            }
            case 4: {
                writer.write("<![CDATA[");
                writer.write(node.getNodeValue());
                writer.write("]]>");
                break;
            }
        }
    }
}

