/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.entities;

import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IRequestStream;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.IResponseStream;
import com.tssap.dtr.client.lib.protocol.entities.ResponseEntityBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamEntity
extends ResponseEntityBase
implements IRequestEntity,
IResponseEntity {
    private InputStream in;
    private OutputStream out;
    public static final String ENTITY_TYPE = "StreamEntity";

    public StreamEntity(InputStream in, String contentType) {
        super(contentType);
        this.in = in;
    }

    public StreamEntity(OutputStream out, IResponse response) throws HTTPException {
        super(response);
        this.out = out;
        try {
            this.read(response.getContent());
        }
        catch (IOException ex) {
            this.contentType = null;
            throw new HTTPException("Failed to read response body to stream.", ex);
        }
    }

    public static boolean isStreamEntity(IResponseEntity entity) {
        return ENTITY_TYPE.equals(entity.getEntityType());
    }

    public static StreamEntity valueOf(IResponseEntity entity) {
        return StreamEntity.isStreamEntity(entity) ? (StreamEntity)entity : null;
    }

    public String getEntityType() {
        return ENTITY_TYPE;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public void setContentMD5(String contentMD5) {
        this.contentMD5 = contentMD5;
    }

    public void read(IResponseStream source) throws IOException {
        if (this.out != null && source != null) {
            int cnt = source.read(this.out);
            while (cnt > 0) {
                cnt = source.read(this.out);
            }
        }
    }

    public void write(IRequestStream destination) throws IOException {
        if (this.in != null) {
            destination.write(this.in);
        }
    }

    public void reset() {
    }

    public boolean supportsReset() {
        return false;
    }
}

