/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.entities;

import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.SAXResponseEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class OptionEntity
extends SAXResponseEntity {
    private HashMap collections;
    private int state = 0;
    private int recoverState;
    private String recoverName;
    private Element collection;
    private Map functionalities;
    private List options;
    private String functionality;
    private String tagName;
    private static final int INIT = 0;
    private static final int FINAL = 1;
    private static final int RECOVERY_MODE = 2;
    private static final int OPTIONS_RESPONSE = 3;
    private static final int HREF_COLLECTION = 4;
    private static final int FUNCTIONALITY_SET = 10;
    private static final int FUNCTIONALITY = 15;
    private static final int OPTION = 20;
    public static final String ENTITY_TYPE = "OptionEntity";

    public static boolean isOptionEntity(IResponseEntity entity) {
        return ENTITY_TYPE.equals(entity.getEntityType());
    }

    public static OptionEntity valueOf(IResponseEntity entity) {
        return OptionEntity.isOptionEntity(entity) ? (OptionEntity)entity : null;
    }

    public OptionEntity(IResponse response) {
        super.initialize(response);
    }

    public String getEntityType() {
        return ENTITY_TYPE;
    }

    public Element getCollectionsSet(String collectionSet) {
        return this.collections != null ? (Element)this.collections.get(collectionSet) : null;
    }

    public List getFunctionalitySet() {
        return this.functionalities != null ? new ArrayList(this.functionalities.keySet()) : new ArrayList();
    }

    public List getFunctionality(String functionality) {
        return (List)this.functionalities.get(functionality);
    }

    public void startElement(String uri, String name, String qualifiedName, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 0: {
                if (name.equals("options-response")) {
                    this.state = 3;
                    return;
                }
                throw new SAXException("OptionEntity: Server Error, options-response Root Tag Expected");
            }
            case 1: {
                throw new SAXException("OptionEntity: Server Error, Multiple Root Tags Found");
            }
            case 3: {
                if (name.equals("workspace-collection-set") || name.equals("version-history-collection-set") || name.equals("activity-collection-set")) {
                    this.collection = new Element(qualifiedName, uri);
                    this.tagName = name;
                    this.state = 4;
                    return;
                }
                if (!name.equals("functionality-set")) break;
                this.tagName = name;
                this.functionalities = new HashMap();
                this.state = 10;
                return;
            }
            case 10: {
                if (!name.equals("functionality")) break;
                this.tagName = name;
                this.functionality = attributes.getValue("name");
                if (this.functionality == null) {
                    throw new SAXException("OptionEntity: Server Error, Mandatory attribute 'name' missing in <functionality>");
                }
                this.options = new ArrayList();
                this.functionalities.put(this.functionality, this.options);
                this.state = 15;
                return;
            }
            case 15: {
                if (!name.equals("option")) break;
                this.tagName = name;
                String option = attributes.getValue("name");
                if (option == null) {
                    throw new SAXException("OptionEntity: Server Error, Mandatory attribute 'name' missing in <option>");
                }
                this.options.add(option);
                this.state = 20;
                return;
            }
            case 4: {
                if (!name.equals("href")) break;
                return;
            }
            default: {
                throw new SAXException("OptionEntity: Client Error, Undefined Parser State");
            }
        }
        this.recoverName = name;
        this.recoverState = this.state;
        this.state = 2;
    }

    public void endElement(String uri, String name, String qualifiedName) throws SAXException {
        switch (this.state) {
            case 2: {
                if (!name.equals(this.recoverName)) break;
                this.recoverName = null;
                this.state = this.recoverState;
                break;
            }
            case 4: {
                if (name.equals(this.tagName)) {
                    if (this.collections == null) {
                        this.collections = new HashMap();
                    }
                    this.collections.put(this.tagName, this.collection);
                    this.state = 3;
                    break;
                }
                if (!name.equals("href")) break;
                this.collection.addChild(qualifiedName, this.getStringValue(), uri);
                break;
            }
            case 10: {
                this.state = 3;
                break;
            }
            case 15: {
                this.options = null;
                this.state = 10;
                break;
            }
            case 20: {
                this.state = 15;
                break;
            }
            case 3: {
                this.state = 1;
                break;
            }
            default: {
                throw new SAXException("OptionEntity: Client Error, Undefined Parser State");
            }
        }
    }
}

