/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.entities;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.entities.Collision;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.entities.SAXResponseEntity;
import com.tssap.dtr.client.lib.protocol.impl.ResponseFactory;
import com.tssap.dtr.client.lib.protocol.requests.IResourceListener;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class MultiStatusEntity
extends SAXResponseEntity {
    private ArrayList resources;
    private String responseDescription;
    private IResourceListener resourceListener;
    private static final int INIT = 0;
    private static final int RECOVERY_MODE = 1;
    private static final int FINAL = 2;
    private static final int MULTISTATUS = 3;
    private static final int MULTISTATUS_SEQUENCE = 4;
    private static final int RESPONSE = 5;
    private static final int MULTISTATUS_DESCRIPTION = 6;
    private static final int RESPONSE_HREF = 7;
    private static final int PROPSTAT = 8;
    private static final int RESPONSE_SEQUENCE = 9;
    private static final int RESPONSE_DESCRIPTION = 10;
    private static final int RESPONSE_FINAL = 11;
    private static final int PROPSTAT_SEQUENCE = 12;
    private static final int PROPSTAT_DESCRIPTION = 14;
    private static final int PROPSTAT_FINAL = 15;
    private static final int MULTISTATUS_FINAL = 16;
    private static final int PROP = 17;
    private static final int PROPSTAT_STATUS = 18;
    private static final int PROP_CHILD = 19;
    private static final int RESPONSE_HREF_SEQUENCE = 20;
    private static final int RESPONSE_STATUS = 21;
    private static final int COLLISION = 22;
    private static final int WORKSPACE_VERSION = 23;
    private static final int VCR = 24;
    private static final int ORIGINAL_VERSION = 25;
    private static final int COLLISION_TYPE = 26;
    private static final int COLLISION_FINAL = 27;
    private static final int COLLISION_SEQUENCE = 28;
    private static final int MULTISTATUS_ERROR_DESCRIPTION = 29;
    private static final int RESPONSE_ERROR_DESCRIPTION = 30;
    private static final int PROPSTAT_ERROR_DESCRIPTION = 31;
    private int state = 0;
    private int recoverState;
    private String recoverName;
    private Stack resourceStack;
    private ResourceElement resource;
    private PropertyElement property;
    private Collision collision;
    private Element child;
    private String href;
    private String description;
    private String extdescription;
    private String propertyStatus;
    private String rootTag;
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$entities$MultiStatusEntity == null ? (class$com$tssap$dtr$client$lib$protocol$entities$MultiStatusEntity = MultiStatusEntity.class$("com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity")) : class$com$tssap$dtr$client$lib$protocol$entities$MultiStatusEntity));
    public static final String ENTITY_TYPE = "MultiStatusEntity";
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$entities$MultiStatusEntity;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$impl$MultiStatusResponse;

    public MultiStatusEntity(String path, IResponse response) {
        super.initialize(response);
        this.href = path;
    }

    public static boolean isMultiStatusEntity(IResponseEntity entity) {
        return ENTITY_TYPE.equals(entity.getEntityType());
    }

    public static MultiStatusEntity valueOf(IResponseEntity entity) {
        return MultiStatusEntity.isMultiStatusEntity(entity) ? (MultiStatusEntity)entity : null;
    }

    public String getEntityType() {
        return ENTITY_TYPE;
    }

    public int countResources() {
        return this.resources != null ? this.resources.size() : 0;
    }

    public ResourceElement getResource(int i) {
        return this.resources != null && i < this.resources.size() ? (ResourceElement)this.resources.get(i) : null;
    }

    public Iterator getResources() {
        return this.resources != null ? ((AbstractList)this.resources).iterator() : null;
    }

    public String getResponseDescription() {
        return this.responseDescription;
    }

    public void setResourceListener(IResourceListener listener) {
        this.resourceListener = listener;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        switch (this.state) {
            case 0: {
                if (localName.equals("multistatus")) {
                    this.rootTag = "multistatus";
                    this.state = 3;
                    return;
                }
                if (localName.equals("prop")) {
                    this.rootTag = "prop";
                    this.resource = new ResourceElement(this.href);
                    this.state = 17;
                } else {
                    throw new SAXException("MultiStatusEntity: Server Error, Multistatus Root Tag Expected");
                }
            }
            case 1: {
                return;
            }
            case 2: {
                throw new SAXException("MultiStatusEntity: Server Error, Multiple Root Tags Found");
            }
            case 3: {
                if (!localName.equals("response")) break;
                this.state = 5;
                return;
            }
            case 4: {
                if (localName.equals("response")) {
                    this.state = 5;
                    return;
                }
                if (!localName.equals("responsedescription")) break;
                this.state = 6;
                return;
            }
            case 6: {
                if (!localName.equals("error")) break;
                this.state = 29;
                return;
            }
            case 29: {
                this.responseDescription = qName;
                return;
            }
            case 5: {
                if (!localName.equals("href")) break;
                this.state = 7;
                return;
            }
            case 7: {
                if (localName.equals("propstat")) {
                    this.resource = new ResourceElement(this.href);
                    this.propertyStatus = null;
                    this.description = null;
                    this.state = 8;
                    return;
                }
                if (localName.equals("href")) {
                    this.resource = new ResourceElement(this.href);
                    this.state = 20;
                    return;
                }
                if (localName.equals("collision")) {
                    this.resource = new ResourceElement(this.href);
                    this.collision = new Collision();
                    this.state = 22;
                    return;
                }
                if (!localName.equals("status")) break;
                this.resource = new ResourceElement(this.href);
                this.state = 21;
                return;
            }
            case 9: {
                if (localName.equals("propstat")) {
                    this.state = 8;
                    return;
                }
                if (!localName.equals("responsedescription")) break;
                this.state = 10;
                return;
            }
            case 20: {
                if (localName.equals("href")) {
                    return;
                }
                if (!localName.equals("status")) break;
                this.state = 21;
                return;
            }
            case 28: {
                if (localName.equals("collision")) {
                    this.collision = new Collision();
                    this.state = 22;
                    return;
                }
                if (localName.equals("status")) {
                    this.state = 21;
                    return;
                }
            }
            case 27: {
                break;
            }
            case 21: {
                if (!localName.equals("responsedescription")) break;
                this.state = 10;
                return;
            }
            case 10: {
                if (!localName.equals("error")) break;
                this.state = 30;
                return;
            }
            case 30: {
                if (uri.equals("DAV:")) {
                    this.description = qName;
                } else {
                    this.extdescription = qName;
                }
                return;
            }
            case 11: {
                break;
            }
            case 8: {
                if (!localName.equals("prop")) break;
                this.state = 17;
                return;
            }
            case 12: {
                if (!localName.equals("status")) break;
                this.state = 18;
                return;
            }
            case 18: {
                if (!localName.equals("responsedescription")) break;
                this.state = 14;
                return;
            }
            case 14: {
                if (!localName.equals("error")) break;
                this.state = 31;
                return;
            }
            case 31: {
                if (uri.equals("DAV:")) {
                    this.description = qName;
                } else {
                    this.extdescription = qName;
                }
                return;
            }
            case 15: {
                break;
            }
            case 17: {
                if (localName.equals("response")) {
                    if (this.resourceStack == null) {
                        this.resourceStack = new Stack();
                    }
                    this.resourceStack.push(this.resource);
                    this.resourceStack.push(this.property);
                    this.property = null;
                    this.state = 5;
                } else {
                    if (this.property == null) {
                        this.property = new PropertyElement(qName, uri);
                        return;
                    }
                    this.property.addChild(qName, uri);
                    this.state = 19;
                    this.child = this.property.lastChild();
                }
                return;
            }
            case 19: {
                this.child.addChild(qName, uri);
                this.child = this.child.lastChild();
                return;
            }
            case 22: {
                if (!localName.equals("workspace-version")) break;
                this.state = 23;
                return;
            }
            case 23: {
                if (!localName.equals("vcr")) break;
                this.state = 24;
                return;
            }
            case 24: {
                if (localName.equals("original-version")) {
                    this.state = 25;
                    return;
                }
            }
            case 25: {
                if (!localName.equals("collision-type")) break;
                this.state = 26;
                return;
            }
            default: {
                throw new SAXException("internal state error: startTag(" + this.rootTag + ") state(" + this.state + ")");
            }
        }
        this.recoverName = localName;
        this.recoverState = this.state;
        this.clearBuffer();
        this.state = 1;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (this.state) {
            case 1: {
                if (!localName.equals(this.recoverName)) break;
                this.recoverName = null;
                this.state = this.recoverState;
                break;
            }
            case 3: {
                this.state = 2;
                break;
            }
            case 6: {
                this.responseDescription = this.getStringValue();
                this.state = 16;
                break;
            }
            case 29: {
                if (!localName.equals("responsedescription")) break;
                this.state = 16;
                break;
            }
            case 4: 
            case 16: {
                if (!localName.equals("multistatus")) break;
                this.state = 2;
                break;
            }
            case 7: {
                this.href = this.getStringValue();
                break;
            }
            case 20: {
                this.resource.addPath(this.getStringValue());
                break;
            }
            case 10: {
                this.resource.setErrorCondition(this.getStringValue());
                this.description = null;
                this.state = 11;
                break;
            }
            case 30: {
                if (localName.equals("error")) {
                    this.resource.setErrorCondition(this.description);
                    this.resource.setExtendedCondition(this.extdescription);
                    this.description = null;
                    this.extdescription = null;
                    break;
                }
                if (!localName.equals("responsedescription")) break;
                this.state = 11;
                break;
            }
            case 21: {
                if (localName.equals("status")) {
                    this.resource.setStatus(this.getStringValue());
                    break;
                }
            }
            case 9: 
            case 11: {
                if (!localName.equals("response")) break;
                if (this.resourceStack == null || this.resourceStack.empty()) {
                    this.storeResource(this.resource);
                    this.resource = null;
                    this.state = 4;
                    break;
                }
                this.property = (PropertyElement)this.resourceStack.pop();
                this.property.addExpandedResource(this.resource);
                this.resource = (ResourceElement)this.resourceStack.pop();
                this.state = 17;
                break;
            }
            case 18: {
                if (localName.equals("status")) {
                    this.propertyStatus = this.getStringValue();
                    break;
                }
            }
            case 15: {
                if (!localName.equals("propstat")) break;
                if (this.propertyStatus != null) {
                    try {
                        this.resource.touchChildrenStatus(this.propertyStatus, this.description, this.extdescription);
                    }
                    catch (NumberFormatException ex) {
                        TRACE.catching("endElement(String,String,String)", (Throwable)ex);
                        this.resource.touchChildrenStatus("500 Internal Server Error", null, null);
                    }
                    this.propertyStatus = null;
                    this.description = null;
                    this.extdescription = null;
                }
                this.state = 9;
                break;
            }
            case 14: {
                this.description = this.getStringValue();
                this.state = 15;
                break;
            }
            case 31: {
                if (!localName.equals("responsedescription")) break;
                this.state = 15;
                break;
            }
            case 17: {
                if (localName.equals("prop")) {
                    if (this.rootTag.equals("prop")) {
                        if (this.property != null) {
                            this.property.setStatusCode(200);
                            this.property.setStatusDescription("OK");
                            this.storeResource(this.resource);
                            this.resource = null;
                        }
                        this.state = 2;
                        break;
                    }
                    this.state = 12;
                    break;
                }
                if (!qName.equals(this.property.getQualifiedName())) break;
                if (this.property.firstChild() == null) {
                    this.property.setValue(this.getStringValue());
                }
                this.resource.addChild(this.property);
                this.property = null;
                break;
            }
            case 19: {
                if (this.child.firstChild() == null) {
                    this.child.setValue(this.getStringValue());
                }
                if (this.child.getParent() != null) {
                    this.child = this.child.getParent();
                    break;
                }
                this.resource.addChild(this.property);
                this.property = null;
                this.state = 17;
                break;
            }
            case 23: {
                this.collision.setWorkspaceVersion(this.getStringValue());
                break;
            }
            case 24: {
                if (localName.equals("vcr")) {
                    this.collision.setVCR(this.getStringValue());
                    break;
                }
            }
            case 25: {
                if (localName.equals("original-version")) {
                    this.collision.setOriginalVersion(this.getStringValue());
                    break;
                }
            }
            case 27: 
            case 28: {
                if (localName.equals("collision")) {
                    this.resource.addCollision(this.collision);
                    this.collision = null;
                    this.state = 28;
                    break;
                }
                if (!localName.equals("response")) break;
                this.storeResource(this.resource);
                this.resource = null;
                this.state = 4;
                break;
            }
            case 26: {
                this.collision.setCollisionType(this.getStringValue());
                this.state = 27;
                break;
            }
            default: {
                throw new SAXException("internal state error: endTag(" + this.rootTag + ") state(" + this.state + ")");
            }
        }
    }

    private void storeResource(ResourceElement resource) throws SAXException {
        boolean store = true;
        if (this.resourceListener != null) {
            try {
                store = this.resourceListener.notifyResource(resource, null);
            }
            catch (IOException e) {
                throw new SAXException("Evaluation of a resource element failed [" + resource.getPath() + "]", e);
            }
            catch (HTTPException e) {
                throw new SAXException("Evaluation of a resource element failed [" + resource.getPath() + "]", e);
            }
        }
        if (store) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ResponseFactory.registerEntityType(ENTITY_TYPE, class$com$tssap$dtr$client$lib$protocol$impl$MultiStatusResponse == null ? (class$com$tssap$dtr$client$lib$protocol$impl$MultiStatusResponse = MultiStatusEntity.class$("com.tssap.dtr.client.lib.protocol.impl.MultiStatusResponse")) : class$com$tssap$dtr$client$lib$protocol$impl$MultiStatusResponse);
    }
}

