/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.entities;

import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IRequestStream;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.IResponseStream;
import com.tssap.dtr.client.lib.protocol.entities.ResponseEntityBase;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class FileEntity
extends ResponseEntityBase
implements IRequestEntity,
IResponseEntity {
    private File file;
    public static final String ENTITY_TYPE = "FileEntity";

    public FileEntity(File file, String contentType) {
        super(contentType);
        this.file = file;
    }

    public FileEntity(File file, IResponse response) throws HTTPException {
        super(response);
        this.file = file;
        try {
            this.read(response.getContent());
        }
        catch (IOException ex) {
            this.contentType = null;
            throw new HTTPException("Failed to read response body to file.", ex);
        }
    }

    public static boolean isFileEntity(IResponseEntity entity) {
        return ENTITY_TYPE.equals(entity.getEntityType());
    }

    public static FileEntity valueOf(IResponseEntity entity) {
        return FileEntity.isFileEntity(entity) ? (FileEntity)entity : null;
    }

    public String getEntityType() {
        return ENTITY_TYPE;
    }

    public long getContentLength() {
        return this.file.length();
    }

    public void setContentMD5(String contentMD5) {
        this.contentMD5 = contentMD5;
    }

    public String calculateMD5() throws NoSuchAlgorithmException, IOException {
        if (this.file != null) {
            MessageDigest MD5 = MessageDigest.getInstance("MD5");
            FileInputStream in = new FileInputStream(this.file);
            byte[] buf = new byte[2048];
            int count = -1;
            while ((count = in.read(buf)) != -1) {
                MD5.update(buf, 0, count);
            }
            byte[] digest = MD5.digest();
            return Encoder.toHexString(digest);
        }
        return null;
    }

    public void read(IResponseStream source) throws IOException {
        if (this.file != null && source != null) {
            FileOutputStream destination = new FileOutputStream(this.file);
            int cnt = source.read(destination);
            while (cnt > 0) {
                cnt = source.read(destination);
            }
            destination.close();
        }
    }

    public void write(IRequestStream destination) throws IOException {
        if (this.file != null) {
            FileInputStream source = new FileInputStream(this.file);
            destination.write(source);
            source.close();
        }
    }

    public void reset() {
    }

    public boolean supportsReset() {
        return true;
    }
}

