/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseStream;
import com.tssap.dtr.client.lib.protocol.Protocol;
import com.tssap.dtr.client.lib.protocol.impl.URLScanner;
import com.tssap.dtr.client.lib.protocol.requests.http.GetRequest;
import com.tssap.dtr.client.lib.protocol.util.Pair;
import com.tssap.dtr.client.lib.protocol.util.Tokenizer;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class URL {
    private String url;
    private String webLocator;
    private String authority;
    private String protocol;
    private String host;
    private int port = -1;
    private String path;
    private String query;
    private String fragment;
    private List queryParams;
    private Map queryParamsByName;
    private static final int SYM_PROTOCOL = 1;
    private static final int SYM_HOST = 2;
    private static final int SYM_PORT = 3;
    private static final int SYM_PATH = 4;
    private static final int SYM_RELPATH = 5;
    private static final int SYM_QUERY = 6;
    private static final int SYM_FRAGMENT = 7;
    private static final int EOS = 100;
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$URL == null ? (class$com$tssap$dtr$client$lib$protocol$URL = URL.class$("com.tssap.dtr.client.lib.protocol.URL")) : class$com$tssap$dtr$client$lib$protocol$URL));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$URL;

    public URL(String str) throws MalformedURLException {
        this.url = str;
        try {
            this.parse(str, false);
        }
        catch (MalformedURLException ex) {
            throw ex;
        }
        catch (IOException e) {
            TRACE.catching((Throwable)e);
            throw new IllegalArgumentException("Reading from string failed (IOException)");
        }
    }

    public URL(String protocol, String host) {
        this(protocol, host, -1, null, null, null);
    }

    public URL(String protocol, String host, String path) {
        this(protocol, host, -1, path, null, null);
    }

    public URL(String protocol, String host, int port) {
        this(protocol, host, port, null, null, null);
    }

    public URL(String protocol, String host, int port, String path) {
        this(protocol, host, port, path, null, null);
    }

    public URL(String protocol, String host, int port, String path, String query, String fragment) {
        if (protocol != null) {
            this.protocol = protocol;
            int n = this.port = port <= 0 || port >= 65535 ? Protocol.getDefaultPort(protocol) : port;
        }
        if (host != null) {
            this.host = host.trim();
        }
        if (path != null) {
            this.path = path.startsWith("/") ? path : "/" + path;
        }
        this.query = query;
        this.fragment = fragment;
    }

    public URL(URL baseUrl, String s) throws MalformedURLException {
        this.protocol = baseUrl.getProtocol();
        this.host = baseUrl.getHost();
        this.port = baseUrl.getPort();
        this.path = baseUrl.getPath();
        this.query = baseUrl.getQuery();
        this.fragment = baseUrl.getFragment();
        try {
            this.parse(s, true);
        }
        catch (MalformedURLException ex) {
            throw ex;
        }
        catch (IOException e) {
            TRACE.catching((Throwable)e);
            throw new IllegalStateException("Reading from string failed");
        }
    }

    public static URL combine(String left, String right) throws MalformedURLException {
        URL baseUrl = new URL(left);
        return new URL(baseUrl, right);
    }

    public void validate() throws MalformedURLException {
        try {
            this.parse(this.toString(), false);
        }
        catch (MalformedURLException ex) {
            throw ex;
        }
        catch (IOException e) {
            TRACE.catching((Throwable)e);
            throw new IllegalStateException("Reading from string failed");
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDomain() {
        int n;
        String domain = ".local";
        if (this.host != null && (n = this.host.indexOf(46)) > 0) {
            domain = this.host.substring(n);
        }
        return domain;
    }

    public boolean isIPAddress() {
        int n;
        boolean result = false;
        if (this.host != null && (n = this.host.lastIndexOf(46)) > 0 && Character.isDigit(this.host.charAt(n + 1))) {
            result = true;
        }
        return result;
    }

    public InetAddress getIPAddress() throws UnknownHostException {
        if (this.host == null) {
            throw new UnknownHostException("No host defined for this URL");
        }
        return InetAddress.getByName(this.host);
    }

    public String getAuthority() {
        if (this.authority == null && this.host != null) {
            StringBuffer s = new StringBuffer();
            s.append(this.host);
            if (this.port > 0 && this.port != Protocol.getDefaultPort(this.protocol)) {
                s.append(":").append(this.port);
            }
            this.authority = s.toString();
        }
        return this.authority;
    }

    public String getWebLocator() {
        if (this.webLocator == null && this.protocol != null) {
            StringBuffer s = new StringBuffer();
            s.append(this.protocol).append("://");
            s.append(this.getAuthority());
            this.webLocator = s.toString();
        }
        return this.webLocator;
    }

    public String getPath() {
        return this.path != null ? this.path : "/";
    }

    public String getResource() {
        StringBuffer s = new StringBuffer();
        s.append(this.getPath());
        if (this.query != null) {
            s.append("?").append(this.query);
        }
        if (this.fragment != null) {
            s.append("#").append(this.fragment);
        }
        return s.toString();
    }

    public String getQuery() {
        return this.query;
    }

    public String getQueryParameter(String name) {
        if (this.queryParamsByName == null && this.query != null) {
            this.queryParamsByName = new HashMap();
            Iterator iter = this.getQueryParameters();
            while (iter.hasNext()) {
                Pair item = (Pair)iter.next();
                this.queryParamsByName.put(item.getName(), item.getValue());
            }
        }
        return this.queryParamsByName != null ? (String)this.queryParamsByName.get(name) : null;
    }

    public Iterator getQueryParameters() {
        if (this.queryParams == null && this.query != null) {
            this.queryParams = Tokenizer.partsOf(this.query, "&", 0, 61);
        }
        return this.queryParams != null ? this.queryParams.iterator() : null;
    }

    public String getFragment() {
        return this.fragment;
    }

    public Connection openConnection() {
        Connection conn = null;
        if (this.protocol != null && this.host != null) {
            try {
                conn = new Connection(new URL(this.getProtocol(), this.getHost(), this.getPort()));
            }
            catch (MalformedURLException e) {
                TRACE.catching((Throwable)e);
            }
        }
        return conn;
    }

    public IResponseStream openStream() throws IOException, HTTPException {
        GetRequest req;
        Connection conn = this.openConnection();
        IResponse resp = conn.send(req = new GetRequest(this.getResource()), true);
        return resp.getStatus() == 200 ? resp.getContent() : null;
    }

    public static String getDomainOf(String host) {
        String result = null;
        int n = host.indexOf(46);
        int m = host.lastIndexOf(58);
        result = n < 0 || host.indexOf(46, n + 1) < 0 ? ".local" : (m < 0 ? host.substring(n) : host.substring(n, m));
        return result;
    }

    public static boolean isValidURL(String s) {
        try {
            new URL(s);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.url == null) {
            StringBuffer s = new StringBuffer();
            String locator = this.getWebLocator();
            if (locator != null) {
                s.append(locator);
            }
            if (this.path != null) {
                s.append(this.getPath());
            }
            if (this.query != null) {
                s.append("?").append(this.getQuery());
            }
            if (this.fragment != null) {
                s.append("#").append(this.getFragment());
            }
            this.url = s.toString();
        }
        return this.url;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URL)) {
            return false;
        }
        URL u = (URL)obj;
        return (this.getProtocol() != null ? this.getProtocol().equals(u.getProtocol()) : u.getProtocol() == null) && (this.getHost() != null ? this.getHost().equals(u.getHost()) : u.getHost() == null) && this.getPort() == u.getPort() && (this.getPath() != null ? this.getPath().equals(u.getPath()) : u.getPath() == null) && (this.getFragment() != null ? this.getFragment().equals(u.getFragment()) : u.getFragment() == null);
    }

    public int hashCode() {
        int result = 17;
        result = this.getProtocol() != null ? 37 * result + this.getProtocol().hashCode() : result;
        result = this.getHost() != null ? 37 * result + this.getHost().hashCode() : result;
        result = this.getPort() != -1 ? 37 * result + this.getPort() : result;
        result = this.getPath() != null ? 37 * result + this.getPath().hashCode() : result;
        result = this.getFragment() != null ? 37 * result + this.getFragment().hashCode() : result;
        return result;
    }

    private void parse(String str, boolean relative) throws MalformedURLException, IOException {
        int token = 100;
        URLScanner scanner = new URLScanner(new StringReader(str));
        if (relative) {
            scanner.yybegin(10);
        }
        while ((token = scanner.next_token()) != 100) {
            switch (token) {
                case 1: {
                    this.protocol = scanner.yytext();
                    break;
                }
                case 2: {
                    this.host = scanner.yytext();
                    break;
                }
                case 3: {
                    String portStr = scanner.yytext();
                    try {
                        this.port = Integer.parseInt(portStr);
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new MalformedURLException("Invalid port [not a number]");
                    }
                }
                case 4: {
                    this.path = "/" + scanner.yytext();
                    break;
                }
                case 5: {
                    if (this.path == null) {
                        this.path = "/";
                    } else if (!this.path.endsWith("/")) {
                        this.path = this.path + "/";
                    }
                    this.path = this.path + scanner.yytext();
                    break;
                }
                case 6: {
                    this.query = scanner.yytext();
                    break;
                }
                case 7: {
                    this.fragment = scanner.yytext();
                    break;
                }
            }
        }
        if (this.protocol != null) {
            if (!Protocol.isValidProtocol(this.protocol)) {
                throw new MalformedURLException("Unknown protocol [" + this.protocol + "]");
            }
            if (this.port < 0) {
                this.port = Protocol.getDefaultPort(this.protocol);
            } else if (this.port == 0 || this.port > 65535) {
                throw new MalformedURLException("Invalid port '" + this.port + "' [outside allowed range 1..65535]");
            }
        }
        if (this.protocol != null && this.host == null) {
            throw new MalformedURLException("URL with a protocol specifier must have a host");
        }
        if (this.host != null && this.protocol == null) {
            throw new MalformedURLException("URL with a host must have a protocol specifier");
        }
        if (this.host == null && this.path == null) {
            throw new MalformedURLException("URL must at least have a host or a path part");
        }
        if (this.isIPAddress()) {
            List segments = Tokenizer.partsOf(this.host, ".");
            int sz = segments.size();
            if (sz != 4 && sz != 6) {
                throw new MalformedURLException("URL is not a valid IPv4 or IPv6 address [expected to find 4 or 6 segments, but found " + sz + "]");
            }
            int i = 0;
            while (i < sz) {
                try {
                    int n = Integer.parseInt((String)segments.get(i));
                    if (n > 255) {
                        throw new MalformedURLException("URL is not a valid IP address [segement " + i + 1 + " outside allowed range 0..255]");
                    }
                }
                catch (NumberFormatException e) {
                    TRACE.catching((Throwable)e);
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

