/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol;

public final class Protocol {
    private final String name;
    private int defaultPort;
    public static final Protocol HTTP = new Protocol("http", 80);
    public static final Protocol HTTPS = new Protocol("https", 443);

    private Protocol(String name, int defaultPort) {
        this.name = name;
        this.defaultPort = defaultPort;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(String protocol) {
        return this.name.equalsIgnoreCase(protocol);
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public static Protocol valueOf(String s) {
        Protocol protocol;
        if (s.equalsIgnoreCase("http")) {
            protocol = HTTP;
        } else if (s.equalsIgnoreCase("https")) {
            protocol = HTTPS;
        } else {
            throw new IllegalArgumentException("parameter is not recoginized as legal enumeration value");
        }
        return protocol;
    }

    public static boolean isValidProtocol(String s) {
        if (s.equalsIgnoreCase("http")) {
            return true;
        }
        return s.equalsIgnoreCase("https");
    }

    public static int getDefaultPort(String protocol) {
        if (protocol.equalsIgnoreCase("http")) {
            return 80;
        }
        if (protocol.equalsIgnoreCase("https")) {
            return 443;
        }
        return -1;
    }
}

