/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.Header;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.IConnectionMonitor;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.Protocol;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.impl.Response;
import com.tssap.dtr.client.lib.protocol.requests.RequestBase;
import com.tssap.dtr.client.lib.protocol.session.Certificates;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import com.tssap.dtr.client.lib.protocol.socks.ISOCKSProvider;
import com.tssap.dtr.client.lib.protocol.socks.SOCKSv5Provider;
import com.tssap.dtr.client.lib.protocol.ssl.IAIKSecureSocketProvider;
import com.tssap.dtr.client.lib.protocol.ssl.ISecureSocketProvider;
import com.tssap.dtr.client.lib.protocol.ssl.JSSESecureSocketProvider;
import com.tssap.dtr.client.lib.protocol.streams.RequestStream;
import com.tssap.dtr.client.lib.protocol.streams.ResponseStream;
import com.tssap.dtr.client.lib.protocol.util.Query;
import com.tssap.dtr.client.lib.protocol.util.Tokenizer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class Connection
implements IConnection {
    private Socket socket;
    private ResponseStream in;
    private RequestStream out;
    private boolean socketClosed = true;
    private boolean closeBeforeUse;
    private SessionContext context;
    private String host;
    private int port = 80;
    private String basePath = "/";
    private String proxy;
    private int proxyPort;
    private boolean useProxy = false;
    private boolean tunnelProxy = false;
    private boolean useSOCKS = false;
    private ISOCKSProvider socksProvider;
    private Set excludedHosts;
    private Set excludedDomains;
    private Protocol protocol = Protocol.HTTP;
    private boolean secureProtocol = false;
    private boolean upgradeProtocol = false;
    private ISecureSocketProvider secureSocketProvider;
    private String version = "HTTP/1.1";
    private boolean usingHTTP10 = false;
    private String userAgent = "SAP HTTP CLIENT/6.40";
    private int readTimeout = 300000;
    private int connectTimeout = 10000;
    private int expirationTimeout = 10000;
    private long socketExpirationTime;
    private int requestRepetitions = 1;
    private boolean repeatOnTimeout = false;
    private boolean followRedirects = true;
    private boolean followPermanentRedirects = false;
    private boolean followDomainRedirects = false;
    private boolean followProxyRedirects = false;
    private boolean followRedirectAllMethods = true;
    private int maxRedirects = 1;
    private boolean compressedResponses = false;
    private boolean compressedRequests = false;
    private String compressionAlgorithm = "gzip";
    private boolean digestEnabled = false;
    private String digestAlgorithm = "MD5";
    private int receiveBufferSize = -1;
    private int sendBufferSize = -1;
    private int MIN_BUFFER_SIZE = 256;
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$Connection == null ? (class$com$tssap$dtr$client$lib$protocol$Connection = Connection.class$("com.tssap.dtr.client.lib.protocol.Connection")) : class$com$tssap$dtr$client$lib$protocol$Connection));
    private static final String CRLF = "\r\n";
    private static final int CONTACT = 0;
    private static final int CONTACT_PROXY = 1;
    private static final int CONTACT_SOCKS = 2;
    private static final int CONTACT_PROXY_SSL = 3;
    private static final int CONTACT_HOST = 4;
    private static final int CONTACT_HOST_SSL = 5;
    private static Set monitors = new TreeSet();
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$Connection;

    public Connection(String url) throws MalformedURLException {
        this.parseURL(url);
        if (TRACE.beInfo()) {
            TRACE.infoT("Connection(String)", "connection created [url={0}]", new Object[]{url});
        }
    }

    public Connection(String url, ISessionContext context) throws MalformedURLException {
        this(url);
        this.setSessionContext(context);
    }

    public Connection(URL url) throws MalformedURLException {
        this.parseURL(url);
        if (TRACE.beInfo()) {
            TRACE.infoT("Connection(URL)", "connection created [url={0}]", new Object[]{url.getWebLocator()});
        }
    }

    public Connection(URL url, ISessionContext context) throws MalformedURLException {
        this(url);
        this.setSessionContext(context);
    }

    public Connection(String host, int port) {
        this.setHost(host);
        this.setPort(port);
        if (TRACE.beInfo()) {
            TRACE.infoT("Connection(String,int)", "connection created [url={0}]", new Object[]{this.getUrl()});
        }
    }

    public Connection(String host, int port, ISessionContext context) {
        this(host, port);
        this.setSessionContext(context);
    }

    public Connection(IConnectionTemplate template) {
        this.setHost(template.getHost());
        this.setPort(template.getPort());
        this.setProxyHost(template.getProxyHost());
        this.setProxyPort(template.getProxyPort());
        this.setUseProxy(template.isUsingProxy());
        this.setTunnelProxy(template.isTunnelingProxy());
        this.setProtocol(template.getProtocol());
        this.setSecureSocketProvider(template.getSecureSocketProvider());
        this.setFollowRedirects(template.getFollowRedirects());
        this.setFollowPermanentRedirects(template.getFollowPermanentRedirects());
        this.setBasePath(template.getBasePath());
        this.setHTTPVersion(template.getHTTPVersion());
        this.setUserAgent(template.getUserAgent());
        this.setSocketReadTimeout(template.getSocketReadTimeout());
        this.setSocketConnectTimeout(template.getSocketConnectTimeout());
        this.setSocketExpirationTimeout(template.getSocketExpirationTimeout());
        this.setRequestRepetitions(template.getRequestRepetitions(), template.getRepeatOnTimeout());
        this.setReceiveBufferSize(template.getReceiveBufferSize());
        this.setSendBufferSize(template.getSendBufferSize());
        this.enableResponseCompression(template.isResponseCompressionEnabled());
        this.enableRequestCompression(template.isRequestCompressionEnabled());
        this.setCompressionAlgorithm(template.getCompressionAlgorithm());
        this.setSessionContext(template.getSessionContext());
        if (TRACE.beInfo()) {
            TRACE.infoT("Connection(IConnectionTemplate)", "connection created [url={0}]", new Object[]{this.getUrl()});
        }
    }

    public String getUrl() {
        return this.getProtocol() + "://" + this.getHost() + ":" + this.getPort() + this.getBasePath();
    }

    public URL getUrl(String path) {
        return new URL(this.protocol.toString(), this.host, this.port, this.getAbsolutePath(path));
    }

    public void setUrl(String url) throws MalformedURLException {
        this.parseURL(url);
    }

    public void setUrl(URL url) throws MalformedURLException {
        this.parseURL(url);
    }

    public String getHost() {
        return this.host;
    }

    public String getDomain() {
        String domain = ".local";
        int n = this.host.indexOf(46);
        if (n > 0) {
            domain = this.host.substring(n);
        }
        return domain;
    }

    public void setHost(String host) {
        this.host = host;
        this.closeBeforeUse = true;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.closeBeforeUse = true;
    }

    public static int getDefaultPort(Protocol protocol) {
        return protocol == Protocol.HTTP ? 80 : 443;
    }

    public String getProxyUrl() {
        String url = this.getProxyHost();
        if (this.getProxyPort() > 0) {
            url = url + ":" + this.getProxyPort();
        }
        return url;
    }

    public void setProxyUrl(String url) throws MalformedURLException {
        this.parseProxyURL(url);
    }

    public void setProxyUrl(String url, boolean useProxy) throws MalformedURLException {
        this.setProxyUrl(url);
        this.setUseProxy(useProxy);
    }

    public void setProxyUrl(URL url) throws MalformedURLException {
        this.parseProxyURL(url);
        this.closeBeforeUse = true;
    }

    public void setProxyUrl(URL url, boolean useProxy) throws MalformedURLException {
        this.setProxyUrl(url);
        this.setUseProxy(useProxy);
    }

    public String getProxyHost() {
        return this.proxy;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyHost(String proxy) {
        this.proxy = proxy;
        this.closeBeforeUse = true;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        this.closeBeforeUse = true;
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
        this.closeBeforeUse = true;
    }

    public void setUseProxy(boolean useProxy, String exclusions) {
        this.useProxy = useProxy;
        List parts = Tokenizer.partsOf(exclusions, ",;|");
        int i = 0;
        while (i < parts.size()) {
            String part = (String)parts.get(i);
            if (part.startsWith(".") || part.startsWith("*.")) {
                if (this.excludedDomains == null) {
                    this.excludedDomains = new HashSet();
                }
                this.excludedDomains.add(part);
            } else {
                if (this.excludedHosts == null) {
                    this.excludedHosts = new HashSet();
                }
                this.excludedHosts.add(part);
            }
            ++i;
        }
        this.closeBeforeUse = true;
    }

    public void setTunnelProxy(boolean tunnelProxy) {
        this.tunnelProxy = tunnelProxy;
        this.closeBeforeUse = true;
    }

    public void setUseSOCKS(boolean useSOCKS) {
        this.useSOCKS = useSOCKS;
        this.closeBeforeUse = true;
    }

    public boolean isUsingProxy() {
        return this.useProxy;
    }

    public boolean isTunnelingProxy() {
        return this.tunnelProxy;
    }

    public boolean isUsingSOCKS() {
        return this.useSOCKS;
    }

    public String getHTTPVersion() {
        return this.version;
    }

    public void setHTTPVersion(String version) {
        if ("HTTP/1.0".equalsIgnoreCase(version)) {
            this.usingHTTP10 = true;
            this.version = version;
        } else if ("HTTP/1.1".equalsIgnoreCase(version)) {
            this.version = version;
        } else {
            throw new IllegalArgumentException("HTTP version '" + version + "' not supported");
        }
    }

    public boolean usingHTTP10() {
        return this.usingHTTP10;
    }

    public ISessionContext getSessionContext() {
        return this.context;
    }

    public void setSessionContext(ISessionContext ctx) {
        if (ctx != null) {
            this.context = new SessionContext(ctx);
            if (TRACE.beInfo()) {
                TRACE.infoT("setSessionContext(ISessionContext context)", "session context defined [user={0},auth={1}]", new Object[]{this.context != null ? this.context.toString() : "none"});
            }
        } else {
            TRACE.infoT("setSessionContext(ISessionContext context)", "removing session context [[{0}]", new Object[]{this.context != null ? this.context.toString() : "none"});
            this.context = null;
        }
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        if (protocol.equals(Protocol.HTTPS)) {
            this.secureProtocol = true;
            this.tunnelProxy = true;
        } else if (protocol.equals(Protocol.HTTP)) {
            this.secureProtocol = false;
            this.tunnelProxy = false;
        }
        if (this.equalsDefaultPort(this.port)) {
            this.port = Connection.getDefaultPort(protocol);
        }
        this.protocol = protocol;
        this.closeBeforeUse = true;
    }

    public boolean isSecureProtocol() {
        return this.secureProtocol;
    }

    public void setSecureSocketProvider(ISecureSocketProvider provider) {
        this.secureSocketProvider = provider;
        this.closeBeforeUse = true;
    }

    public ISecureSocketProvider getSecureSocketProvider() {
        return this.secureSocketProvider;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String path) {
        if (path == null || path.length() == 0) {
            this.basePath = "/";
        } else {
            StringBuffer buf = new StringBuffer();
            if (!path.startsWith("/")) {
                buf.append('/');
            }
            buf.append(path);
            if (!path.endsWith("/")) {
                buf.append('/');
            }
            this.basePath = buf.toString();
        }
    }

    public String getAbsolutePath(String path) {
        if (path == null || path.length() == 0) {
            return this.basePath != null ? this.basePath : "/";
        }
        if (!path.startsWith("/")) {
            return this.basePath != null ? this.basePath + path : "/" + path;
        }
        return path;
    }

    public int getSocketReadTimeout() {
        return this.readTimeout;
    }

    public void setSocketReadTimeout(int timeout) {
        int n = this.readTimeout = timeout > 0 ? timeout : 0;
        if (!this.socketClosed) {
            try {
                this.socket.setSoTimeout(this.readTimeout);
            }
            catch (SocketException e) {
                TRACE.catching("setSocketReadTimeout(int)", (Throwable)e);
                this.closeBeforeUse = true;
            }
        }
    }

    public int getSocketConnectTimeout() {
        return this.connectTimeout;
    }

    public void setSocketConnectTimeout(int timeout) {
        this.connectTimeout = timeout >= 10 ? timeout : 10;
    }

    public int getSocketExpirationTimeout() {
        return this.expirationTimeout;
    }

    public void setSocketExpirationTimeout(int timeout) {
        this.expirationTimeout = timeout > 0 ? timeout : 0;
    }

    public int getRequestRepetitions() {
        return this.requestRepetitions;
    }

    public boolean getRepeatOnTimeout() {
        return this.repeatOnTimeout;
    }

    public void setRequestRepetitions(int repetitions, boolean repeatOnTimeout) {
        this.requestRepetitions = repetitions;
        this.repeatOnTimeout = repeatOnTimeout;
    }

    public int getReceiveBufferSize() {
        int result = this.receiveBufferSize;
        if (this.socket != null) {
            try {
                result = this.socket.getReceiveBufferSize();
            }
            catch (SocketException ex) {
                TRACE.catching("getReceiveBufferSize()", (Throwable)ex);
            }
        }
        return result;
    }

    public void setReceiveBufferSize(int size) {
        if (size >= 0) {
            int n = this.receiveBufferSize = size > this.MIN_BUFFER_SIZE ? size : this.MIN_BUFFER_SIZE;
            if (!this.socketClosed) {
                try {
                    this.socket.setReceiveBufferSize(this.receiveBufferSize);
                }
                catch (SocketException e) {
                    TRACE.catching("setReceiveBufferSize(int)", (Throwable)e);
                    this.closeBeforeUse = true;
                }
            }
        } else {
            this.receiveBufferSize = -1;
            this.closeBeforeUse = true;
        }
    }

    public int getSendBufferSize() {
        int result = this.sendBufferSize;
        if (this.socket != null) {
            try {
                result = this.socket.getSendBufferSize();
            }
            catch (SocketException ex) {
                TRACE.catching("getSendBufferSize()", (Throwable)ex);
            }
        }
        return result;
    }

    public void setSendBufferSize(int size) {
        if (size >= 0) {
            int n = this.sendBufferSize = size > this.MIN_BUFFER_SIZE ? size : this.MIN_BUFFER_SIZE;
            if (!this.socketClosed) {
                try {
                    this.socket.setSendBufferSize(this.sendBufferSize);
                }
                catch (SocketException e) {
                    TRACE.catching("setSendBufferSize(int)", (Throwable)e);
                    this.closeBeforeUse = true;
                }
            }
        } else {
            this.sendBufferSize = -1;
            this.closeBeforeUse = true;
        }
    }

    public void enableCompression(boolean enable) {
        this.compressedRequests = enable;
        this.compressedResponses = enable;
    }

    public boolean isCompressionEnabled() {
        return this.compressedRequests || this.compressedResponses;
    }

    public void enableRequestCompression(boolean enable) {
        this.compressedRequests = enable;
    }

    public boolean isRequestCompressionEnabled() {
        return this.compressedRequests;
    }

    public void enableResponseCompression(boolean enable) {
        this.compressedResponses = enable;
    }

    public boolean isResponseCompressionEnabled() {
        return this.compressedResponses;
    }

    public String getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public void setCompressionAlgorithm(String algorithm) {
        this.compressionAlgorithm = algorithm;
    }

    public static String[] getSupportedCompressionAlgorithms() {
        return new String[]{"gzip", "deflate"};
    }

    public void enableResponseDigest(boolean enable) {
        this.digestEnabled = enable;
    }

    public boolean isResponseDigestEnabled() {
        return this.digestEnabled;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String algorithm) {
        this.digestAlgorithm = algorithm;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public boolean getFollowPermanentRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setFollowPermanentRedirects(boolean followPermanentRedirects) {
        this.followPermanentRedirects = followPermanentRedirects;
    }

    public void setFollowRedirects(boolean followPermanentRedirects, boolean followProxyRedirects, boolean followDomainRedirects, boolean redirectAllMethods, int maxRedirects) {
        this.followPermanentRedirects = followPermanentRedirects;
        this.followProxyRedirects = followProxyRedirects;
        this.followDomainRedirects = followDomainRedirects;
        this.followRedirectAllMethods = redirectAllMethods;
        this.maxRedirects = maxRedirects;
    }

    public String getUserAgent() {
        if (this.userAgent == null) {
            this.userAgent = "SAP HTTP CLIENT/6.40";
        }
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void open() throws IOException {
        if (!this.socketClosed) {
            if (this.closeBeforeUse) {
                TRACE.debugT("open()", "socket [close before use]");
                this.close();
            } else if (this.hasExpired()) {
                TRACE.debugT("open()", "socket [expired]");
                this.close();
            }
        }
        this.openSocket();
    }

    public void close() {
        this.closeSocket();
    }

    public boolean hasExpired() {
        return !this.socketClosed && this.socketExpirationTime > 0L && System.currentTimeMillis() > this.socketExpirationTime;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public IResponse send(IRequest request) throws IOException, HTTPException {
        return this.sendInternal(request, false, null);
    }

    public IResponse send(IRequest request, boolean sendCloseConnection) throws IOException, HTTPException {
        return this.sendInternal(request, sendCloseConnection, null);
    }

    public IResponse redirect(IResponse response) throws IOException, HTTPException {
        return this.redirect(response, false);
    }

    public IResponse redirect(IResponse response, boolean sendCloseConnection) throws IOException, HTTPException {
        IResponse redirectedResponse = response;
        int status = response.getStatus();
        if (status >= 300 && status <= 307) {
            String location;
            IRequest request = response.getRequest();
            IRequestEntity entity = request.getRequestEntity();
            if (entity != null) {
                if (entity.supportsReset()) {
                    entity.reset();
                } else {
                    TRACE.infoT("redirect(IRequest,int,String,Set,boolean)", "failed to redirect request: cannot reset entity");
                    return response;
                }
            }
            if ((location = response.getHeaderValue("Location")) == null) {
                throw new HTTPException("Redirect failed: response contains no \"Location\" header.");
            }
            if (!URL.isValidURL(location)) {
                throw new HTTPException("Redirect failed: \"Location\" header is invalid.");
            }
            Response rsp = this.redirectInternal(request, response.getStatus(), new URL(location), new HashSet(), sendCloseConnection);
            redirectedResponse = rsp != null ? rsp : response;
        }
        return redirectedResponse;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Response sendInternal(IRequest request, boolean sendCloseConnection, Set locations) throws IOException, HTTPException {
        void var10_10;
        this.open();
        this.in.release();
        Response response = null;
        boolean acceptResponse = false;
        long duration = System.currentTimeMillis();
        int lastStatus = -1;
        int repeatCount = 0;
        Object var10_9 = null;
        while (!acceptResponse && repeatCount <= this.requestRepetitions) {
            try {
                Object var12_19;
                if (TRACE.beDebug()) {
                    TRACE.debugT("sendInternal(IRequest,boolean,Set)", "sending... [connID={0},socketID={1}]", new Object[]{Integer.toHexString(this.hashCode()), Integer.toHexString(this.socket.hashCode())});
                }
                try {
                    this.beforeSend(request);
                    this.sendRequest(request, sendCloseConnection);
                    if (TRACE.beDebug()) {
                        TRACE.debugT("sendInternal(IRequest,boolean,Set)", "receiving... [connID={0},socketID={1}]", new Object[]{Integer.toHexString(this.hashCode()), Integer.toHexString(this.socket.hashCode())});
                    }
                    response = this.getResponse(request);
                    var12_19 = null;
                    this.afterReceive(response);
                }
                catch (Throwable throwable) {
                    var12_19 = null;
                    this.afterReceive(response);
                    throw throwable;
                }
                int status = response.getStatus();
                if (!response.isValid()) throw new HTTPException("invalid HTTP response [" + response.getStatusLine() + "]");
                acceptResponse = true;
                if (this.followRedirects && status >= 300 && status <= 307) {
                    String locationHeader = response.getHeaderValue("Location");
                    if (locationHeader == null) throw new HTTPException("missing location header in redirect response [" + response.getStatusLine() + "]");
                    URL location = new URL(locationHeader);
                    Response redirectedResponse = null;
                    switch (status) {
                        case 300: {
                            break;
                        }
                        case 301: {
                            if (!this.followPermanentRedirects) break;
                            redirectedResponse = this.redirectInternal(request, status, location, locations, sendCloseConnection);
                            break;
                        }
                        case 302: 
                        case 307: {
                            redirectedResponse = this.redirectInternal(request, status, location, locations, sendCloseConnection);
                            break;
                        }
                        case 303: {
                            break;
                        }
                        case 304: {
                            break;
                        }
                        case 305: {
                            if (!this.followProxyRedirects) break;
                            redirectedResponse = this.redirectInternal(request, status, location, locations, sendCloseConnection);
                            break;
                        }
                        default: {
                            throw new HTTPException("invalid redirect response [" + response.getStatusLine() + "]");
                        }
                    }
                    if (redirectedResponse != null) {
                        response = redirectedResponse;
                    }
                } else if (status == 401 || status == 407) {
                    if (status != lastStatus && this.acceptAuthentication(status)) {
                        lastStatus = status;
                        --repeatCount;
                        acceptResponse = false;
                        if (TRACE.beInfo()) {
                            TRACE.infoT("sendInternal(IRequest,boolean,Set)", "{0} requests authentication [{1}]", new Object[]{status == 401 ? "host" : "proxy", response.getStatusLine()});
                        }
                        this.closeBeforeUse = true;
                    }
                } else if (status == 426) {
                    if (status != lastStatus) {
                        this.upgradeProtocol = true;
                        lastStatus = status;
                        --repeatCount;
                        acceptResponse = false;
                        if (TRACE.beInfo()) {
                            TRACE.infoT("sendInternal(IRequest,boolean,Set)", "protocol UPGRADE received [{0}]", new Object[]{response.getStatusLine()});
                        }
                    }
                } else if (status == 400 || status == 500) {
                    this.closeBeforeUse = true;
                    if (status != lastStatus) {
                        lastStatus = status;
                        acceptResponse = false;
                        TRACE.warningT("sendInternal(IRequest,boolean,Set)", "Bad Request or Internal Server error caught [" + response.getStatusLine() + "]");
                    }
                }
            }
            catch (InterruptedIOException ex) {
                TRACE.infoT("sendInternal(IRequest,boolean,Set)", "Read operation timed out [{0}][connID={0},socketID={1}]", new Object[]{ex.getMessage(), Integer.toHexString(this.hashCode()), Integer.toHexString(this.socket.hashCode())});
                this.closeBeforeUse = true;
                acceptResponse = !this.repeatOnTimeout;
                InterruptedIOException interruptedIOException = ex;
            }
            catch (SocketException ex) {
                TRACE.catching("sendInternal(IRequest,boolean,Set)", (Throwable)ex);
                TRACE.infoT("sendInternal(IRequest,boolean,Set)", "Connection reset or shut down by peer [connID={0},socketID={1}]", new Object[]{Integer.toHexString(this.hashCode()), Integer.toHexString(this.socket.hashCode())});
                this.closeBeforeUse = true;
                SocketException socketException = ex;
            }
            catch (IOException ex) {
                TRACE.catching("sendInternal(IRequest,boolean,Set)", (Throwable)ex);
                TRACE.infoT("sendInternal(IRequest,boolean,Set)", "Connection broken due to I/O error [connID={0},socketID={1}]", new Object[]{Integer.toHexString(this.hashCode()), Integer.toHexString(this.socket.hashCode())});
                this.closeBeforeUse = true;
                IOException iOException = ex;
            }
            if (acceptResponse || ++repeatCount > this.requestRepetitions) continue;
            IRequestEntity entity = request.getRequestEntity();
            if (entity != null) {
                if (entity.supportsReset()) {
                    entity.reset();
                } else {
                    TRACE.infoT("sendInternal(IRequest,boolean,Set)", "Request cannot be repeated. Request entities of type {0} do not support this.", new Object[]{entity.getEntityType()});
                    break;
                }
            }
            if (response != null) {
                response.releaseStream();
            }
            this.open();
            Object var10_14 = null;
            TRACE.infoT("sendInternal(IRequest,boolean,Set)", "repeating request");
        }
        if (var10_10 != null) {
            this.closeBeforeUse = true;
            throw var10_10;
        }
        if (!response.isValid()) {
            this.closeBeforeUse = true;
            throw new HTTPException("Cannot handle response. The response code is invalidor unknown [" + response.getStatusLine() + "]");
        }
        this.socketExpirationTime = System.currentTimeMillis() + 10000L;
        duration = System.currentTimeMillis() - duration;
        response.setDuration(duration);
        return response;
    }

    private Response redirectInternal(IRequest request, int status, URL location, Set locations, boolean sendCloseConnection) throws IOException, HTTPException {
        IRequestEntity entity;
        if (!this.protocol.toString().equalsIgnoreCase(location.getProtocol())) {
            TRACE.warningT("redirect(IRequest,int,URL,Set,boolean)", "server tries to switch protocols to \"{0}\"", new Object[]{location.getProtocol()});
            return null;
        }
        String method = request.getMethod();
        if (!(this.followRedirectAllMethods || "GET".equals(method) || "HEAD".equals(method))) {
            TRACE.warningT("redirectInternal(IRequest,int,URL,Set,boolean)", "forbidden to redirect {0} requests", new Object[]{method});
            return null;
        }
        if (!this.followProxyRedirects) {
            if (locations == null) {
                locations = new HashSet<String>();
            } else {
                if (locations.size() > this.maxRedirects) {
                    TRACE.warningT("redirectInternal(IRequest,int,URL,Set,boolean)", "failed to redirect request: too many redirects");
                    throw new HTTPException("failed to redirect request: too many redirects");
                }
                if (locations.contains(location)) {
                    TRACE.warningT("redirectInternal(IRequest,int,URL,Set,boolean)", "failed to redirect request: cyclic redirect found");
                    throw new HTTPException("failed to redirect request: cyclic redirect found");
                }
            }
            locations.add(location.toString());
        }
        if ((entity = request.getRequestEntity()) != null) {
            if (entity.supportsReset()) {
                entity.reset();
            } else {
                TRACE.warningT("redirectInternal(IRequest,int,String,Set,boolean)", "failed to redirect request: cannot reset entity");
                return null;
            }
        }
        if (status == 305) {
            if (this.followProxyRedirects) {
                this.setProxyUrl(location, true);
                return this.sendInternal(request, sendCloseConnection, locations);
            }
            TRACE.warningT("redirectInternal(IRequest,int,String,Set,boolean)", "forbidden to redirect to proxy \"{0}\"", new Object[]{location.getWebLocator()});
            return null;
        }
        Connection conn = this;
        if (!(this.host.equals(location.getHost()) && this.port == location.getPort() || URL.getDomainOf(this.host).equals(location.getDomain()))) {
            if (!this.followDomainRedirects) {
                TRACE.warningT("redirect(IRequest,int,String,Set,boolean)", "forbidden to redirect to foreign host \"{0}\"", new Object[]{location.getWebLocator()});
                return null;
            }
            conn = new Connection(this);
            conn.setUrl(location);
            conn.setSessionContext(null);
            request.setPath(location.getResource());
            return conn.sendInternal(request, true, locations);
        }
        request.setPath(location.getResource());
        return this.sendInternal(request, sendCloseConnection, locations);
    }

    private void openSocket() throws IOException {
        if (this.streamsAvailable()) {
            return;
        }
        String _host = this.host;
        int _port = this.port;
        if (this.useProxy && this.proxy != null && !this.bypassProxy()) {
            _host = this.proxy;
            int n = _port = this.useProxy && this.proxyPort != 0 ? this.proxyPort : Connection.getDefaultPort(this.protocol);
            if (TRACE.beInfo()) {
                TRACE.infoT("openSocket()", "using proxy [host={0}:{1}]", new Object[]{_host, Integer.toString(_port)});
            }
        }
        long sleep = 0L;
        long elapsedTime = 0L;
        long time = 0L;
        int state = 0;
        String connectExceptionMsg = null;
        String alias = this.context != null ? this.context.certificates().getClientAlias() : null;
        while (this.socketClosed && elapsedTime < (long)this.connectTimeout) {
            try {
                time = System.currentTimeMillis();
                if (this.useProxy) {
                    state = 1;
                    this.socket = new Socket(_host, _port);
                    if (this.useSOCKS) {
                        if (this.socksProvider == null) {
                            this.socksProvider = new SOCKSv5Provider();
                        }
                        state = 2;
                        this.socket = this.socksProvider.getSocket(this.socket, this.host, this.port, this.context);
                    } else {
                        if (this.tunnelProxy) {
                            this.openProxyTunnel();
                        }
                        if (this.secureProtocol) {
                            if (this.secureSocketProvider == null) {
                                this.createSecureSocketProvider();
                            }
                            state = 3;
                            this.socket = this.secureSocketProvider.createSocket(this.socket, this.host, this.port, alias);
                        }
                    }
                } else if (this.secureProtocol) {
                    if (this.secureSocketProvider == null) {
                        this.createSecureSocketProvider();
                    }
                    state = 5;
                    this.socket = this.secureSocketProvider.createSocket(_host, _port, alias);
                } else {
                    state = 4;
                    this.socket = new Socket(_host, _port);
                }
                this.prepareSocket();
                this.socketExpirationTime = System.currentTimeMillis() + 10000L;
                elapsedTime += System.currentTimeMillis() - time;
                this.closeBeforeUse = false;
                this.socketClosed = false;
            }
            catch (ConnectException e) {
                this.closeSocket();
                TRACE.catching("openSocket()", (Throwable)e);
                TRACE.infoT("openSocket()", "Waiting for connection");
                connectExceptionMsg = "The host is down or unavailable.";
                time = System.currentTimeMillis() - time;
                if ((long)this.connectTimeout < (elapsedTime += time)) break;
                if (sleep == 0L) {
                    sleep = ((long)this.connectTimeout - 5L * time) / 31L;
                    TRACE.debugT("openSocket()", "Average connect timeout for this platform: {0}ms", new Object[]{Long.toString(time)});
                }
                if (sleep <= 0L) continue;
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException ex2) {
                    TRACE.catching("openSocket()", (Throwable)ex2);
                }
                elapsedTime += sleep;
                sleep *= 2L;
            }
            catch (UnknownHostException e) {
                this.closeSocket();
                TRACE.catching("openSocket()", (Throwable)e);
                connectExceptionMsg = "The IP address of the host could not be resolved. Maybe the URL is misspelled or the host does no longer exist.";
                elapsedTime += System.currentTimeMillis() - time;
                break;
            }
            catch (NoRouteToHostException e) {
                this.closeSocket();
                TRACE.catching("openSocket()", (Throwable)e);
                connectExceptionMsg = "Could not find a route to the remote host. Maybe the host is protected by a firewall or an intermediate server is down.";
                elapsedTime += System.currentTimeMillis() - time;
                break;
            }
            catch (IOException e) {
                this.closeSocket();
                TRACE.catching("openSocket()", (Throwable)e);
                connectExceptionMsg = e.getMessage();
                elapsedTime += System.currentTimeMillis() - time;
                break;
            }
        }
        if (this.socketClosed) {
            StringBuffer stateMsg = new StringBuffer("Unable to open ");
            switch (state) {
                case 1: {
                    stateMsg.append("connection to proxy \"").append(_host);
                    stateMsg.append(":").append(_port).append(". ");
                    break;
                }
                case 2: {
                    stateMsg.append("connection to SOCKS server \"").append(_host).append(":");
                    stateMsg.append(_port).append("\". ");
                    break;
                }
                case 3: {
                    stateMsg.append("SSL connection to host \"");
                    stateMsg.append(this.host).append(":").append(this.port);
                    stateMsg.append(" via proxy ");
                    stateMsg.append(_host).append(":").append(_port).append("\". ");
                    break;
                }
                case 5: {
                    stateMsg.append("SSL connection to host \"");
                    stateMsg.append(this.host).append(":").append(this.port).append("\". ");
                    break;
                }
                case 4: {
                    stateMsg.append("connection to host \"");
                    stateMsg.append(this.host).append(":").append(this.port).append("\". ");
                    break;
                }
                default: {
                    stateMsg.append("connection.");
                }
            }
            if (connectExceptionMsg != null) {
                stateMsg.append(connectExceptionMsg).append(".");
            }
            TRACE.debugT("openSocket()", "opening socket [failed][{0}][host={1}:{2}][protocol={3}][connID={4}][waited {5}ms]", new Object[]{stateMsg.toString(), _host, Integer.toString(_port), this.protocol.toString(), Integer.toHexString(this.hashCode()), Long.toString(elapsedTime)});
            throw new IOException(stateMsg.toString());
        }
        if (TRACE.beDebug()) {
            TRACE.debugT("openSocket()", "opening socket [succeeded][host={0}:{1},ip={2}][localhost={6}:{7},ip={8}][protocol={3}][connID={4},socketID={5}]", new Object[]{_host, Integer.toString(_port), this.socket.getInetAddress().getHostAddress(), this.protocol.toString(), Integer.toHexString(this.hashCode()), Integer.toHexString(this.socket.hashCode()), this.socket.getLocalAddress().getHostName(), Integer.toString(this.socket.getLocalPort()), this.socket.getLocalAddress().getHostAddress()});
        }
    }

    private void prepareSocket() throws IOException {
        this.socket.setTcpNoDelay(true);
        this.socket.setSoTimeout(this.readTimeout);
        if (this.sendBufferSize > 0) {
            this.socket.setSendBufferSize(this.sendBufferSize);
        }
        if (this.receiveBufferSize > 0) {
            this.socket.setReceiveBufferSize(this.receiveBufferSize);
        }
        if (TRACE.beDebug() && this.secureProtocol) {
            long time = System.currentTimeMillis();
            this.in = new ResponseStream(this.socket);
            this.out = new RequestStream(this.socket);
            TRACE.debugT("prepareSocket()", "SSL handshake [succeeded][time=" + (System.currentTimeMillis() - time) + "ms]");
        } else {
            this.in = new ResponseStream(this.socket);
            this.out = new RequestStream(this.socket);
        }
    }

    private void openProxyTunnel() throws IOException {
        RequestBase connectRequest = new RequestBase("CONNECT");
        Response connectResponse = null;
        try {
            this.prepareSocket();
            this.sendRequest(connectRequest, false);
            connectResponse = this.getResponse(connectRequest);
        }
        catch (Exception e) {
            TRACE.catching("openProxyTunnel()", (Throwable)e);
            throw new IOException("opening proxy tunnel [failed][" + e.getMessage() + "]");
        }
        if (!connectResponse.isValid()) {
            throw new IOException("opening proxy tunnel [failed][invalid CONNECT response][" + connectResponse.getStatusLine() + "]");
        }
        int status = connectResponse.getStatus();
        if (status < 200 || status > 299) {
            throw new IOException("opening proxy tunnel [failed][" + connectResponse.getStatusLine() + "]");
        }
        if (TRACE.beDebug()) {
            TRACE.debugT("openProxyTunnel()", "opening proxy tunnel [succeded]");
        }
    }

    private boolean bypassProxy() {
        boolean result = false;
        if (this.excludedHosts != null) {
            result = this.excludedDomains.contains(this.host);
        }
        if (this.excludedDomains != null) {
            result |= this.excludedDomains.contains(this.getDomain());
        }
        return result;
    }

    private void createSecureSocketProvider() throws IOException {
        try {
            Certificates certs;
            Class.forName("iaik.security.ssl.SSLSocket");
            if (this.context == null) {
                this.context = new SessionContext();
            }
            if ((certs = this.context.certificates()).usingEngineKeyStores()) {
                String clientCerts = null;
                String serverCerts = null;
                if (certs.authenticateMe()) {
                    clientCerts = certs.getClientCertStore();
                }
                if (certs.authenticateThem()) {
                    serverCerts = certs.getServerCertStore();
                }
                this.secureSocketProvider = new IAIKSecureSocketProvider(serverCerts, clientCerts);
            } else {
                KeyStore clientCerts = null;
                KeyStore serverCerts = null;
                String pwd = null;
                if (certs.authenticateMe()) {
                    try {
                        clientCerts = certs.getClientCertificates();
                    }
                    catch (KeyStoreException e) {
                        throw new IOException("failed to import client certificates [" + e.getMessage() + "]");
                    }
                    pwd = certs.getClientStoreKeyPassword();
                    if (clientCerts == null || pwd == null) {
                        throw new IOException("failed to retrieve SSL socket [no client certificates provided]");
                    }
                }
                if (certs.authenticateThem()) {
                    try {
                        serverCerts = certs.getServerCertificates();
                    }
                    catch (KeyStoreException e) {
                        throw new IOException("failed to import server certificates [" + e.getMessage() + "]");
                    }
                    if (serverCerts == null && (serverCerts = Certificates.loadDefaultKeystore()) == null) {
                        throw new IOException("failed to retrieve SSL socket [no server certificates provided]");
                    }
                }
                this.secureSocketProvider = new IAIKSecureSocketProvider(serverCerts, clientCerts, pwd);
            }
            TRACE.infoT("using SSL socket provider [IAIK][authMe={0},authThem={1}]", new Object[]{certs.authenticateMe() ? "on" : "off", certs.authenticateThem() ? "on" : "off"});
        }
        catch (ClassNotFoundException t) {
            try {
                Certificates certs;
                Class.forName("javax.net.ssl.SSLSocketFactory");
                if (this.context != null && ((certs = this.context.certificates()).authenticateMe() || certs.authenticateThem())) {
                    throw new IOException("failed to retrieve SSL socket [SSL provider does not support certificates]");
                }
                this.secureSocketProvider = JSSESecureSocketProvider.getDefault();
                TRACE.infoT("using default SSL socket provider [JSSE][no authentication]");
            }
            catch (ClassNotFoundException tt) {
                throw new IOException("failed to retrieve SSL socket [no SSL provider]");
            }
        }
    }

    private boolean streamsAvailable() {
        boolean result = false;
        if (!this.socketClosed) {
            try {
                this.socket.getInputStream();
                this.socket.getOutputStream();
                result = true;
            }
            catch (IOException ex) {
                TRACE.catching("streamsAvailable()", (Throwable)ex);
            }
        }
        return result;
    }

    private void closeSocket() {
        if (!this.socketClosed) {
            if (this.in != null) {
                this.in.shutdown();
                this.in = null;
            }
            if (this.out != null) {
                this.out.shutdown();
                this.out = null;
            }
            if (this.socket != null) {
                try {
                    try {
                        this.socket.close();
                    }
                    catch (IOException ex) {
                        TRACE.catching("closeSocket()", (Throwable)ex);
                        Object var3_2 = null;
                        this.socket = null;
                    }
                    Object var3_1 = null;
                    this.socket = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.socket = null;
                    throw throwable;
                }
            }
            this.socketClosed = true;
            this.closeBeforeUse = false;
            TRACE.debugT("closeSocket()", "socket [closed]");
            TRACE.debugT("closeSocket()", " ");
        }
    }

    private void sendRequest(IRequest request, boolean sendCloseConnection) throws IOException {
        String method = request.getMethod();
        if (method == null || method.length() == 0) {
            throw new IllegalArgumentException("HTTP command in request missing");
        }
        IRequestEntity entity = request.getRequestEntity();
        long contentLength = request.getContentLength();
        boolean enableChunks = false;
        boolean closeOutStreamAfterSend = false;
        if (entity != null) {
            if (this.usingHTTP10) {
                boolean bl = closeOutStreamAfterSend = contentLength < 0L;
            }
            if (contentLength < 0L) {
                request.setHeader("Transfer-Encoding", "chunked");
                request.removeHeader("Content-Length");
                enableChunks = true;
            } else {
                request.removeHeader("Transfer-Encoding");
                request.setHeader("Content-Length", Long.toString(contentLength));
            }
        } else {
            request.setHeader("Content-Length", "0");
        }
        String contentType = request.getHeaderValue("Content-Type");
        if (entity != null && contentType == null) {
            contentType = "application/octet-stream";
            request.setHeader("Content-Type", contentType);
        }
        if (sendCloseConnection || this.usingHTTP10 || "close".equals(request.getHeaderValue("Connection"))) {
            this.closeBeforeUse = true;
            request.setHeader("Connection", "close");
        }
        if (this.upgradeProtocol) {
            request.setHeader("Upgrade", "TLS/1.0");
            request.setHeader("Connection", "upgrade", true);
        }
        if (this.context != null) {
            this.context.applyCookies(request, this);
            this.context.applyCredentials(this.getUrl(request.getPath()), request);
            this.context.applyQueryParameters(request);
        }
        if (this.userAgent != null && request.getHeader("User-Agent") == null) {
            request.setHeader("User-Agent", this.userAgent);
        }
        if (this.compressedResponses) {
            request.setHeader("Accept-Encoding", "gzip, deflate");
        }
        request.removeHeader("Host");
        this.sendRequestLine(request);
        this.sendHeader(request);
        if (entity != null) {
            if (request.logRequestEntity() && !this.secureProtocol) {
                this.out.enableWireTrace(request.getLocation());
            }
            if (enableChunks) {
                this.out.enableChunking(true);
                entity.write(this.out);
                this.out.enableChunking(false);
            } else {
                this.out.enableLimit(contentLength);
                entity.write(this.out);
                this.out.disableLimit();
            }
            this.out.disableWireTrace();
        }
        this.out.flush();
        if (this.usingHTTP10 && closeOutStreamAfterSend) {
            this.out.shutdown();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendRequestLine(IRequest request) throws IOException {
        StringBuffer sb = new StringBuffer();
        String method = request.getMethod();
        sb.append(method).append(" ");
        if ("CONNECT".equals(method)) {
            sb.append(this.host).append(':').append(this.port);
        } else {
            String path = request.getPath();
            if ("*".equals(path)) {
                if (!"OPTIONS".equals(method)) throw new IllegalArgumentException("Invalid request path: '*' is only allowed in OPTIONS requests.");
                sb.append('*');
            } else {
                if (this.useProxy && !this.tunnelProxy) {
                    sb.append(this.protocol).append("://");
                    sb.append(this.host);
                    if (!this.equalsDefaultPort(this.port)) {
                        sb.append(':').append(this.port);
                    }
                }
                sb.append(this.getAbsolutePath(path));
                Query query = request.getQuery();
                if (query != null && !query.isEmpty()) {
                    sb.append('?').append(query.toString());
                }
            }
        }
        sb.append(' ').append(this.version);
        if (TRACE.beDebug()) {
            TRACE.debugT("sendRequestLine(IRequest)", " ");
            TRACE.debugT("sendRequestLine(IRequest)", sb.toString());
        }
        sb.append(CRLF);
        sb.append("Host").append(": ").append(this.host);
        if (!this.equalsDefaultPort(this.port)) {
            sb.append(':').append(this.port);
        }
        sb.append(CRLF);
        if (TRACE.beDebug()) {
            TRACE.debugT("sendRequestLine(IRequest)", "Host: {0}{1}", new Object[]{this.host, !this.equalsDefaultPort(this.port) ? ":" + Integer.toString(this.port) : " "});
        }
        this.out.write(sb.toString(), "ISO-8859-1");
    }

    private void sendHeader(IRequest request) throws IOException {
        StringBuffer sb = new StringBuffer();
        Iterator iter = request.getHeaderNames();
        if (iter != null) {
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Header header = request.getHeader(name);
                sb.append(header.toString());
                sb.append(CRLF);
                if (!TRACE.beDebug()) continue;
                if (name.equalsIgnoreCase("Authorization") && header.getValue().startsWith("Basic")) {
                    TRACE.debugT("sendHeader(IRequest)", "Authorization: Basic ********");
                    continue;
                }
                TRACE.debugT("sendHeader(IRequest)", "{0}", new Object[]{header.toString()});
            }
        }
        sb.append(CRLF);
        TRACE.debugT("sendHeader(IRequest)", " ");
        this.out.write(sb.toString(), "ISO-8859-1");
    }

    private Response getResponse(IRequest request) throws IOException, HTTPException {
        Response response = new Response(request, this.secureProtocol);
        if (this.digestEnabled) {
            response.enableDigest(this.digestAlgorithm);
        }
        response.initialize(this.in);
        if (response.getStatus() == 101) {
            response = this.upgrade(response);
        }
        this.closeBeforeUse |= response.closingConnection();
        if (this.context == null) {
            this.context = new SessionContext();
        }
        this.context.setupCookies(response, this);
        this.context.setupCredentials(response);
        return response;
    }

    private boolean acceptAuthentication(int status) {
        if (this.context == null || !this.context.getSendAuthentication()) {
            return false;
        }
        if (status == 401) {
            return this.context.getUser() != null && this.context.getPassword() != null;
        }
        if (status == 407) {
            return this.context.getProxyUser() != null && this.context.getProxyPassword() != null;
        }
        return false;
    }

    private Response upgrade(Response response) throws IOException, HTTPException {
        if (!this.upgradeProtocol) {
            throw new HTTPException("Unexpected \"101 Switching Protocols\" received.");
        }
        String upgradeHeader = response.getHeaderValue("Upgrade");
        if (upgradeHeader == null) {
            throw new HTTPException("Missing UPGRADE header in \"101 Switching Protocols\" response");
        }
        TRACE.infoT("getResponse()", "Server wants to switch protocols [to={0}]", new Object[]{upgradeHeader});
        if (!upgradeHeader.startsWith("TLS/1.0")) {
            throw new HTTPException("UPGRADE protocol not supported [" + upgradeHeader + "]");
        }
        if (this.secureProtocol) {
            throw new HTTPException("UPGRADE protocol denied. Already using secure protocol.");
        }
        if (this.secureSocketProvider == null) {
            this.createSecureSocketProvider();
        }
        this.socket = this.secureSocketProvider.createSocket(this.socket, this.host, this.port);
        this.prepareSocket();
        this.upgradeProtocol = false;
        this.secureProtocol = true;
        TRACE.infoT("upgradeSocket(String)", "Switching to protocol TLS/1.0 [succeeded]");
        response.initialize(this.in);
        return response;
    }

    private void parseURL(String s) throws MalformedURLException {
        URL url = new URL(s);
        this.parseURL(url);
    }

    private void parseURL(URL url) throws MalformedURLException {
        String protocol = url.getProtocol();
        if ("http".equalsIgnoreCase(protocol)) {
            this.setProtocol(Protocol.HTTP);
        } else if ("https".equalsIgnoreCase(protocol)) {
            this.setProtocol(Protocol.HTTPS);
        } else {
            MalformedURLException ex = new MalformedURLException("URI schema \"" + protocol + ":\" not suppported");
            throw ex;
        }
        String host = url.getHost();
        if (host == null || host.length() <= 0) {
            MalformedURLException ex = new MalformedURLException("URL must have a host part");
            throw ex;
        }
        this.setHost(host);
        this.setPort(url.getPort());
        this.setBasePath(url.getPath());
    }

    private void parseProxyURL(String s) throws MalformedURLException {
        URL url = new URL(s);
        this.parseProxyURL(url);
    }

    private void parseProxyURL(URL url) throws MalformedURLException {
        String proxyHost = url.getHost();
        if (proxyHost == null || proxyHost.length() <= 0) {
            MalformedURLException ex = new MalformedURLException("Proxy URL must have a host part");
            throw ex;
        }
        this.setProxyHost(proxyHost);
        this.setProxyPort(url.getPort());
    }

    private boolean equalsDefaultPort(int port) {
        return this.protocol == Protocol.HTTP && port == 80 || port == 443;
    }

    public static void addMonitor(IConnectionMonitor monitor, Object auth) {
        monitors.add(monitor);
    }

    public static void removeMonitor(IConnectionMonitor monitor) {
        monitors.remove(monitor);
    }

    private synchronized void beforeSend(IRequest request) {
        Iterator id = monitors.iterator();
        while (id.hasNext()) {
            IConnectionMonitor d = (IConnectionMonitor)id.next();
            try {
                d.beforeSend(this, request);
            }
            catch (Throwable t) {
                TRACE.warningT("beforeSend notification failed for protocol monitor " + d);
            }
        }
    }

    private synchronized void afterReceive(IResponse response) {
        Iterator id = monitors.iterator();
        while (id.hasNext()) {
            IConnectionMonitor d = (IConnectionMonitor)id.next();
            try {
                d.afterReceive(this, response);
            }
            catch (Throwable t) {
                TRACE.warningT("afterReceive notification failed for protocol monitor " + d);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

