/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.service.sap.licensing;

import com.adobe.service.sap.licensing.SAPFormCreationException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public final class SAPForm {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] makeIntoSAPForm(byte[] byArray) throws SAPFormCreationException {
        DocumentBuilder documentBuilder;
        if (byArray == null || byArray.length == 0) {
            String string = "Could not convert the input form to an SAP form because the input XDP file is null or is zero length.";
            throw new SAPFormCreationException(string);
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = "Could not create a DOM parser, so as a result, could not convert the input form to an SAP form.";
            throw new SAPFormCreationException(string);
        }
        Document document = null;
        try {
            document = documentBuilder.parse(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            String string = "Could not create a parse the input XDP file due to an input error.";
            throw new SAPFormCreationException(string);
        }
        catch (SAXException sAXException) {
            String string = "Could not create a parse the input XDP file due to a parsing error. " + sAXException.getMessage();
            throw new SAPFormCreationException(string);
        }
        SAPForm.mf_addFieldDigests(document);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = null;
        try {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.transform(new DOMSource(document), new StreamResult(byteArrayOutputStream));
                byArray2 = byteArrayOutputStream.toByteArray();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new SAPFormCreationException("Transformer configuration error while creating new XDP file: \n" + transformerConfigurationException);
            }
            catch (TransformerException transformerException) {
                throw new SAPFormCreationException("Transformer error while creating new XDP file: \n" + transformerException);
            }
            Object var9_15 = null;
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            try {
                byteArrayOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new SAPFormCreationException("Could not close the byte output stream of the new XDP file.");
            }
        }
        try {}
        catch (IOException iOException) {
            throw new SAPFormCreationException("Could not close the byte output stream of the new XDP file.");
        }
        byteArrayOutputStream.close();
        return byArray2;
    }

    public static void makeIntoSAPForm(File file, File file2) throws IOException, SAPFormCreationException {
        byte[] byArray = null;
        try {
            byArray = SAPForm.mf_readFile(file);
        }
        catch (IOException iOException) {
            String string = "Could not read the input XDP file. " + iOException.getMessage();
            throw new IOException(string);
        }
        byte[] byArray2 = SAPForm.makeIntoSAPForm(byArray);
        try {
            SAPForm.mf_writeFile(byArray2, file2);
        }
        catch (IOException iOException) {
            String string = "Could not write the output XDP file. " + iOException.getMessage();
            throw new IOException(string);
        }
    }

    private static void mf_addFieldDigests(Document document) throws SAPFormCreationException {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string = "The MD5 message digest algorithm is not installed.  Have you installed and configured a Java security provider?";
            throw new SAPFormCreationException(string);
        }
        SAPForm.mf_tryToAddFieldDigestToNode(document, document, null, messageDigest);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void mf_writeFile(byte[] byArray, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            Object var4_3 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fileOutputStream == null) throw throwable;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] mf_readFile(File file) throws IOException {
        byte[] byArray = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            long l = file.length();
            byArray = new byte[(int)l];
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            int n = 0;
            int n2 = 0;
            while ((n = bufferedInputStream.read(byArray, n2, 4096 < (int)l - n2 ? 4096 : (int)l - n2)) > 0) {
                n2 += n;
            }
            Object var8_6 = null;
            if (bufferedInputStream == null) return byArray;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (bufferedInputStream == null) throw throwable;
            bufferedInputStream.close();
            throw throwable;
        }
        bufferedInputStream.close();
        return byArray;
    }

    private static boolean mf_tryToAddFieldDigestToNode(Document document, Node node, Node node2, MessageDigest messageDigest) throws SAPFormCreationException {
        if (node == null) {
            String string = "An error occured -- a null node was passed to the field digest method.";
            throw new SAPFormCreationException(string);
        }
        if (messageDigest == null) {
            String string = "No message digest class was passed to the field digest method.";
            throw new SAPFormCreationException(string);
        }
        boolean bl = false;
        short s = node.getNodeType();
        if (s == 1 || s == 9) {
            String string = node.getLocalName();
            if (string != null && string.compareTo("field") == 0) {
                node2 = node;
            }
            if (string != null && string.compareTo("bind") == 0 && node2 != null) {
                SAPForm.mf_addFieldDigestToNode(document, node2, node, messageDigest);
                bl = true;
            } else {
                NodeList nodeList = node.getChildNodes();
                if (nodeList != null && nodeList.getLength() > 0) {
                    int n = nodeList.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        boolean bl2 = SAPForm.mf_tryToAddFieldDigestToNode(document, nodeList.item(n2), node2, messageDigest);
                        if (bl2) {
                            bl = true;
                        }
                        ++n2;
                    }
                }
                if (node2 != null && !bl) {
                    SAPForm.mf_addFieldDigestToNode(document, node2, null, messageDigest);
                    bl = true;
                }
            }
            node2 = null;
        }
        return bl;
    }

    private static void mf_addFieldDigestToNode(Document document, Node node, Node node2, MessageDigest messageDigest) throws SAPFormCreationException {
        Object object;
        Object object2;
        int n;
        Object object3;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node3 = namedNodeMap.getNamedItem("name");
        String string = null;
        if (node3 != null) {
            string = node3.getNodeValue();
        }
        messageDigest.reset();
        byte[] byArray = null;
        try {
            if (string != null) {
                byArray = string.getBytes("UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = "Could not convert the arguments to UTF-8.  The encoder appears to be missing.";
            throw new SAPFormCreationException(string2);
        }
        if (byArray != null) {
            messageDigest.update(byArray);
        }
        if (node2 != null) {
            object3 = node2.getAttributes();
            int n2 = object3.getLength();
            n = 0;
            while (n < n2) {
                object2 = object3.item(n);
                object = object2.getNodeValue();
                if (object != null && ((String)object).length() > 0) {
                    byte[] byArray2 = null;
                    try {
                        if (object != null) {
                            byArray2 = ((String)object).getBytes("UTF-8");
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        String string3 = "Could not convert the arguments to UTF-8.  The encoder appears to be missing.";
                        throw new SAPFormCreationException(string3);
                    }
                    if (byArray2 != null) {
                        messageDigest.update(byArray2);
                    }
                }
                ++n;
            }
        }
        object3 = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer(((Object)object3).length * 2 + 1);
        n = 0;
        while (n < ((Object)object3).length) {
            object2 = Integer.toHexString(object3[n] & 0xFF);
            if (((String)object2).length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append((String)object2);
            ++n;
        }
        object2 = stringBuffer.toString();
        object = node.getChildNodes();
        if (object != null && object.getLength() > 0) {
            int n3 = object.getLength();
            int n4 = 0;
            while (n4 < n3) {
                String string4;
                short s = object.item(n4).getNodeType();
                if (s == 7 && (string4 = object.item(n4).getNodeName()) != null && string4.compareTo("digestForSAP") == 0) {
                    node.removeChild(object.item(n4));
                    --n3;
                }
                ++n4;
            }
        }
        ProcessingInstruction processingInstruction = document.createProcessingInstruction("digestForSAP", "digest=\"" + (String)object2 + "\"");
        node.appendChild(processingInstruction);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            SAPForm.printUsage();
            return;
        }
        try {
            SAPForm.makeIntoSAPForm(new File(stringArray[0]), new File(stringArray[1]));
        }
        catch (IOException iOException) {
            System.err.println("There was a problem converting the input XDP form into an SAP form.");
            iOException.printStackTrace(System.err);
        }
        catch (SAPFormCreationException sAPFormCreationException) {
            System.err.println("There was a problem converting the input XDP form into an SAP form.");
            sAPFormCreationException.printStackTrace(System.err);
        }
    }

    private static void printUsage() {
        System.err.println();
        System.err.println("Usage: SAPForms inputFilename outputFilename");
        System.err.println();
        System.err.println("The SAPForms application will add a set of hashes to the input file that will");
        System.err.println("make the Document Services License Manager treat the form as an SAP provided");
        System.err.println("form.  It will not count this form as a form that counts against the five free");
        System.err.println("interactive forms as agreed to between Adobe and SAP.");
        System.err.println();
        System.err.println("Arguments:");
        System.err.println();
        System.err.println("\tinputFilename");
        System.err.println("\t\tThe XDP file that should be made into an SAP form.");
        System.err.println();
        System.err.println("\toutputFilename");
        System.err.println("\t\tThe name to write out the modified XDP file.");
        System.err.println();
    }
}

