/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching.sourcelookup;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jdt.core.JavaModelException;

public class ZipEntryStorage
extends PlatformObject
implements IStorage {
    private ZipFile fArchive;
    private ZipEntry fZipEntry;

    public ZipEntryStorage(ZipFile archive, ZipEntry entry) {
        this.setArchive(archive);
        this.setZipEntry(entry);
    }

    public InputStream getContents() throws CoreException {
        try {
            return this.getArchive().getInputStream(this.getZipEntry());
        }
        catch (IOException e) {
            throw new JavaModelException((Throwable)e, 985);
        }
    }

    public IPath getFullPath() {
        return new Path(this.getArchive().getName()).append(this.getZipEntry().getName());
    }

    public String getName() {
        int index = this.getZipEntry().getName().lastIndexOf(92);
        if (index == -1) {
            index = this.getZipEntry().getName().lastIndexOf(47);
        }
        if (index == -1) {
            return this.getZipEntry().getName();
        }
        return this.getZipEntry().getName().substring(index + 1);
    }

    public boolean isReadOnly() {
        return true;
    }

    private void setArchive(ZipFile archive) {
        this.fArchive = archive;
    }

    public ZipFile getArchive() {
        return this.fArchive;
    }

    private void setZipEntry(ZipEntry entry) {
        this.fZipEntry = entry;
    }

    public ZipEntry getZipEntry() {
        return this.fZipEntry;
    }

    public boolean equals(Object object) {
        return object instanceof ZipEntryStorage && this.getArchive().equals(((ZipEntryStorage)((Object)object)).getArchive()) && this.getZipEntry().getName().equals(((ZipEntryStorage)((Object)object)).getZipEntry().getName());
    }

    public int hashCode() {
        return this.getZipEntry().getName().hashCode();
    }
}

