/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching.sourcelookup;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.launching.JavaLaunchConfigurationUtils;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.sourcelookup.IJavaSourceLocation;
import org.eclipse.jdt.launching.sourcelookup.LocalFileStorage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DirectorySourceLocation
extends PlatformObject
implements IJavaSourceLocation {
    private File fDirectory;

    public DirectorySourceLocation() {
    }

    public DirectorySourceLocation(File directory) {
        this.setDirectory(directory);
    }

    public Object findSourceElement(String name) throws CoreException {
        int dotIndex;
        if (this.getDirectory() == null) {
            return null;
        }
        String pathStr = name.replace('.', '/');
        int dollarIndex = pathStr.indexOf(36, (dotIndex = pathStr.lastIndexOf(47)) + 1);
        if (dollarIndex >= 0) {
            pathStr = pathStr.substring(0, dollarIndex);
        }
        pathStr = String.valueOf(pathStr) + ".java";
        try {
            Path root = new Path(this.getDirectory().getCanonicalPath());
            root = root.append((IPath)new Path(pathStr));
            File file = root.toFile();
            if (file.exists()) {
                return new LocalFileStorage(file);
            }
        }
        catch (IOException e) {
            throw new JavaModelException((Throwable)e, 985);
        }
        return null;
    }

    private void setDirectory(File directory) {
        this.fDirectory = directory;
    }

    public File getDirectory() {
        return this.fDirectory;
    }

    public boolean equals(Object object) {
        return object instanceof DirectorySourceLocation && this.getDirectory().equals(((DirectorySourceLocation)object).getDirectory());
    }

    public int hashCode() {
        return this.getDirectory().hashCode();
    }

    public String getMemento() throws CoreException {
        DocumentImpl doc = new DocumentImpl();
        Element node = doc.createElement("directorySourceLocation");
        doc.appendChild(node);
        node.setAttribute("path", this.getDirectory().getAbsolutePath());
        try {
            return JavaLaunchConfigurationUtils.serializeDocument((Document)doc);
        }
        catch (IOException e) {
            this.abort(MessageFormat.format(LaunchingMessages.getString("DirectorySourceLocation.Unable_to_create_memento_for_directory_source_location_{0}_1"), this.getDirectory().getAbsolutePath()), e);
            return null;
        }
    }

    public void initializeFrom(String memento) throws CoreException {
        Exception ex = null;
        try {
            Element root = null;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            String path = root.getAttribute("path");
            if (this.isEmpty(path)) {
                this.abort(LaunchingMessages.getString("DirectorySourceLocation.Unable_to_initialize_source_location_-_missing_directory_path_3"), null);
            } else {
                File dir = new File(path);
                if (dir.exists() && dir.isDirectory()) {
                    this.setDirectory(dir);
                } else {
                    this.abort(MessageFormat.format(LaunchingMessages.getString("DirectorySourceLocation.Unable_to_initialize_source_location_-_directory_does_not_exist__{0}_4"), path), null);
                }
            }
            return;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        this.abort(LaunchingMessages.getString("DirectorySourceLocation.Exception_occurred_initializing_source_location._5"), ex);
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, LaunchingPlugin.getUniqueIdentifier(), 150, message, e);
        throw new CoreException((IStatus)s);
    }
}

