/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching.sourcelookup;

import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.launching.JavaLaunchConfigurationUtils;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.sourcelookup.IJavaSourceLocation;
import org.eclipse.jdt.launching.sourcelookup.ZipEntryStorage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ArchiveSourceLocation
extends PlatformObject
implements IJavaSourceLocation {
    private static HashMap fZipFileCache = new HashMap(5);
    private IPath fRootPath;
    private boolean fRootDetected = false;
    private String fName;

    private static ZipFile getZipFile(String name) throws IOException {
        ZipFile zip = (ZipFile)fZipFileCache.get(name);
        if (zip == null) {
            zip = new ZipFile(name);
            fZipFileCache.put(name, zip);
        }
        return zip;
    }

    public static void closeArchives() {
        Iterator iter = fZipFileCache.values().iterator();
        while (iter.hasNext()) {
            ZipFile file = (ZipFile)iter.next();
            try {
                file.close();
            }
            catch (IOException e) {
                LaunchingPlugin.log(e);
            }
        }
        fZipFileCache.clear();
    }

    public ArchiveSourceLocation() {
    }

    public ArchiveSourceLocation(String archiveName, String sourceRoot) {
        this.setName(archiveName);
        this.setRootPath(sourceRoot);
    }

    public Object findSourceElement(String name) throws CoreException {
        try {
            ZipEntry entry;
            int dotIndex;
            if (this.getArchive() == null) {
                return null;
            }
            String pathStr = name.replace('.', '/');
            int dollarIndex = pathStr.indexOf(36, (dotIndex = pathStr.lastIndexOf(47)) + 1);
            if (dollarIndex >= 0) {
                pathStr = pathStr.substring(0, dollarIndex);
            }
            pathStr = String.valueOf(pathStr) + ".java";
            Path path = new Path(pathStr);
            this.autoDetectRoot((IPath)path);
            if (this.getRootPath() != null) {
                path = this.getRootPath().append((IPath)path);
            }
            if ((entry = this.getArchive().getEntry(path.toString())) != null) {
                return new ZipEntryStorage(this.getArchive(), entry);
            }
            return null;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), 150, MessageFormat.format(LaunchingMessages.getString("ArchiveSourceLocation.Unable_to_locate_source_element_in_archive_{0}_1"), this.getName()), (Throwable)e));
        }
    }

    private void autoDetectRoot(IPath path) {
        if (!this.fRootDetected) {
            Enumeration<? extends ZipEntry> entries = null;
            try {
                entries = this.getArchive().entries();
            }
            catch (IOException e) {
                LaunchingPlugin.log(e);
                return;
            }
            String fileName = path.toString();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(fileName)) continue;
                int rootLength = entryName.length() - fileName.length();
                if (rootLength > 0) {
                    String root = entryName.substring(0, rootLength);
                    this.setRootPath(root);
                }
                this.fRootDetected = true;
                return;
            }
        }
    }

    protected ZipFile getArchive() throws IOException {
        return ArchiveSourceLocation.getZipFile(this.getName());
    }

    private void setRootPath(String path) {
        if (path == null || path.trim().length() == 0) {
            this.fRootPath = null;
        } else {
            this.fRootPath = new Path(path);
            this.fRootDetected = true;
        }
    }

    public IPath getRootPath() {
        return this.fRootPath;
    }

    public String getName() {
        return this.fName;
    }

    private void setName(String name) {
        this.fName = name;
    }

    public boolean equals(Object object) {
        return object instanceof ArchiveSourceLocation && this.getName().equals(((ArchiveSourceLocation)object).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getMemento() throws CoreException {
        DocumentImpl doc = new DocumentImpl();
        Element node = doc.createElement("archiveSourceLocation");
        doc.appendChild(node);
        node.setAttribute("archivePath", this.getName());
        if (this.getRootPath() != null) {
            node.setAttribute("rootPath", this.getRootPath().toString());
        }
        try {
            return JavaLaunchConfigurationUtils.serializeDocument((Document)doc);
        }
        catch (IOException e) {
            this.abort(MessageFormat.format(LaunchingMessages.getString("ArchiveSourceLocation.Unable_to_create_memento_for_archive_source_location_{0}_1"), this.getName()), e);
            return null;
        }
    }

    public void initializeFrom(String memento) throws CoreException {
        Exception ex = null;
        try {
            Element root = null;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            String path = root.getAttribute("archivePath");
            if (this.isEmpty(path)) {
                this.abort(LaunchingMessages.getString("ArchiveSourceLocation.Unable_to_initialize_source_location_-_missing_archive_path._3"), null);
            }
            String rootPath = root.getAttribute("rootPath");
            this.setName(path);
            this.setRootPath(rootPath);
            return;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        this.abort(LaunchingMessages.getString("ArchiveSourceLocation.Exception_occurred_initializing_source_location._5"), ex);
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, LaunchingPlugin.getUniqueIdentifier(), 150, message, e);
        throw new CoreException((IStatus)s);
    }
}

