/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathProvider;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;

public class StandardClasspathProvider
implements IRuntimeClasspathProvider {
    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) throws CoreException {
        boolean useDefault = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
        if (useDefault) {
            IJavaProject proj = JavaRuntime.getJavaProject(configuration);
            if (proj == null) {
                IVMInstall vm = JavaRuntime.computeVMInstall(configuration);
                LibraryLocation[] libs = JavaRuntime.getLibraryLocations(vm);
                if (libs == null) {
                    return new IRuntimeClasspathEntry[0];
                }
                IRuntimeClasspathEntry[] rtes = new IRuntimeClasspathEntry[libs.length];
                int i = 0;
                while (i < libs.length) {
                    IRuntimeClasspathEntry r = JavaRuntime.newArchiveRuntimeClasspathEntry(libs[i].getSystemLibraryPath());
                    r.setSourceAttachmentPath(libs[i].getSystemLibrarySourcePath());
                    r.setSourceAttachmentRootPath(libs[i].getPackageRootPath());
                    r.setClasspathProperty(1);
                    rtes[i] = r;
                    ++i;
                }
                return rtes;
            }
            return JavaRuntime.computeUnresolvedRuntimeClasspath(proj);
        }
        return this.recoverRuntimePath(configuration, IJavaLaunchConfigurationConstants.ATTR_CLASSPATH);
    }

    public IRuntimeClasspathEntry[] resolveClasspath(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        ArrayList<IRuntimeClasspathEntry> all = new ArrayList<IRuntimeClasspathEntry>(entries.length);
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveRuntimeClasspathEntry(entries[i], configuration);
            int j = 0;
            while (j < resolved.length) {
                all.add(resolved[j]);
                ++j;
            }
            ++i;
        }
        return all.toArray(new IRuntimeClasspathEntry[all.size()]);
    }

    protected IRuntimeClasspathEntry[] recoverRuntimePath(ILaunchConfiguration configuration, String attribute) throws CoreException {
        List entries = configuration.getAttribute(attribute, Collections.EMPTY_LIST);
        IRuntimeClasspathEntry[] rtes = new IRuntimeClasspathEntry[entries.size()];
        Iterator iter = entries.iterator();
        int i = 0;
        while (iter.hasNext()) {
            rtes[i] = JavaRuntime.newRuntimeClasspathEntry((String)iter.next());
            ++i;
        }
        return rtes;
    }
}

