/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.sourcelookup.JavaSourceLocator;

public abstract class AbstractJavaLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate,
IDebugEventSetListener {
    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), code, message, exception));
    }

    public IVMInstall getVMInstall(ILaunchConfiguration configuration) throws CoreException {
        return JavaRuntime.computeVMInstall(configuration);
    }

    public String getVMInstallName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
    }

    public IVMInstallType getVMInstallType(ILaunchConfiguration configuration) throws CoreException {
        IVMInstallType type;
        String id = this.getVMInstallTypeId(configuration);
        if (id != null && (type = JavaRuntime.getVMInstallType(id)) != null) {
            return type;
        }
        return null;
    }

    public String getVMInstallTypeId(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
    }

    public IVMInstall verifyVMInstall(ILaunchConfiguration configuration) throws CoreException {
        File location;
        IVMInstall vm = this.getVMInstall(configuration);
        if (vm == null) {
            this.abort(LaunchingMessages.getString("AbstractJavaLaunchConfigurationDelegate.The_specified_JRE_installation_does_not_exist_4"), null, 105);
        }
        if ((location = vm.getInstallLocation()) == null) {
            this.abort(MessageFormat.format(LaunchingMessages.getString("AbstractJavaLaunchConfigurationDelegate.JRE_home_directory_not_specified_for_{0}_5"), vm.getName()), null, 105);
        }
        if (!location.exists()) {
            this.abort(MessageFormat.format(LaunchingMessages.getString("AbstractJavaLaunchConfigurationDelegate.JRE_home_directory_for_{0}_does_not_exist__{1}_6"), vm.getName(), location.getAbsolutePath()), null, 105);
        }
        return vm;
    }

    public String getVMConnectorId(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, null);
    }

    public String[] getBootpath(ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath(configuration);
        entries = JavaRuntime.resolveRuntimeClasspath(entries, configuration);
        ArrayList<String> bootEntries = new ArrayList<String>(entries.length);
        boolean empty = true;
        boolean allStandard = true;
        int i = 0;
        while (i < entries.length) {
            String location;
            if (entries[i].getClasspathProperty() != 3 && (location = entries[i].getLocation()) != null) {
                empty = false;
                bootEntries.add(location);
                allStandard = allStandard && entries[i].getClasspathProperty() == 1;
            }
            ++i;
        }
        if (empty) {
            return new String[0];
        }
        if (allStandard) {
            return null;
        }
        return bootEntries.toArray(new String[bootEntries.size()]);
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath(configuration);
        entries = JavaRuntime.resolveRuntimeClasspath(entries, configuration);
        ArrayList<String> userEntries = new ArrayList<String>(entries.length);
        int i = 0;
        while (i < entries.length) {
            String location;
            if (entries[i].getClasspathProperty() == 3 && (location = entries[i].getLocation()) != null) {
                userEntries.add(location);
            }
            ++i;
        }
        return userEntries.toArray(new String[userEntries.size()]);
    }

    public IJavaProject getJavaProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        IJavaProject javaProject;
        String projectName = this.getJavaProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0 && (javaProject = JavaCore.create((IProject)(project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)))) != null && javaProject.exists()) {
            return javaProject;
        }
        return null;
    }

    public String getJavaProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
    }

    public String getMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
    }

    public Map getVMSpecificAttributesMap(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, null);
    }

    public File getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        return this.verifyWorkingDirectory(configuration);
    }

    public IPath getWorkingDirectoryPath(ILaunchConfiguration configuration) throws CoreException {
        String path = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, null);
        if (path != null) {
            return new Path(path);
        }
        return null;
    }

    public IJavaProject verifyJavaProject(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject project;
        String name = this.getJavaProjectName(configuration);
        if (name == null) {
            this.abort(LaunchingMessages.getString("AbstractJavaLaunchConfigurationDelegate.Java_project_not_specified_9"), null, 100);
        }
        if ((project = this.getJavaProject(configuration)) == null) {
            this.abort(LaunchingMessages.getString("AbstractJavaLaunchConfigurationDelegate.Project_does_not_exist_or_is_not_a_Java_project_10"), null, 107);
        }
        return project;
    }

    public String verifyMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        String name = this.getMainTypeName(configuration);
        if (name == null) {
            this.abort(LaunchingMessages.getString("AbstractJavaLaunchConfigurationDelegate.Main_type_not_specified_11"), null, 101);
        }
        return name;
    }

    public File verifyWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        IPath path = this.getWorkingDirectoryPath(configuration);
        if (path == null) {
            IJavaProject jp = this.getJavaProject(configuration);
            if (jp != null) {
                IProject p = jp.getProject();
                return p.getLocation().toFile();
            }
        } else if (path.isAbsolute()) {
            File dir = new File(path.toOSString());
            if (dir.isDirectory()) {
                return dir;
            }
            this.abort(MessageFormat.format(LaunchingMessages.getString("AbstractJavaLaunchConfigurationDelegate.Working_directory_does_not_exist__{0}_12"), path.toString()), null, 108);
        } else {
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (res instanceof IContainer && res.exists()) {
                return res.getLocation().toFile();
            }
            this.abort(MessageFormat.format(LaunchingMessages.getString("AbstractJavaLaunchConfigurationDelegate.Working_directory_does_not_exist__{0}_12"), path.toString()), null, 108);
        }
        return null;
    }

    public boolean isAllowTerminate(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
    }

    public boolean isStopInMain(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, false);
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject;
        String id;
        if (launch.getSourceLocator() == null && (id = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null)) == null && (javaProject = JavaRuntime.getJavaProject(configuration)) != null) {
            JavaSourceLocator sourceLocator = new JavaSourceLocator(javaProject);
            launch.setSourceLocator((ISourceLocator)sourceLocator);
        }
    }

    protected void prepareStopInMain(ILaunchConfiguration configuration) throws CoreException {
        if (this.isStopInMain(configuration)) {
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            ILaunchConfiguration configuration;
            IJavaDebugTarget target;
            ILaunch launch;
            DebugEvent event = events[i];
            if (event.getKind() == 4 && event.getSource() instanceof IJavaDebugTarget && (launch = (target = (IJavaDebugTarget)event.getSource()).getLaunch()) != null && (configuration = launch.getLaunchConfiguration()) != null) {
                try {
                    String mainType;
                    if (this.isStopInMain(configuration) && (mainType = this.getMainTypeName(configuration)) != null) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN);
                        IJavaMethodBreakpoint bp = JDIDebugModel.createMethodBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), (String)mainType, (String)"main", (String)"([Ljava/lang/String;)V", (boolean)true, (boolean)false, (boolean)false, (int)-1, (int)-1, (int)-1, (int)1, (boolean)false, map);
                        bp.setPersisted(false);
                        target.breakpointAdded((IBreakpoint)bp);
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    }
                }
                catch (CoreException e) {
                    LaunchingPlugin.log(e);
                }
            }
            ++i;
        }
    }

    public abstract void launch(ILaunchConfiguration var1, String var2, ILaunch var3, IProgressMonitor var4) throws CoreException;
}

