/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.w3c.dom.Document;

public class JavaLaunchConfigurationUtils {
    public static IType getMainType(ILaunchConfiguration configuration, IJavaProject javaProject) throws CoreException {
        String mainTypeName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
        return JavaLaunchConfigurationUtils.getMainType(mainTypeName, javaProject);
    }

    public static IType getMainType(String mainTypeName, IJavaProject javaProject) throws CoreException {
        if (mainTypeName == null || mainTypeName.trim().length() < 1) {
            JavaLaunchConfigurationUtils.abort(LaunchingMessages.getString("JavaLaunchConfigurationUtils.Main_type_not_specified_3"), null, 101);
        }
        IType mainType = null;
        try {
            mainType = JavaLaunchConfigurationUtils.findType(javaProject, mainTypeName);
        }
        catch (JavaModelException javaModelException) {}
        if (mainType == null) {
            JavaLaunchConfigurationUtils.abort(LaunchingMessages.getString("JavaLaunchConfigurationUtils.Main_type_does_not_exist_4"), null, 101);
        }
        return mainType;
    }

    public static IType findType(IJavaProject javaProject, String mainTypeName) throws JavaModelException {
        String pathStr = String.valueOf(mainTypeName.replace('.', '/')) + ".java";
        IJavaElement javaElement = javaProject.findElement((IPath)new Path(pathStr));
        if (javaElement == null) {
            return null;
        }
        if (javaElement instanceof IType) {
            return (IType)javaElement;
        }
        if (javaElement.getElementType() == 5) {
            String simpleName = Signature.getSimpleName((String)mainTypeName);
            return ((ICompilationUnit)javaElement).getType(simpleName);
        }
        if (javaElement.getElementType() == 6) {
            return ((IClassFile)javaElement).getType();
        }
        return null;
    }

    protected static void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), code, message, exception));
    }

    public static String serializeDocument(Document doc) throws IOException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        OutputFormat format = new OutputFormat();
        format.setIndenting(true);
        format.setLineSeparator(System.getProperty("line.separator"));
        Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer((Writer)new OutputStreamWriter((OutputStream)s, "UTF8"), format);
        serializer.asDOMSerializer().serialize(doc);
        return s.toString("UTF8");
    }
}

