/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.techdev.ejb;

import com.sap.tc.buildplugin.api.BuildActionResult;
import com.sap.tc.buildplugin.api.BuildActionSeverity;
import com.sap.tc.buildplugin.api.IBuildAction;
import com.sap.tc.buildplugin.api.IBuildInfo;
import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.buildplugin.pputil.PPCollector;
import com.sap.tc.buildplugin.techdev.ant.util.DirsAndFiles;
import com.sap.tc.buildplugin.techdev.ant.util.FileCreator;
import com.sap.tc.buildplugin.util.JlinUtils;
import com.sap.tc.buildtool.LogFile;
import com.sap.tc.complib.Entity;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CreateBuildFileAction
implements IBuildAction {
    BuildActionResult result;
    BuildActionSeverity severity;
    FileCreator fCreator;
    DirsAndFiles daf;
    List wsPPSources = new ArrayList();
    List wsPPClasses = new ArrayList();
    int br = 0;
    String errMsg = "";
    int currentStep;
    private IBuildInfo buildInfo;
    Location loc = Location.getLocation((Class)(class$com$sap$tc$buildplugin$techdev$ejb$CreateBuildFileAction == null ? (class$com$sap$tc$buildplugin$techdev$ejb$CreateBuildFileAction = CreateBuildFileAction.class$("com.sap.tc.buildplugin.techdev.ejb.CreateBuildFileAction")) : class$com$sap$tc$buildplugin$techdev$ejb$CreateBuildFileAction));
    JlinUtils jlinUtils;
    static /* synthetic */ Class class$com$sap$tc$buildplugin$techdev$ejb$CreateBuildFileAction;

    CreateBuildFileAction(FileCreator fc, int step, IBuildInfo buildInfo) {
        this.fCreator = fc;
        this.daf = fc.getDaf();
        this.currentStep = step;
        this.buildInfo = buildInfo;
        this.result = new BuildActionResult();
        this.severity = new BuildActionSeverity();
        this.severity.setStopOnError();
        this.jlinUtils = new JlinUtils(buildInfo);
    }

    public BuildActionResult execute() {
        Map ppMap;
        this.loc.infoT("EJB Plugin starts creating the build file");
        IDevelopmentComponentInfo componentInfo = this.buildInfo.getDevelopmentComponentInfo();
        switch (this.currentStep) {
            case 1: {
                this.daf.setBuildFile("prebuild.xml");
                this.fCreator.setMacroName("prebuild.vm");
                break;
            }
            case 2: {
                this.daf.setBuildFile("build.xml");
                this.fCreator.setMacroName("build.vm");
                break;
            }
            case 3: {
                this.daf.setBuildFile("postbuild.xml");
                this.fCreator.setMacroName("postbuild.vm");
                break;
            }
            default: {
                this.daf.setBuildFile("build.xml");
                this.fCreator.setMacroName("build.vm");
            }
        }
        String prebuildDir = this.daf.getTempDir() + File.separator + "pre";
        this.fCreator.setStrContext("dc_prebuild_Dir", prebuildDir);
        File prebuildDirF = new File(prebuildDir);
        if (prebuildDirF.exists()) {
            this.fCreator.setStrContext("dc_prebuild_Dir_exist", "true");
        }
        if ((ppMap = this.daf.getPublicParts()) != null) {
            PPCollector pp = new PPCollector(componentInfo);
            this.br = pp.addData(ppMap);
            this.errMsg = pp.getErrorMsg();
            this.fCreator.setListContext("dc_public_parts", pp.getList());
        }
        if (ppMap != null) {
            Iterator it = ppMap.keySet().iterator();
            while (it.hasNext()) {
                PublicPart pp = (PublicPart)ppMap.get(it.next());
                List entities = pp.getEntities();
                if (entities == null) continue;
                int i = 0;
                while (i < entities.size()) {
                    Entity currentEntity = (Entity)entities.get(i);
                    String type = currentEntity.getType();
                    if (type.equalsIgnoreCase("Web Service Definition")) {
                        this.collectEntitiesWsdef(currentEntity);
                    }
                    ++i;
                }
            }
        }
        this.fCreator.setStrContext("dc_root_Dir", this.daf.getRootDir());
        List dependDirs = this.daf.getDependDirs();
        HashMap<String, String> AntPropsDependDirs = new HashMap<String, String>();
        ArrayList<String> AntPropsDependJars = new ArrayList<String>();
        if (dependDirs != null) {
            Iterator it = dependDirs.iterator();
            int no = 0;
            while (it.hasNext()) {
                String dir = (String)it.next();
                AntPropsDependDirs.put("dependDir_" + ++no, dir);
                File dirFile = new File(dir);
                if (!dirFile.exists()) continue;
                String[] allFilesInFolder = dirFile.list();
                int i = 0;
                while (i < allFilesInFolder.length) {
                    String curFileName = dir + File.separator + allFilesInFolder[i];
                    if (curFileName.endsWith(".jar") || curFileName.endsWith(".zip")) {
                        AntPropsDependJars.add(curFileName);
                    }
                    ++i;
                }
            }
        }
        this.fCreator.setHashMapContext("dc_depend_compileDirs", AntPropsDependDirs);
        this.fCreator.setListContext("dc_depend_compileArchives", AntPropsDependJars);
        List packageDirs = this.daf.getPackageDirs();
        this.fCreator.setListContext("dc_packageDirs", packageDirs);
        this.fCreator.setStrContext("dc_gen_classesDir", this.daf.getClassesDir());
        this.fCreator.setStrContext("dc_gen_publicDir", this.daf.getGenDirPublic());
        this.fCreator.setStrContext("dc_gen_tempDir", this.daf.getTempDir());
        this.fCreator.setStrContext("dc_gen_logDir", this.daf.getLogDir());
        this.fCreator.setStrContext("dc_deployFile", this.daf.getDcFile());
        HashMap buildOptions = this.daf.getBuildOptions();
        this.fCreator.setHashMapContext("dc_build_options", buildOptions);
        try {
            this.fCreator.setStrContext("compiler_executable_path", this.buildInfo.getCompilerExecutable());
        }
        catch (NoSuchMethodError ex) {
            String msg = "pluginhandler does not supply getCompilerExecutable";
            this.loc.traceThrowableT(300, msg, (Throwable)ex);
        }
        this.jlinUtils.insertJlinContext(this.fCreator);
        this.fCreator.setHashMapContext("dc_jdo_files", this.daf.getJdoMap());
        if (this.daf.hasSQLJ()) {
            this.fCreator.setStrContext("sqlj_exist", "true");
        } else {
            this.fCreator.setStrContext("sqlj_exist", "false");
        }
        if (this.br != 2 && this.br != 3) {
            this.fCreator.createBuildFile();
        } else {
            LogFile log = new LogFile();
            log.setErrorMessage(this.errMsg);
            log.writeLogFile(this.daf.getLogFile());
        }
        this.result.setBuildLogPath(this.daf.getLogFile());
        this.result.setBuildActionRC(this.br);
        return this.result;
    }

    public BuildActionResult getBuildActionResult() {
        return this.result;
    }

    public BuildActionSeverity getBuildActionSeverity() {
        return this.severity;
    }

    public void setBuildActionSeverity(BuildActionSeverity _severity) {
        this.severity = _severity;
    }

    public String getCaption() {
        return "Create Build file";
    }

    private void collectEntitiesWsdef(Entity entity) {
        String pack = entity.getPackageName();
        String name = entity.getName();
        String wsName = "";
        if (pack != null) {
            wsName = pack.replace('/', File.separatorChar) + File.separator + name + ".wsdef";
        } else {
            pack = "";
            wsName = name + ".wsdef";
        }
        this.wsPPSources.add(wsName);
        String packName = pack.replace('/', '.');
        String ppFileName = "wspp.properties";
        Properties ppProps = new Properties();
        File ppFile = new File(this.daf.getRootDir() + File.separator + "cfg" + File.separator + ppFileName);
        this.fCreator.setStrContext("gen_ws", "true");
        if (!ppFile.exists()) {
            this.loc.infoT("wspp.properties file doesn't exist - can not include the needed entities for Web Service Definition in pp");
            this.br = 1;
            this.fCreator.setStrContext("gen_ws", "false");
        } else {
            try {
                FileInputStream in = new FileInputStream(ppFile);
                ppProps.load(in);
                in.close();
                Enumeration<?> keys = ppProps.propertyNames();
                while (keys.hasMoreElements()) {
                    String fileName;
                    String key = (String)keys.nextElement();
                    String value = ppProps.getProperty(key);
                    String keyStart = "";
                    keyStart = packName != "" ? packName + "." + name : name;
                    if (key.startsWith(keyStart + ".VI")) {
                        String vi = "";
                        if (value.substring(0, value.lastIndexOf(".")).indexOf(".") != -1) {
                            value = value.substring(0, value.lastIndexOf("."));
                            String packVI = value.substring(0, value.lastIndexOf("."));
                            fileName = value.substring(value.lastIndexOf(".") + 1, value.length());
                            vi = packVI.replace('.', File.separatorChar) + File.separator + fileName + ".videf";
                        } else {
                            vi = value;
                        }
                        this.wsPPSources.add(vi);
                        continue;
                    }
                    if (!key.startsWith(keyStart + ".BEAN")) continue;
                    String bean = "";
                    if (value.substring(0, value.lastIndexOf(".")).indexOf(".") != -1) {
                        value = value.substring(0, value.lastIndexOf("."));
                        String packBean = value.substring(0, value.lastIndexOf("."));
                        fileName = value.substring(value.lastIndexOf(".") + 1, value.length());
                        bean = packBean.replace('.', File.separatorChar) + File.separator + fileName;
                    } else {
                        bean = value.substring(0, value.lastIndexOf("."));
                    }
                    this.wsPPClasses.add(bean);
                }
                this.fCreator.setListContext("dc_ws_pp_sources", this.wsPPSources);
                this.fCreator.setListContext("dc_ws_pp_classes", this.wsPPClasses);
                if (this.wsPPSources.size() == 0 || this.wsPPClasses.size() == 0) {
                    this.br = 1;
                }
            }
            catch (FileNotFoundException fnf) {
                String msg = "wspp.properties file doesn't exist - can not include the needed entities for Web Service Definition in pp";
                this.loc.traceThrowableT(500, msg, (Throwable)fnf);
            }
            catch (IOException ioe) {
                String msg = "problem occurred while reading wspp.properties file";
                this.loc.traceThrowableT(500, msg, (Throwable)ioe);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

