/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.structuremergeviewer;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

public class StructureDiffViewer
extends DiffTreeViewer {
    private Differencer fDifferencer;
    private boolean fThreeWay = false;
    private ITypedElement fAncestorInput;
    private ITypedElement fLeftInput;
    private ITypedElement fRightInput;
    private IStructureComparator fAncestorStructure;
    private IStructureComparator fLeftStructure;
    private IStructureComparator fRightStructure;
    private IStructureCreator fStructureCreator;
    private IDiffContainer fRoot;
    private IContentChangeListener fContentChangedListener;
    private ICompareInputChangeListener fThreeWayInputChangedListener;
    private CompareViewerSwitchingPane fParent;

    public StructureDiffViewer(Tree tree, CompareConfiguration configuration) {
        super(tree, configuration);
        Composite c = tree.getParent();
        if (c instanceof CompareViewerSwitchingPane) {
            this.fParent = (CompareViewerSwitchingPane)c;
        }
        this.initialize();
    }

    public StructureDiffViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
        if (parent instanceof CompareViewerSwitchingPane) {
            this.fParent = (CompareViewerSwitchingPane)parent;
        }
        this.initialize();
    }

    private void initialize() {
        this.setAutoExpandLevel(3);
        this.fContentChangedListener = new IContentChangeListener(){

            public void contentChanged(IContentChangeNotifier changed) {
                StructureDiffViewer.this.contentChanged(changed);
            }
        };
        this.fThreeWayInputChangedListener = new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput input) {
                StructureDiffViewer.this.compareInputChanged(input);
            }
        };
    }

    public void setStructureCreator(IStructureCreator structureCreator) {
        if (this.fStructureCreator != structureCreator) {
            this.fStructureCreator = structureCreator;
            Control tree = this.getControl();
            if (tree != null && !tree.isDisposed()) {
                tree.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)this.getTitle());
            }
        }
    }

    public IStructureCreator getStructureCreator() {
        return this.fStructureCreator;
    }

    public String getTitle() {
        if (this.fStructureCreator != null) {
            return this.fStructureCreator.getName();
        }
        return super.getTitle();
    }

    protected Object getRoot() {
        return this.fRoot;
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (input instanceof ICompareInput) {
            this.compareInputChanged((ICompareInput)input);
            if (input != oldInput) {
                this.initialSelection();
            }
        }
    }

    protected void initialSelection() {
        this.expandToLevel(2);
    }

    protected void handleDispose(DisposeEvent event) {
        this.compareInputChanged(null);
        this.fContentChangedListener = null;
        this.fThreeWayInputChangedListener = null;
        super.handleDispose(event);
    }

    protected void compareInputChanged(ICompareInput input) {
        ITypedElement t = null;
        boolean changed = false;
        if (input != null) {
            t = input.getAncestor();
        }
        boolean bl = this.fThreeWay = t != null;
        if (t != this.fAncestorInput) {
            if (this.fAncestorInput instanceof IContentChangeNotifier) {
                ((IContentChangeNotifier)((Object)this.fAncestorInput)).removeContentChangeListener(this.fContentChangedListener);
            }
            this.fAncestorInput = t;
            if (this.fAncestorInput != null) {
                this.fAncestorStructure = this.fStructureCreator.getStructure(this.fAncestorInput);
                changed = true;
            } else {
                this.fAncestorStructure = null;
            }
            if (this.fAncestorInput instanceof IContentChangeNotifier) {
                ((IContentChangeNotifier)((Object)this.fAncestorInput)).addContentChangeListener(this.fContentChangedListener);
            }
        }
        if (input != null) {
            t = input.getLeft();
        }
        if (t != this.fLeftInput) {
            if (this.fLeftInput instanceof IContentChangeNotifier) {
                ((IContentChangeNotifier)((Object)this.fLeftInput)).removeContentChangeListener(this.fContentChangedListener);
            }
            this.fLeftInput = t;
            if (this.fLeftInput != null) {
                this.fLeftStructure = this.fStructureCreator.getStructure(this.fLeftInput);
                changed = true;
            } else {
                this.fLeftStructure = null;
            }
            if (this.fLeftInput instanceof IContentChangeNotifier) {
                ((IContentChangeNotifier)((Object)this.fLeftInput)).addContentChangeListener(this.fContentChangedListener);
            }
        }
        if (input != null) {
            t = input.getRight();
        }
        if (t != this.fRightInput) {
            if (this.fRightInput instanceof IContentChangeNotifier) {
                ((IContentChangeNotifier)((Object)this.fRightInput)).removeContentChangeListener(this.fContentChangedListener);
            }
            this.fRightInput = t;
            if (this.fRightInput != null) {
                this.fRightStructure = this.fStructureCreator.getStructure(this.fRightInput);
                changed = true;
            } else {
                this.fRightStructure = null;
            }
            if (this.fRightInput instanceof IContentChangeNotifier) {
                ((IContentChangeNotifier)((Object)this.fRightInput)).addContentChangeListener(this.fContentChangedListener);
            }
        }
        if (changed) {
            this.diff();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void contentChanged(IContentChangeNotifier changed) {
        if (this.fStructureCreator == null) {
            return;
        }
        if (changed != null) {
            if (changed == this.fAncestorInput) {
                this.fAncestorStructure = this.fStructureCreator.getStructure(this.fAncestorInput);
            } else if (changed == this.fLeftInput) {
                this.fLeftStructure = this.fStructureCreator.getStructure(this.fLeftInput);
            } else {
                if (changed != this.fRightInput) return;
                this.fRightStructure = this.fStructureCreator.getStructure(this.fRightInput);
            }
        } else {
            this.fAncestorStructure = this.fStructureCreator.getStructure(this.fAncestorInput);
            this.fLeftStructure = this.fStructureCreator.getStructure(this.fLeftInput);
            this.fRightStructure = this.fStructureCreator.getStructure(this.fRightInput);
        }
        this.diff();
    }

    protected void preDiffHook(IStructureComparator ancestor, IStructureComparator left, IStructureComparator right) {
    }

    protected void diff() {
        this.preDiffHook(this.fAncestorStructure, this.fLeftStructure, this.fRightStructure);
        String message = null;
        if (this.fThreeWay && this.fAncestorStructure == null || this.fLeftStructure == null || this.fRightStructure == null) {
            this.fRoot = null;
            message = CompareMessages.getString("StructureDiffViewer.StructureError");
        } else {
            if (this.fDifferencer == null) {
                this.fDifferencer = new Differencer(){

                    protected boolean contentsEqual(Object o1, Object o2) {
                        return StructureDiffViewer.this.contentsEqual(o1, o2);
                    }

                    protected Object visit(Object data, int result, Object ancestor, Object left, Object right) {
                        Object o = super.visit(data, result, ancestor, left, right);
                        if (StructureDiffViewer.this.fLeftIsLocal && o instanceof DiffNode) {
                            ((DiffNode)o).swapSides(StructureDiffViewer.this.fLeftIsLocal);
                        }
                        return o;
                    }
                };
            }
            this.fRoot = (IDiffContainer)this.fDifferencer.findDifferences(this.fThreeWay, null, null, this.fAncestorStructure, this.fLeftStructure, this.fRightStructure);
            if (this.fRoot == null || this.fRoot.getChildren().length == 0) {
                message = CompareMessages.getString("StructureDiffViewer.NoStructuralDifferences");
            } else {
                this.postDiffHook(this.fDifferencer, this.fRoot);
            }
        }
        if (this.fParent != null) {
            this.fParent.setTitleArgument(message);
        }
        this.refresh(this.getRoot());
    }

    protected void postDiffHook(Differencer differencer, IDiffContainer root) {
    }

    private boolean contentsEqual(Object o1, Object o2) {
        if (this.fStructureCreator != null) {
            boolean ignoreWhiteSpace = Utilities.getBoolean(this.getCompareConfiguration(), "IGNORE_WHITESPACE", false);
            String s1 = this.fStructureCreator.getContents(o1, ignoreWhiteSpace);
            String s2 = this.fStructureCreator.getContents(o2, ignoreWhiteSpace);
            if (s1 == null || s2 == null) {
                return false;
            }
            return s1.equals(s2);
        }
        return false;
    }

    protected void propertyChange(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals("IGNORE_WHITESPACE")) {
            this.diff();
        } else {
            super.propertyChange(event);
        }
    }

    protected void copySelected(boolean leftToRight) {
        super.copySelected(leftToRight);
        if (this.fStructureCreator != null) {
            this.fStructureCreator.save(leftToRight ? this.fRightStructure : this.fLeftStructure, leftToRight ? this.fRightInput : this.fLeftInput);
        }
    }
}

