/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.structuremergeviewer;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.DiffElement;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;

public abstract class DiffContainer
extends DiffElement
implements IDiffContainer {
    private static IDiffElement[] fgEmptyArray = new IDiffElement[0];
    private ArrayList fChildren;

    public DiffContainer(IDiffContainer parent, int kind) {
        super(parent, kind);
    }

    public IDiffElement findChild(String name) {
        IDiffElement[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            IDiffElement child = children[i];
            if (name.equals(child.getName())) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public void add(IDiffElement diff) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList();
        }
        this.fChildren.add(diff);
        diff.setParent(this);
    }

    public void removeToRoot(IDiffElement child) {
        if (this.fChildren != null) {
            IDiffContainer p;
            ((AbstractCollection)this.fChildren).remove(child);
            child.setParent(null);
            if (this.fChildren.size() == 0 && (p = this.getParent()) != null) {
                p.removeToRoot(this);
            }
        }
    }

    public void remove(IDiffElement child) {
        if (this.fChildren != null) {
            ((AbstractCollection)this.fChildren).remove(child);
            child.setParent(null);
        }
    }

    public boolean hasChildren() {
        return this.fChildren != null && this.fChildren.size() > 0;
    }

    public IDiffElement[] getChildren() {
        if (this.fChildren != null) {
            return this.fChildren.toArray(fgEmptyArray);
        }
        return fgEmptyArray;
    }
}

