/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.ExceptionHandler;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.patch.InputPatchPage;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.Patcher;
import org.eclipse.compare.internal.patch.PreviewPatchPage;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

class PatchWizard
extends Wizard {
    private static final String DIALOG_SETTINGS_KEY = "PatchWizard";
    private boolean fHasNewDialogSettings;
    private InputPatchPage fPatchWizardPage;
    private PreviewPatchPage fPreviewPatchPage;
    private Patcher fPatcher;
    private IResource fTarget;

    PatchWizard(ISelection selection) {
        this.setTargets(PatchWizard.getResource(selection));
        this.fPatcher = new Patcher();
        this.setWindowTitle(PatchMessages.getString("PatchWizard.title"));
        IDialogSettings workbenchSettings = CompareUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.fHasNewDialogSettings = true;
        } else {
            this.fHasNewDialogSettings = false;
            this.setDialogSettings(section);
        }
    }

    static IResource[] getResource(ISelection selection) {
        IResource[] rs = Utilities.getResources(selection);
        ArrayList<IResource> list = null;
        int i = 0;
        while (i < rs.length) {
            IResource r = rs[i];
            if (r != null && r.isAccessible()) {
                if (list == null) {
                    list = new ArrayList<IResource>();
                }
                list.add(r);
            }
            ++i;
        }
        if (list != null && list.size() > 0) {
            return list.toArray(new IResource[list.size()]);
        }
        return null;
    }

    Patcher getPatcher() {
        return this.fPatcher;
    }

    IResource getTarget() {
        return this.fTarget;
    }

    void setTargets(IResource[] targets) {
        if (targets != null) {
            this.fTarget = targets[0];
        }
    }

    public void addPages() {
        super.addPages();
        this.fPatchWizardPage = new InputPatchPage(this);
        this.addPage((IWizardPage)this.fPatchWizardPage);
        this.fPreviewPatchPage = new PreviewPatchPage(this);
        this.addPage((IWizardPage)this.fPreviewPatchPage);
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean performFinish() {
        this.fPatcher.setName(this.fPatchWizardPage.getPatchName());
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        PatchWizard.this.fPatcher.applyAll(PatchWizard.this.getTarget(), monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.getContainer().run(true, false, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, PatchMessages.getString("PatchWizard.title"), PatchMessages.getString("PatchWizard.unexpectedException.message"));
        }
        catch (InterruptedException interruptedException) {}
        if (this.fHasNewDialogSettings) {
            IDialogSettings workbenchSettings = CompareUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
            section = workbenchSettings.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(section);
        }
        this.fPatchWizardPage.saveWidgetValues();
        return true;
    }
}

