/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Assert;

class LineReader {
    private boolean fHaveChar = false;
    private int fLastChar;
    private boolean fSawEOF = false;
    private BufferedReader fReader;
    private boolean fIgnoreSingleCR = false;

    LineReader(BufferedReader reader) {
        this.fReader = reader;
        Assert.isNotNull((Object)reader);
    }

    void ignoreSingleCR() {
        this.fIgnoreSingleCR = true;
    }

    String readLine() throws IOException {
        StringBuffer sb = null;
        while (!this.fSawEOF) {
            int c = this.readChar();
            if (c == -1) {
                this.fSawEOF = true;
                break;
            }
            if (sb == null) {
                sb = new StringBuffer();
            }
            sb.append((char)c);
            if (c == 10) break;
            if (c != 13) continue;
            c = this.readChar();
            if (c == -1) {
                this.fSawEOF = true;
                break;
            }
            if (c != 10) {
                if (this.fIgnoreSingleCR) {
                    sb.append((char)c);
                    continue;
                }
                this.fHaveChar = true;
                this.fLastChar = c;
                break;
            }
            sb.append((char)c);
            break;
        }
        if (sb != null) {
            return sb.toString();
        }
        return null;
    }

    void close() {
        try {
            this.fReader.close();
        }
        catch (IOException iOException) {}
    }

    List readLines() {
        try {
            try {
                String line;
                ArrayList<String> lines = new ArrayList<String>();
                while ((line = this.readLine()) != null) {
                    lines.add(line);
                }
                ArrayList<String> arrayList = lines;
                Object var3_4 = null;
                this.close();
                return arrayList;
            }
            catch (IOException iOException) {
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.close();
            throw throwable;
        }
        Object var3_6 = null;
        this.close();
        return null;
    }

    int lineContentLength(String line) {
        if (line == null) {
            return 0;
        }
        int length = line.length();
        int i = length - 1;
        while (i >= 0) {
            char c = line.charAt(i);
            if (c != '\n' && c != '\r') break;
            --length;
            --i;
        }
        return length;
    }

    private int readChar() throws IOException {
        if (this.fHaveChar) {
            this.fHaveChar = false;
            return this.fLastChar;
        }
        return this.fReader.read();
    }
}

