/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.eclipse.compare.internal.ComparePreferencePage;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.ExceptionHandler;
import org.eclipse.compare.internal.ListContentProvider;
import org.eclipse.compare.internal.ListDialog;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.PatchWizard;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorPart;

public class CompareWithPatchAction
implements IActionDelegate {
    private ISelection fSelection;
    private boolean fSavedFiles;

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        IResource[] resources = PatchWizard.getResource(this.fSelection);
        action.setEnabled(resources != null && resources.length == 1);
    }

    public void run(IAction action) {
        PatchWizard wizard = new PatchWizard(this.fSelection);
        if (this.areAllEditorsSaved()) {
            PatchWizardDialog dialog = new PatchWizardDialog(CompareUIPlugin.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    private boolean areAllEditorsSaved() {
        if (CompareUIPlugin.getDirtyEditors().length == 0) {
            return true;
        }
        if (!this.saveAllDirtyEditors()) {
            return false;
        }
        Shell shell = CompareUIPlugin.getShell();
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription description = workspace.getDescription();
            boolean autoBuild = description.isAutoBuilding();
            description.setAutoBuilding(false);
            workspace.setDescription(description);
            try {
                new ProgressMonitorDialog(shell).run(false, false, this.createRunnable());
                this.fSavedFiles = true;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                description.setAutoBuilding(autoBuild);
                workspace.setDescription(description);
                throw throwable;
            }
            Object var5_9 = null;
            description.setAutoBuilding(autoBuild);
            workspace.setDescription(description);
            return true;
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, shell, PatchMessages.getString("PatchAction.ExceptionTitle"), PatchMessages.getString("Exception"));
            return false;
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, shell, PatchMessages.getString("PatchAction.ExceptionTitle"), PatchMessages.getString("Exception"));
            return false;
        }
        catch (InterruptedException interruptedException) {
            Assert.isTrue((boolean)false);
            return false;
        }
    }

    private IRunnableWithProgress createRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) {
                IEditorPart[] editorsToSave = CompareUIPlugin.getDirtyEditors();
                pm.beginTask(PatchMessages.getString("PatchAction.SavingDirtyEditorsTask"), editorsToSave.length);
                int i = 0;
                while (i < editorsToSave.length) {
                    editorsToSave[i].doSave((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    pm.worked(1);
                    ++i;
                }
                pm.done();
            }
        };
    }

    private boolean saveAllDirtyEditors() {
        if (ComparePreferencePage.getSaveAllEditors()) {
            return true;
        }
        ListDialog dialog = new ListDialog(CompareUIPlugin.getShell()){

            protected Control createDialogArea(Composite parent) {
                Composite result = (Composite)super.createDialogArea(parent);
                Button check = new Button(result, 32);
                check.setText(PatchMessages.getString("PatchAction.AlwaysSaveQuestion"));
                check.setSelection(ComparePreferencePage.getSaveAllEditors());
                check.addSelectionListener((SelectionListener)new SelectionAdapter(check){
                    private final /* synthetic */ Button val$check;
                    {
                        this.val$check = button;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        ComparePreferencePage.setSaveAllEditors(this.val$check.getSelection());
                    }
                });
                Dialog.applyDialogFont((Control)result);
                return result;
            }
        };
        dialog.setTitle(PatchMessages.getString("PatchAction.SaveAllQuestion"));
        dialog.setAddCancelButton(true);
        dialog.setLabelProvider(this.createDialogLabelProvider());
        dialog.setMessage(PatchMessages.getString("PatchAction.SaveAllDescription"));
        dialog.setContentProvider(new ListContentProvider());
        dialog.setInput(Arrays.asList(CompareUIPlugin.getDirtyEditors()));
        return dialog.open() == 0;
    }

    private ILabelProvider createDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                return ((IEditorPart)element).getTitle();
            }
        };
    }

    static class PatchWizardDialog
    extends WizardDialog {
        PatchWizardDialog(Shell parent, IWizard wizard) {
            super(parent, wizard);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.setMinimumPageSize(700, 500);
        }
    }
}

