/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class Utilities {
    static /* synthetic */ Class class$0;

    public static void registerAction(IKeyBindingService kbs, IAction a, String id) {
        if (kbs != null) {
            a.setActionDefinitionId(id);
            kbs.registerAction(a);
        }
    }

    public static IWorkbenchPartSite findSite(Control c) {
        while (c != null && !c.isDisposed()) {
            Object data = c.getData();
            if (data instanceof IWorkbenchPart) {
                return ((IWorkbenchPart)data).getSite();
            }
            c = c.getParent();
        }
        return null;
    }

    public static IActionBars findActionBars(Control c) {
        while (c != null && !c.isDisposed()) {
            Object data = c.getData();
            if (data instanceof CompareEditor) {
                return ((CompareEditor)((Object)data)).getActionBars();
            }
            if (data instanceof IViewPart) {
                return ((IViewPart)data).getViewSite().getActionBars();
            }
            c = c.getParent();
        }
        return null;
    }

    public static void setEnableComposite(Composite composite, boolean enable) {
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setEnabled(enable);
            ++i;
        }
    }

    public static boolean getBoolean(CompareConfiguration cc, String key, boolean dflt) {
        Object value;
        if (cc != null && (value = cc.getProperty(key)) instanceof Boolean) {
            return (Boolean)value;
        }
        return dflt;
    }

    public static void firePropertyChange(ListenerList ll, Object source, String property, Object old, Object newValue) {
        if (ll != null) {
            PropertyChangeEvent event = null;
            Object[] listeners = ll.getListeners();
            int i = 0;
            while (i < listeners.length) {
                IPropertyChangeListener l = (IPropertyChangeListener)listeners[i];
                if (event == null) {
                    event = new PropertyChangeEvent(source, property, old, newValue);
                }
                l.propertyChange(event);
                ++i;
            }
        }
    }

    public static boolean okToUse(Widget widget) {
        return widget != null && !widget.isDisposed();
    }

    public static boolean isMotif() {
        return false;
    }

    public static Object[] toArray(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return new Object[0];
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        return ss.toArray();
    }

    public static IResource[] getResources(ISelection selection) {
        ArrayList<Object> tmp = new ArrayList<Object>();
        if (selection instanceof IStructuredSelection) {
            Object[] s = ((IStructuredSelection)selection).toArray();
            int i = 0;
            while (i < s.length) {
                Object o = s[i];
                if (o instanceof IResource) {
                    tmp.add(o);
                } else if (o instanceof IAdaptable) {
                    Object adapter;
                    IAdaptable a = (IAdaptable)o;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((adapter = a.getAdapter((Class)clazz)) instanceof IResource) {
                        tmp.add(adapter);
                    }
                }
                ++i;
            }
        }
        return tmp.toArray(new IResource[tmp.size()]);
    }

    public static byte[] readBytes(InputStream in) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            try {
                int c;
                while ((c = in.read()) != -1) {
                    bos.write(c);
                }
            }
            catch (IOException iOException) {
                Object var3_3 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException2) {}
                }
                try {
                    bos.close();
                }
                catch (IOException iOException3) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            try {
                bos.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var3_5 = null;
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        try {
            bos.close();
        }
        catch (IOException iOException) {}
        return bos.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readString(InputStream is) {
        BufferedReader reader;
        block12: {
            String string;
            if (is == null) {
                return null;
            }
            reader = null;
            try {
                try {
                    StringBuffer buffer = new StringBuffer();
                    char[] part = new char[2048];
                    int read = 0;
                    reader = new BufferedReader(new InputStreamReader(is, ResourcesPlugin.getEncoding()));
                    while (true) {
                        if ((read = reader.read(part)) == -1) {
                            string = buffer.toString();
                            Object var5_6 = null;
                            if (reader == null) return string;
                            break;
                        }
                        buffer.append(part, 0, read);
                    }
                }
                catch (IOException iOException) {
                    break block12;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            reader.close();
            return string;
        }
        Object var5_8 = null;
        if (reader == null) return null;
        try {}
        catch (IOException iOException) {
            return null;
        }
        reader.close();
        return null;
    }

    public static byte[] getBytes(String s) {
        try {
            return s.getBytes(ResourcesPlugin.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return s.getBytes();
        }
    }

    public static String getIconPath(Display display) {
        return "icons/full/";
    }

    public static void initAction(IAction a, ResourceBundle bundle, String prefix) {
        String labelKey = "label";
        String tooltipKey = "tooltip";
        String imageKey = "image";
        String descriptionKey = "description";
        if (prefix != null && prefix.length() > 0) {
            labelKey = String.valueOf(prefix) + labelKey;
            tooltipKey = String.valueOf(prefix) + tooltipKey;
            imageKey = String.valueOf(prefix) + imageKey;
            descriptionKey = String.valueOf(prefix) + descriptionKey;
        }
        a.setText(Utilities.getString(bundle, labelKey, labelKey));
        a.setToolTipText(Utilities.getString(bundle, tooltipKey, null));
        a.setDescription(Utilities.getString(bundle, descriptionKey, null));
        String relPath = Utilities.getString(bundle, imageKey, null);
        if (relPath != null && relPath.trim().length() > 0) {
            String ePath;
            String dPath;
            String cPath;
            if (relPath.indexOf("/") >= 0) {
                String path = relPath.substring(1);
                cPath = String.valueOf('c') + path;
                dPath = String.valueOf('d') + path;
                ePath = String.valueOf('e') + path;
            } else {
                cPath = "clcl16/" + relPath;
                dPath = "dlcl16/" + relPath;
                ePath = "elcl16/" + relPath;
            }
            ImageDescriptor id = CompareUIPlugin.getImageDescriptor(dPath);
            if (id != null) {
                a.setDisabledImageDescriptor(id);
            }
            if ((id = CompareUIPlugin.getImageDescriptor(cPath)) != null) {
                a.setHoverImageDescriptor(id);
            }
            if ((id = CompareUIPlugin.getImageDescriptor(ePath)) != null) {
                a.setImageDescriptor(id);
            }
        }
    }

    public static void initToggleAction(IAction a, ResourceBundle bundle, String prefix, boolean checked) {
        String tooltip = null;
        tooltip = checked ? Utilities.getString(bundle, String.valueOf(prefix) + "tooltip.checked", null) : Utilities.getString(bundle, String.valueOf(prefix) + "tooltip.unchecked", null);
        if (tooltip == null) {
            tooltip = Utilities.getString(bundle, String.valueOf(prefix) + "tooltip", null);
        }
        if (tooltip != null) {
            a.setToolTipText(tooltip);
        }
        String description = null;
        description = checked ? Utilities.getString(bundle, String.valueOf(prefix) + "description.checked", null) : Utilities.getString(bundle, String.valueOf(prefix) + "description.unchecked", null);
        if (description == null) {
            description = Utilities.getString(bundle, String.valueOf(prefix) + "description", null);
        }
        if (description != null) {
            a.setDescription(description);
        }
    }

    public static String getString(ResourceBundle bundle, String key, String dfltValue) {
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return dfltValue;
    }

    public static String getFormattedString(ResourceBundle bundle, String key, String arg) {
        if (bundle != null) {
            try {
                return MessageFormat.format(bundle.getString(key), arg);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return "!" + key + "!";
    }

    public static String getString(String key) {
        try {
            return CompareUIPlugin.getResourceBundle().getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
    }

    public static String getFormattedString(String key, String arg) {
        try {
            return MessageFormat.format(CompareUIPlugin.getResourceBundle().getString(key), arg);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
    }

    public static String getString(ResourceBundle bundle, String key) {
        return Utilities.getString(bundle, key, key);
    }

    public static int getInteger(ResourceBundle bundle, String key, int dfltValue) {
        if (bundle != null) {
            try {
                String s = bundle.getString(key);
                if (s != null) {
                    return Integer.parseInt(s);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return dfltValue;
    }
}

