/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class TimeoutContext {
    public static void run(boolean cancelable, int timeout, Shell parent, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        Throwable throwable;
        Display display = parent.getDisplay();
        ProgressMonitor pm = new ProgressMonitor();
        ModalContextThread t = new ModalContextThread(runnable, pm);
        t.start();
        try {
            t.join(timeout);
        }
        catch (InterruptedException interruptedException) {}
        if (t.timeout(display)) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(parent, cancelable, pm);
            dialog.open();
            t.block();
            dialog.close();
        }
        if ((throwable = t.fThrowable) != null) {
            if (throwable instanceof InvocationTargetException) {
                throw (InvocationTargetException)throwable;
            }
            if (throwable instanceof InterruptedException) {
                throw (InterruptedException)throwable;
            }
            if (throwable instanceof OperationCanceledException) {
                throw new InterruptedException(throwable.getMessage());
            }
            throw new InvocationTargetException(throwable);
        }
    }

    private static class ModalContextThread
    extends Thread {
        private boolean fWorking;
        private IRunnableWithProgress fRunnable;
        private Throwable fThrowable;
        private IProgressMonitor fProgressMonitor;
        private boolean fContinueEventDispatching = true;
        private Display fDisplay;

        ModalContextThread(IRunnableWithProgress operation, IProgressMonitor monitor) {
            super("TimeoutContext");
            this.fRunnable = operation;
            this.fProgressMonitor = monitor;
        }

        synchronized boolean timeout(Display display) {
            this.fDisplay = display;
            return this.fWorking;
        }

        public void run() {
            block11: {
                try {
                    try {
                        this.fWorking = true;
                        if (this.fRunnable != null) {
                            this.fRunnable.run(this.fProgressMonitor);
                        }
                    }
                    catch (InvocationTargetException e) {
                        this.fThrowable = e;
                    }
                    catch (InterruptedException e) {
                        this.fThrowable = e;
                    }
                    catch (RuntimeException e) {
                        this.fThrowable = e;
                    }
                    catch (ThreadDeath e) {
                        throw e;
                    }
                    catch (Error e) {
                        this.fThrowable = e;
                    }
                }
                catch (Throwable throwable) {
                    Object var2_7 = null;
                    this.fWorking = false;
                    if (this.fDisplay != null) {
                        this.fDisplay.syncExec(new Runnable(){

                            public void run() {
                            }
                        });
                        this.fContinueEventDispatching = false;
                        this.fDisplay.asyncExec(null);
                    }
                    throw throwable;
                }
                Object var2_8 = null;
                this.fWorking = false;
                if (this.fDisplay == null) break block11;
                this.fDisplay.syncExec(new /* invalid duplicate definition of identical inner class */);
                this.fContinueEventDispatching = false;
                this.fDisplay.asyncExec(null);
            }
        }

        public void block() {
            while (this.fContinueEventDispatching) {
                if (this.fDisplay.readAndDispatch()) continue;
                this.fDisplay.sleep();
            }
        }
    }

    static class ProgressMonitorDialog
    extends Dialog {
        protected ProgressIndicator fProgressIndicator;
        protected Label fTaskLabel;
        protected Label fSubTaskLabel;
        protected Button fCancel;
        protected boolean fEnableCancelButton;
        private ProgressMonitor fProgressMonitor;
        private Cursor fArrowCursor;
        private Cursor fWaitCursor;
        private Shell fParentShell;

        private ProgressMonitorDialog(Shell parent, boolean cancelable, ProgressMonitor pm) {
            super(parent);
            this.fProgressMonitor = pm;
            this.fParentShell = parent;
            this.fEnableCancelButton = cancelable;
            this.setBlockOnOpen(false);
            this.setShellStyle(67616);
        }

        public boolean close() {
            Shell shell;
            if (this.fCancel != null && !this.fCancel.isDisposed()) {
                this.fCancel.setCursor(null);
            }
            if ((shell = this.getShell()) != null && !shell.isDisposed()) {
                shell.setCursor(null);
            }
            if (this.fArrowCursor != null) {
                this.fArrowCursor.dispose();
            }
            if (this.fWaitCursor != null) {
                this.fWaitCursor.dispose();
            }
            this.fArrowCursor = null;
            this.fWaitCursor = null;
            return super.close();
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(JFaceResources.getString((String)"ProgressMonitorDialog.title"));
            if (this.fWaitCursor == null) {
                this.fWaitCursor = new Cursor((Device)shell.getDisplay(), 1);
            }
            shell.setCursor(this.fWaitCursor);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.fCancel = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
            if (this.fArrowCursor == null) {
                this.fArrowCursor = new Cursor((Device)this.fCancel.getDisplay(), 0);
            }
            this.fCancel.setCursor(this.fArrowCursor);
            this.fCancel.addListener(13, new Listener(this){
                private final /* synthetic */ ProgressMonitorDialog this$1;
                {
                    this.this$1 = progressMonitorDialog;
                }

                public void handleEvent(Event e) {
                    if (this.this$1.fCancel != null && !this.this$1.fCancel.isDisposed()) {
                        this.this$1.fCancel.setEnabled(false);
                    }
                    ProgressMonitorDialog.access$0(this.this$1).setCanceled(true);
                }
            });
            this.fCancel.setEnabled(this.fEnableCancelButton);
        }

        protected Control createDialogArea(Composite parent) {
            Composite c = (Composite)super.createDialogArea(parent);
            ((GridLayout)c.getLayout()).numColumns = 2;
            Label iconLabel = new Label(c, 16384);
            GridData gd = new GridData();
            iconLabel.setLayoutData((Object)gd);
            iconLabel.setFont(parent.getFont());
            Image i = JFaceResources.getImageRegistry().get("dialog_info_image");
            if (i != null) {
                iconLabel.setImage(i);
            } else {
                iconLabel.setText(JFaceResources.getString((String)"Image_not_found"));
            }
            this.fTaskLabel = new Label(c, 16448);
            this.fTaskLabel.setLayoutData((Object)new GridData(768));
            this.fTaskLabel.setFont(parent.getFont());
            this.fProgressIndicator = new ProgressIndicator(c);
            gd = new GridData();
            gd.heightHint = 15;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.fProgressIndicator.setLayoutData((Object)gd);
            this.fSubTaskLabel = new Label(c, 16448);
            gd = new GridData(768);
            gd.heightHint = 35;
            gd.horizontalSpan = 2;
            this.fSubTaskLabel.setLayoutData((Object)gd);
            this.fSubTaskLabel.setFont(parent.getFont());
            String s = this.fProgressMonitor.fTask;
            if (s == null) {
                s = "";
            }
            this.fTaskLabel.setText(s);
            if (this.fProgressMonitor.fMaxWork == -1) {
                this.fProgressIndicator.beginAnimatedTask();
            } else {
                this.fProgressIndicator.beginTask(this.fProgressMonitor.fMaxWork);
            }
            if (this.fProgressMonitor.fSubTask != null) {
                this.fSubTaskLabel.setText(this.fProgressMonitor.fSubTask);
            }
            this.fProgressIndicator.worked((double)this.fProgressMonitor.fWorked);
            this.fProgressMonitor.activate(this);
            Dialog.applyDialogFont((Control)c);
            return c;
        }

        void beginTask(String name, int totalWork) {
            this.fParentShell.getDisplay().syncExec(new Runnable(this, name, totalWork){
                private final /* synthetic */ ProgressMonitorDialog this$1;
                private final /* synthetic */ String val$name;
                private final /* synthetic */ int val$totalWork;
                {
                    this.this$1 = progressMonitorDialog;
                    this.val$name = string;
                    this.val$totalWork = n;
                }

                public void run() {
                    this.this$1.fTaskLabel.setText(this.val$name);
                    if (this.this$1.fProgressIndicator != null && this.this$1.fProgressIndicator.isDisposed()) {
                        if (this.val$totalWork == -1) {
                            this.this$1.fProgressIndicator.beginAnimatedTask();
                        } else {
                            this.this$1.fProgressIndicator.beginTask(this.val$totalWork);
                        }
                    }
                }
            });
        }

        void setTaskName(String name) {
            this.fParentShell.getDisplay().syncExec(new Runnable(this, name){
                private final /* synthetic */ ProgressMonitorDialog this$1;
                private final /* synthetic */ String val$name;
                {
                    this.this$1 = progressMonitorDialog;
                    this.val$name = string;
                }

                public void run() {
                    if (this.this$1.fTaskLabel != null && this.this$1.fTaskLabel.isDisposed()) {
                        this.this$1.fTaskLabel.setText(this.val$name);
                    }
                }
            });
        }

        void setSubTaskName(String name) {
            this.fParentShell.getDisplay().syncExec(new Runnable(this, name){
                private final /* synthetic */ String val$name;
                private final /* synthetic */ ProgressMonitorDialog this$1;
                {
                    this.this$1 = progressMonitorDialog;
                    this.val$name = string;
                }

                public void run() {
                    String n;
                    String string = n = this.val$name == null ? "" : this.val$name;
                    if (this.this$1.fSubTaskLabel != null && !this.this$1.fSubTaskLabel.isDisposed()) {
                        this.this$1.fSubTaskLabel.setText(n);
                    }
                }
            });
        }

        void done() {
            this.fParentShell.getDisplay().syncExec(new Runnable(this){
                private final /* synthetic */ ProgressMonitorDialog this$1;
                {
                    this.this$1 = progressMonitorDialog;
                }

                public void run() {
                    if (this.this$1.fProgressIndicator != null && !this.this$1.fProgressIndicator.isDisposed()) {
                        this.this$1.fProgressIndicator.sendRemainingWork();
                        this.this$1.fProgressIndicator.done();
                    }
                }
            });
        }

        void worked(double work) {
            this.fParentShell.getDisplay().syncExec(new Runnable(this, work){
                private final /* synthetic */ ProgressMonitorDialog this$1;
                private final /* synthetic */ double val$work;
                {
                    this.this$1 = progressMonitorDialog;
                    this.val$work = d;
                }

                public void run() {
                    if (this.this$1.fProgressIndicator != null && !this.this$1.fProgressIndicator.isDisposed()) {
                        this.this$1.fProgressIndicator.worked(this.val$work);
                    }
                }
            });
        }

        protected Point getInitialSize() {
            return this.getShell().computeSize(450, -1);
        }

        static /* synthetic */ ProgressMonitor access$0(ProgressMonitorDialog progressMonitorDialog) {
            return progressMonitorDialog.fProgressMonitor;
        }
    }

    private static class ProgressMonitor
    implements IProgressMonitor {
        private int fMaxWork;
        private String fTask;
        private String fSubTask;
        private int fWorked;
        private ProgressMonitorDialog fProgressMonitorDialog;
        private boolean fIsCanceled;

        ProgressMonitor() {
        }

        public void beginTask(String name, int totalWork) {
            this.fTask = name;
            this.fMaxWork = totalWork;
            this.fWorked = 0;
            if (this.fProgressMonitorDialog != null) {
                this.fProgressMonitorDialog.beginTask(name, totalWork);
            }
        }

        void activate(ProgressMonitorDialog dialog) {
            this.fProgressMonitorDialog = dialog;
        }

        public void done() {
            if (this.fProgressMonitorDialog != null) {
                this.fProgressMonitorDialog.done();
            }
        }

        public void setTaskName(String name) {
            this.fTask = name;
            if (this.fProgressMonitorDialog != null) {
                this.fProgressMonitorDialog.setTaskName(name);
            }
        }

        public boolean isCanceled() {
            return this.fIsCanceled;
        }

        public void setCanceled(boolean b) {
            this.fIsCanceled = b;
        }

        public void subTask(String name) {
            this.fSubTask = name;
            if (this.fProgressMonitorDialog != null) {
                this.fProgressMonitorDialog.setSubTaskName(name);
            }
        }

        public void worked(int work) {
            if (this.fProgressMonitorDialog != null) {
                this.internalWorked(work);
            } else {
                this.fWorked += work;
            }
        }

        public void internalWorked(double work) {
            if (this.fProgressMonitorDialog != null) {
                this.fProgressMonitorDialog.worked(work);
            }
        }
    }
}

