/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.OverlayPreferenceStore;
import org.eclipse.compare.internal.TabFolderLayout;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ComparePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREFIX = "org.eclipse.compare.";
    public static final String OPEN_STRUCTURE_COMPARE = "org.eclipse.compare.OpenStructureCompare";
    public static final String SYNCHRONIZE_SCROLLING = "org.eclipse.compare.SynchronizeScrolling";
    public static final String SHOW_PSEUDO_CONFLICTS = "org.eclipse.compare.ShowPseudoConflicts";
    public static final String INITIALLY_SHOW_ANCESTOR_PANE = "org.eclipse.compare.InitiallyShowAncestorPane";
    public static final String PREF_SAVE_ALL_EDITORS = "org.eclipse.compare.SaveAllEditors";
    public static final String SHOW_MORE_INFO = "org.eclipse.compare.ShowMoreInfo";
    public static final String IGNORE_WHITESPACE = "org.eclipse.compare.IgnoreWhitespace";
    public static final String USE_SINGLE_LINE = "org.eclipse.compare.UseSingleLine";
    private TextMergeViewer fPreviewViewer;
    private IPropertyChangeListener fPreferenceChangeListener;
    private CompareConfiguration fCompareConfiguration;
    private OverlayPreferenceStore fOverlayStore;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener;
    public final OverlayPreferenceStore.OverlayKey[] fKeys = new OverlayPreferenceStore.OverlayKey[]{new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.compare.OpenStructureCompare"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.compare.SynchronizeScrolling"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.compare.ShowPseudoConflicts"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.compare.InitiallyShowAncestorPane"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.compare.ShowMoreInfo"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.compare.IgnoreWhitespace"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.compare.SaveAllEditors"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.Background"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.Background.SystemDefault"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.compare.UseSingleLine")};

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(OPEN_STRUCTURE_COMPARE, true);
        store.setDefault(SYNCHRONIZE_SCROLLING, true);
        store.setDefault(SHOW_PSEUDO_CONFLICTS, false);
        store.setDefault(INITIALLY_SHOW_ANCESTOR_PANE, false);
        store.setDefault(SHOW_MORE_INFO, false);
        store.setDefault(IGNORE_WHITESPACE, false);
        store.setDefault(PREF_SAVE_ALL_EDITORS, false);
        store.setDefault(USE_SINGLE_LINE, true);
        store.setDefault("AbstractTextEditor.Color.Background.SystemDefault", true);
    }

    public ComparePreferencePage() {
        this.setPreferenceStore(CompareUIPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.fKeys);
        this.fPreferenceChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String key = event.getProperty();
                if (key.equals(ComparePreferencePage.INITIALLY_SHOW_ANCESTOR_PANE)) {
                    boolean b = ComparePreferencePage.this.fOverlayStore.getBoolean(ComparePreferencePage.INITIALLY_SHOW_ANCESTOR_PANE);
                    if (ComparePreferencePage.this.fCompareConfiguration != null) {
                        ComparePreferencePage.this.fCompareConfiguration.setProperty(ComparePreferencePage.INITIALLY_SHOW_ANCESTOR_PANE, new Boolean(b));
                    }
                }
            }
        };
        this.fOverlayStore.addPropertyChangeListener(this.fPreferenceChangeListener);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        super.performDefaults();
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            if (this.fPreferenceChangeListener != null) {
                this.fOverlayStore.removePropertyChangeListener(this.fPreferenceChangeListener);
                this.fPreferenceChangeListener = null;
            }
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    public static boolean getSaveAllEditors() {
        IPreferenceStore store = CompareUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(PREF_SAVE_ALL_EDITORS);
    }

    public static void setSaveAllEditors(boolean value) {
        IPreferenceStore store = CompareUIPlugin.getDefault().getPreferenceStore();
        store.setValue(PREF_SAVE_ALL_EDITORS, value);
    }

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.compare.compare_preference_page_context");
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item = new TabItem(folder, 0);
        item.setText(Utilities.getString("ComparePreferencePage.generalTab.label"));
        item.setControl(this.createGeneralPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(Utilities.getString("ComparePreferencePage.textCompareTab.label"));
        item.setControl(this.createTextComparePage((Composite)folder));
        this.initializeFields();
        Dialog.applyDialogFont((Control)folder);
        return folder;
    }

    private Control createGeneralPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.addCheckBox(composite, "ComparePreferencePage.structureCompare.label", OPEN_STRUCTURE_COMPARE, 0);
        this.addCheckBox(composite, "ComparePreferencePage.showMoreInfo.label", SHOW_MORE_INFO, 0);
        this.addCheckBox(composite, "ComparePreferencePage.ignoreWhitespace.label", IGNORE_WHITESPACE, 0);
        new Label(composite, 0);
        this.addCheckBox(composite, "ComparePreferencePage.saveBeforePatching.label", PREF_SAVE_ALL_EDITORS, 0);
        return composite;
    }

    private Control createTextComparePage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.addCheckBox(composite, "ComparePreferencePage.synchronizeScrolling.label", SYNCHRONIZE_SCROLLING, 0);
        this.addCheckBox(composite, "ComparePreferencePage.initiallyShowAncestorPane.label", INITIALLY_SHOW_ANCESTOR_PANE, 0);
        this.addCheckBox(composite, "ComparePreferencePage.showPseudoConflicts.label", SHOW_PSEUDO_CONFLICTS, 0);
        this.addCheckBox(composite, "ComparePreferencePage.useSingleLine.label", USE_SINGLE_LINE, 0);
        new Label(composite, 0);
        Label previewLabel = new Label(composite, 0);
        previewLabel.setText(Utilities.getString("ComparePreferencePage.preview.label"));
        Control previewer = this.createPreviewer(composite);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        gd.heightHint = this.convertHeightInCharsToPixels(13);
        previewer.setLayoutData((Object)gd);
        return composite;
    }

    private Control createPreviewer(Composite parent) {
        this.fCompareConfiguration = new CompareConfiguration(this.fOverlayStore);
        this.fCompareConfiguration.setAncestorLabel(Utilities.getString("ComparePreferencePage.ancestor.label"));
        this.fCompareConfiguration.setLeftLabel(Utilities.getString("ComparePreferencePage.left.label"));
        this.fCompareConfiguration.setLeftEditable(false);
        this.fCompareConfiguration.setRightLabel(Utilities.getString("ComparePreferencePage.right.label"));
        this.fCompareConfiguration.setRightEditable(false);
        this.fPreviewViewer = new TextMergeViewer(parent, 2048, this.fCompareConfiguration);
        this.fPreviewViewer.setInput(new DiffNode(12, new FakeInput("previewAncestor.txt"), new FakeInput("previewLeft.txt"), new FakeInput("previewRight.txt")));
        Control c = this.fPreviewViewer.getControl();
        c.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ComparePreferencePage.this.fCompareConfiguration != null) {
                    ComparePreferencePage.this.fCompareConfiguration.dispose();
                }
            }
        });
        return c;
    }

    private void initializeFields() {
        Iterator e = this.fCheckBoxes.keySet().iterator();
        while (e.hasNext()) {
            Button b = (Button)e.next();
            String key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
    }

    private Button addCheckBox(Composite parent, String labelKey, String key, int indentation) {
        String label = Utilities.getString(labelKey);
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(768);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        if (this.fCheckBoxListener == null) {
            this.fCheckBoxListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button button = (Button)e.widget;
                    ComparePreferencePage.this.fOverlayStore.setValue((String)ComparePreferencePage.this.fCheckBoxes.get(button), button.getSelection());
                }
            };
        }
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private String loadPreviewContentFromFile(String filename) {
        StringBuffer buffer;
        block11: {
            String separator = System.getProperty("line.separator");
            buffer = new StringBuffer(512);
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(filename)));
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                        buffer.append(separator);
                    }
                }
                catch (IOException io) {
                    CompareUIPlugin.log(io);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            Object var6_9 = null;
            if (reader == null) break block11;
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return buffer.toString();
    }

    class FakeInput
    implements ITypedElement,
    IStreamContentAccessor {
        String fContent;

        FakeInput(String name) {
            this.fContent = ComparePreferencePage.this.loadPreviewContentFromFile(name);
        }

        public Image getImage() {
            return null;
        }

        public String getName() {
            return "no name";
        }

        public String getType() {
            return "no type";
        }

        public InputStream getContents() {
            return new ByteArrayInputStream(this.fContent.getBytes());
        }
    }
}

