/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.contentmergeviewer;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class DelayedProgressMonitor
implements IProgressMonitor {
    ProgressMonitorDialog fProgressDialog;
    IProgressMonitor fRealProgressMonitor;
    String fTaskName;
    String fSubTaskName;
    int fTotalWork;
    int fWorked;
    boolean fCancelable;
    Shell fShell;
    int fTime;

    DelayedProgressMonitor(Shell shell) {
        this.fShell = shell;
    }

    public void beginTask(String name, int totalWork) {
        this.fTaskName = name;
        this.fTotalWork = totalWork;
        this.fTime = 0;
    }

    public void done() {
        if (this.fRealProgressMonitor != null) {
            this.fRealProgressMonitor.done();
        }
    }

    public void internalWorked(double work) {
        if (this.fRealProgressMonitor != null) {
            this.fRealProgressMonitor.internalWorked(work);
        }
    }

    private void checkTimeout() {
        if (this.fRealProgressMonitor == null) {
            this.fProgressDialog = new ProgressMonitorDialog(this.fShell);
            this.fProgressDialog.setCancelable(true);
            this.fProgressDialog.open();
            this.fRealProgressMonitor = this.fProgressDialog.getProgressMonitor();
            this.fRealProgressMonitor.beginTask(this.fTaskName, this.fTotalWork);
            if (this.fSubTaskName != null) {
                this.fRealProgressMonitor.subTask(this.fSubTaskName);
            }
            this.fRealProgressMonitor.worked(this.fWorked);
        }
    }

    public boolean isCanceled() {
        this.checkTimeout();
        if (this.fRealProgressMonitor != null) {
            return this.fRealProgressMonitor.isCanceled();
        }
        return false;
    }

    public void setCanceled(boolean value) {
        if (this.fRealProgressMonitor != null) {
            this.fRealProgressMonitor.setCanceled(value);
        } else {
            this.fCancelable = value;
        }
    }

    public void setTaskName(String name) {
        if (this.fRealProgressMonitor != null) {
            this.fRealProgressMonitor.setTaskName(name);
        } else {
            this.fTaskName = name;
        }
    }

    public void subTask(String name) {
        if (this.fRealProgressMonitor != null) {
            this.fRealProgressMonitor.subTask(name);
        } else {
            this.fSubTaskName = name;
        }
    }

    public void worked(int work) {
        if (this.fRealProgressMonitor != null) {
            this.fRealProgressMonitor.internalWorked((double)work);
        } else {
            this.fWorked += work;
            this.checkTimeout();
        }
    }

    public static void run(Shell shell, boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        block3: {
            DelayedProgressMonitor pm = new DelayedProgressMonitor(shell);
            pm.checkTimeout();
            try {
                ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)pm, (Display)shell.getDisplay());
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (pm.fProgressDialog != null) {
                    pm.fProgressDialog.close();
                }
                throw throwable;
            }
            Object var5_7 = null;
            if (pm.fProgressDialog == null) break block3;
            pm.fProgressDialog.close();
        }
    }
}

