/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.sap;

import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnIterator;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndexes;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.database.sap.DbSapColumn;
import com.sap.dictionary.database.sap.DbSapEnvironment;
import com.sap.dictionary.database.sap.DbSapIndex;
import com.sap.dictionary.database.sap.DbSapPrimaryKey;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

public class DbSapTable
extends DbTable {
    private static Location loc = Logger.getLocation("sap.DbSapTable");

    public DbSapTable() {
    }

    public DbSapTable(DbFactory factory) {
        super(factory);
    }

    public DbSapTable(DbFactory factory, String name) {
        super(factory, name);
    }

    public DbSapTable(DbFactory factory, DbSchema schema, String name) {
        super(factory, schema, name);
    }

    public DbSapTable(DbFactory factory, DbTable other) {
        super(factory, other);
    }

    public void setSpecificContentViaXml(XmlMap xmlMap) {
    }

    public void setColumnsViaDb(DbFactory factory) throws JddException {
        loc.entering("setColumnsViaDb");
        try {
            DbColumns columns = new DbColumns(factory);
            String tableName = this.getName();
            Connection con = factory.getConnection();
            DatabaseMetaData dbmd = NativeSQLAccess.getNativeMetaData((Connection)con);
            ResultSet rs = dbmd.getColumns(null, null, tableName, null);
            while (rs.next()) {
                String colName = rs.getString("COLUMN_NAME");
                short sqlType = rs.getShort("DATA_TYPE");
                String dbType = rs.getString("TYPE_NAME");
                int colSize = rs.getInt("COLUMN_SIZE");
                int decDigits = rs.getInt("DECIMAL_DIGITS");
                String defVal = rs.getString("COLUMN_DEF");
                int pos = rs.getInt("ORDINAL_POSITION");
                boolean isNotNull = rs.getString("IS_NULLABLE").trim().equalsIgnoreCase("NO");
                if (defVal != null) {
                    Number v;
                    if (dbType.equalsIgnoreCase("DATE") || dbType.equalsIgnoreCase("TIME") || dbType.equalsIgnoreCase("TIMESTAMP")) {
                        String defValUpper = (defVal = defVal.trim()).toUpperCase();
                        if (defValUpper.startsWith("DEFAULT")) {
                            int beg = defValUpper.indexOf("DEFAULT ");
                            defVal = defVal.substring(beg += 8);
                            defVal = defVal.trim();
                        }
                    } else if (dbType.equalsIgnoreCase("FLOAT")) {
                        try {
                            v = Double.valueOf(defVal);
                            defVal = ((Double)v).toString();
                        }
                        catch (NumberFormatException ex) {}
                    } else if (dbType.equalsIgnoreCase("INTEGER") || dbType.equalsIgnoreCase("SMALLINT")) {
                        try {
                            v = Integer.valueOf(defVal);
                            defVal = ((Integer)v).toString();
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                }
                DbColumn col = factory.makeDbColumn(colName, pos, sqlType, dbType, colSize, decDigits, isNotNull, defVal);
                columns.add(col);
            }
            rs.close();
            this.setColumns(columns);
            this.setNullableInfo(factory);
            this.setLongVarbinaryInfo(factory);
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setColumnsViaDb failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        loc.exiting();
    }

    public void setIndexesViaDb() throws JddException {
        loc.entering("setIndexesViaDb");
        ArrayList names = new ArrayList();
        DbFactory factory = this.getDbFactory();
        Connection con = factory.getConnection();
        try {
            names = this.dbGetIndexNames(con);
            if (!names.isEmpty()) {
                DbIndexes indexes = new DbIndexes(factory);
                int i = 0;
                while (i < names.size()) {
                    String indexName = (String)names.get(i);
                    DbSapIndex index = new DbSapIndex(factory, this.getSchema(), this.getName(), indexName);
                    index.setIndexes(indexes);
                    index.setCommonContentViaDb();
                    indexes.add(index);
                    ++i;
                }
                this.setIndexes(indexes);
            }
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setIndexesViaDb failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        loc.exiting();
    }

    public void setPrimaryKeyViaDb() throws JddException {
        loc.entering("setPrimaryKeyViaDb");
        String tabname = this.getName();
        DbSapPrimaryKey primaryKey = new DbSapPrimaryKey(this.getDbFactory(), tabname);
        try {
            primaryKey.setCommonContentViaDb();
            super.setPrimaryKey(primaryKey);
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setPrimaryKeyViaDb failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        loc.exiting();
    }

    public void setSpecificContentViaDb() {
    }

    public DbObjectSqlStatements getDdlStatementsForCreate() throws JddException {
        loc.entering("getDdlStatementsforCreate");
        DbObjectSqlStatements tableDef = new DbObjectSqlStatements(this.getName());
        DbSqlStatement createLine = new DbSqlStatement();
        try {
            createLine.addLine("CREATE TABLE \"" + this.getName() + "\"");
            createLine.merge(this.getColumns().getDdlClause());
            tableDef.add(createLine);
            if (this.getPrimaryKey() != null) {
                tableDef.merge(this.getPrimaryKey().getDdlStatementsForCreate());
            }
            if (this.getIndexes() != null) {
                tableDef.merge(this.getIndexes().getDdlStatementsForCreate());
            }
            if (this.getColumns() != null) {
                DbColumnIterator iter = this.getColumns().iterator();
                while (iter.hasNext()) {
                    DbSapColumn col = (DbSapColumn)iter.next();
                    if (col.getJavaSqlType() != -4 || DbSapEnvironment.isSpecJ2EEColumn(this.getName(), col.getName(), col.getJavaSqlTypeName())) continue;
                    tableDef.merge(col.getDdlStatementsForLongVarbinary(this.getName()));
                }
            }
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getDdlStatementsForCreate failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        loc.exiting();
        return tableDef;
    }

    public void writeSpecificContentToXmlFile(PrintWriter file, String offset0) {
        file.println(offset0 + "<?xml version=\"1.0\"?>");
        file.println(offset0 + "<db-spec>" + "</db-spec>");
    }

    public ArrayList dbGetIndexNames(Connection con) {
        loc.entering("dbGetIndexNames");
        ArrayList<String> names = new ArrayList<String>();
        try {
            PreparedStatement ps = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)"select indexname from domain.indexes where owner = USER and tablename = ? and indexname <> 'SYSPRIMARYKEYINDEX' ");
            String tabname = this.getName().toUpperCase();
            ps.setString(1, tabname);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                names.add(rs.getString(1));
            }
            rs.close();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("dbGetIndexNames failed: {0}", arguments);
            loc.exiting();
            System.out.println("Exception caught : " + ex.getMessage());
        }
        loc.exiting();
        return names;
    }

    private void setNullableInfo(DbFactory factory) {
        loc.entering("setNullableInfo");
        if (this.getColumns() == null || this.getColumns().isEmpty()) {
            loc.exiting();
            return;
        }
        Connection con = factory.getConnection();
        DbColumnIterator iter = this.getColumns().iterator();
        boolean isNotNull = false;
        try {
            PreparedStatement ps = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)"select nullable from domain.columns where tablename = ? and columnname = ?");
            while (iter.hasNext()) {
                DbColumn col = iter.next();
                if (col.isNotNull() || col.getDefaultValue() == null) continue;
                ps.setString(1, this.getName().toUpperCase());
                ps.setString(2, col.getName());
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    isNotNull = rs.getString(1).equals("NO");
                }
                rs.close();
                if (col.isNotNull() == isNotNull) continue;
                col.constructorPart(factory, col.getName(), col.getPosition(), col.getJavaSqlType(), col.getDbType(), col.getLength(), col.getDecimals(), isNotNull, col.getDefaultValue());
            }
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setNullableInfo failed: {0}", arguments);
            loc.exiting();
            System.out.println("Exception caught : " + ex.getMessage());
        }
        loc.exiting();
    }

    private void setLongVarbinaryInfo(DbFactory factory) {
        loc.entering("setLongVarbinaryInfo");
        if (this.getColumns() == null || this.getColumns().isEmpty()) {
            loc.exiting();
            return;
        }
        Connection con = factory.getConnection();
        DbColumnIterator iter = this.getColumns().iterator();
        String varInfo = null;
        try {
            PreparedStatement ps = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)"select comment from domain.columns where tablename = ? and columnname = ?");
            while (iter.hasNext()) {
                DbColumn col = iter.next();
                if (col.getJavaSqlType() != 2004) continue;
                ps.setString(1, this.getName().toUpperCase());
                ps.setString(2, col.getName());
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    varInfo = rs.getString(1);
                }
                rs.close();
                if (varInfo == null || !varInfo.startsWith("LONGVARBINARY")) continue;
                long length = Long.valueOf(varInfo.substring(varInfo.indexOf(40) + 1, varInfo.lastIndexOf(41)));
                col.constructorPart(factory, col.getName(), col.getPosition(), -4, col.getDbType(), length, col.getDecimals(), col.isNotNull(), col.getDefaultValue());
            }
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setLongVarbinaryInfo failed: {0}", arguments);
            loc.exiting();
            System.out.println("Exception caught : " + ex.getMessage());
        }
        loc.exiting();
    }

    public boolean existsOnDb() {
        loc.entering("existsOnDb");
        boolean exists = false;
        Connection conn = this.getDbFactory().getConnection();
        String stmtStr = "SELECT 1 FROM DOMAIN.TABLES WHERE OWNER = USER AND TABLENAME = ? AND TABLETYPE = ?";
        try {
            PreparedStatement ps = NativeSQLAccess.prepareNativeStatement((Connection)conn, (String)stmtStr);
            ps.setString(1, this.getName().toUpperCase());
            ps.setString(2, "TABLE");
            ResultSet rs = ps.executeQuery();
            exists = rs.next();
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("existsOnDb failed: {0}", arguments);
        }
        loc.exiting();
        return exists;
    }

    public boolean existsData() {
        loc.entering("existsData");
        boolean exists = false;
        Connection conn = this.getDbFactory().getConnection();
        String stmtStr = "SELECT 1 FROM DUAL WHERE EXISTS (SELECT * FROM \"" + this.getName().toUpperCase() + "\")";
        try {
            Statement stmt = NativeSQLAccess.createNativeStatement((Connection)conn);
            ResultSet rs = stmt.executeQuery(stmtStr);
            exists = rs.next();
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("existsData failed: {0}", arguments);
        }
        loc.exiting();
        return exists;
    }

    public boolean checkNameLength() {
        loc.entering("checkNameLength");
        int nameLen = this.getName().length();
        int maxLen = DbSapEnvironment.MaxNameLength();
        if (nameLen > 0 && nameLen <= maxLen) {
            loc.exiting();
            return true;
        }
        Object[] arguments = new Object[]{this.getName(), new Integer(nameLen), new Integer(maxLen)};
        loc.errorT("checkNameLength {0}: length {1} invalid (allowed range [1..{2}])", arguments);
        loc.exiting();
        return false;
    }

    public boolean checkNameForReservedWord() {
        loc.entering("checkNameForReservedWord");
        boolean isReserved = DbSapEnvironment.isReservedWord(this.getName());
        if (isReserved) {
            Object[] arguments = new Object[]{this.getName()};
            loc.errorT("{0} is a reserved word", arguments);
        }
        loc.exiting();
        return !isReserved;
    }

    public boolean checkWidth() {
        loc.entering("checkWidth");
        DbColumns columns = this.getColumns();
        DbColumnIterator iter = columns.iterator();
        int total = 0;
        int maxWidth = DbSapEnvironment.MaxTableLength();
        while (iter.hasNext()) {
            DbColumn column = iter.next();
            total = (int)((long)total + DbSapEnvironment.GetColumnLength(column, false));
        }
        if (total > maxWidth) {
            Object[] arguments = new Object[]{this.getName(), new Integer(total), new Integer(maxWidth)};
            loc.errorT("checkWidth {0}: total width({1}) greater than allowed maximum ({2})", arguments);
            loc.exiting();
            return false;
        }
        loc.exiting();
        return true;
    }
}

