/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.ora;

import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.dictionary.database.ora.DbOraParameters;
import java.io.PrintWriter;
import java.sql.ResultSet;

public class DbOraStorage {
    private Integer initial = null;
    private Integer next = null;
    private Integer minextents = null;
    private Object maxextents = null;
    private Integer pctincrease = null;
    private Integer freelists = null;
    private Integer freelistGroups = null;
    private String bufferPool = null;
    private boolean isNull = true;
    static /* synthetic */ Class class$java$lang$String;

    public Integer getInitial() {
        return this.initial;
    }

    public Integer getNext() {
        return this.next;
    }

    public Integer getMinextents() {
        return this.minextents;
    }

    public Object getMaxextents() {
        return this.maxextents;
    }

    public Integer getPctincrease() {
        return this.pctincrease;
    }

    public Integer getFreelists() {
        return this.freelists;
    }

    public Integer getFreelistGroups() {
        return this.freelistGroups;
    }

    public String getBufferPool() {
        return this.bufferPool;
    }

    public boolean isNull() {
        return this.isNull;
    }

    protected void setContentViaXml(XmlMap xmlStorage) {
        Object nextObject;
        if (xmlStorage.isEmpty()) {
            return;
        }
        Object initialObject = xmlStorage.get("initial");
        if (initialObject != null) {
            if (initialObject.getClass() == (class$java$lang$String == null ? (class$java$lang$String = DbOraStorage.class$("java.lang.String")) : class$java$lang$String)) {
                this.initial = xmlStorage.getIntegerObject("initial");
            } else {
                XmlMap xmlInitial = xmlStorage.getXmlMap("initial");
                Integer initial = xmlInitial.getIntegerObject("initial");
                String unit = xmlInitial.getString("unit");
                this.initial = unit != null ? ((unit = unit.trim().toUpperCase()).equals("K") ? new Integer(initial * 1024) : (unit.equals("M") ? new Integer(initial * 1024 * 1024) : initial)) : initial;
            }
        }
        if ((nextObject = xmlStorage.get("next")) != null) {
            if (nextObject.getClass() == (class$java$lang$String == null ? (class$java$lang$String = DbOraStorage.class$("java.lang.String")) : class$java$lang$String)) {
                this.next = xmlStorage.getIntegerObject("next");
            } else {
                XmlMap xmlNext = xmlStorage.getXmlMap("next");
                Integer next = xmlNext.getIntegerObject("next");
                String unit = xmlNext.getString("unit");
                this.next = unit != null ? ((unit = unit.trim().toUpperCase()).equals("K") ? new Integer(next * 1024) : (unit.equals("M") ? new Integer(next * 1024 * 1024) : next)) : next;
            }
        }
        this.minextents = xmlStorage.getIntegerObject("minextents");
        String maxextents = xmlStorage.getString("maxextents");
        if (maxextents != null) {
            this.maxextents = (maxextents = maxextents.trim().toUpperCase()).trim().equals("UNLIMITED") ? maxextents : xmlStorage.getIntegerObject("maxextents");
        }
        this.pctincrease = xmlStorage.getIntegerObject("pctincrease");
        this.freelists = xmlStorage.getIntegerObject("freelists");
        this.freelistGroups = xmlStorage.getIntegerObject("freelist-groups");
        String bufferPool = xmlStorage.getString("buffer-pool");
        if (bufferPool != null) {
            if ((bufferPool = bufferPool.trim().toUpperCase()).equals("KEEP") || bufferPool.equals("RECYCLE") || bufferPool.equals("DEFAULT")) {
                this.bufferPool = bufferPool;
            } else {
                System.out.println("Unkown Buffer Pool Content : " + bufferPool);
            }
        }
        if (this.initial != null || this.next != null || this.minextents != null || maxextents != null || this.pctincrease != null || this.freelists != null || this.freelistGroups != null) {
            this.isNull = false;
        }
    }

    protected void setContentViaDbCatalog(ResultSet resultSet, String ddicTable) {
        String prefix = "";
        int factor = 1;
        if (ddicTable.equals("USER_PART_TABLES") || ddicTable.equals("USER_PART_LOBS")) {
            prefix = "DEF_";
            factor = DbOraParameters.getDbBlockSize();
        }
        try {
            Integer intValue;
            Object object = resultSet.getObject(prefix + "INITIAL_EXTENT");
            if (!resultSet.wasNull()) {
                if (object.getClass().isInstance("")) {
                    if (!((String)object).equalsIgnoreCase("DEFAULT")) {
                        intValue = new Integer((String)object);
                        this.initial = new Integer(intValue * factor);
                        this.isNull = false;
                    }
                } else {
                    this.initial = new Integer(((Number)object).intValue());
                    this.isNull = false;
                }
            }
            object = resultSet.getObject(prefix + "NEXT_EXTENT");
            if (!resultSet.wasNull()) {
                if (object.getClass().isInstance("")) {
                    if (!((String)object).equalsIgnoreCase("DEFAULT")) {
                        intValue = new Integer((String)object);
                        this.next = new Integer(intValue * factor);
                        this.isNull = false;
                    }
                } else {
                    this.next = new Integer(((Number)object).intValue());
                    this.isNull = false;
                }
            }
            object = ddicTable.equals("USER_TAB_PARTITIONS") ? resultSet.getObject(prefix + "MIN_EXTENT") : resultSet.getObject(prefix + "MIN_EXTENTS");
            if (!resultSet.wasNull()) {
                if (object.getClass().isInstance("")) {
                    if (!((String)object).equalsIgnoreCase("DEFAULT")) {
                        this.minextents = new Integer((String)object);
                        this.isNull = false;
                    }
                } else {
                    this.minextents = new Integer(((Number)object).intValue());
                    this.isNull = false;
                }
            }
            object = ddicTable.equals("USER_TAB_PARTITIONS") ? resultSet.getObject(prefix + "MAX_EXTENT") : resultSet.getObject(prefix + "MAX_EXTENTS");
            if (!resultSet.wasNull()) {
                if (object.getClass().isInstance("")) {
                    if (!((String)object).equalsIgnoreCase("DEFAULT")) {
                        this.maxextents = new Integer((String)object);
                        this.isNull = false;
                    }
                } else {
                    this.maxextents = new Integer(((Number)object).intValue());
                    this.isNull = false;
                }
            }
            object = resultSet.getObject(prefix + "PCT_INCREASE");
            if (!resultSet.wasNull()) {
                if (object.getClass().isInstance("")) {
                    if (!((String)object).equalsIgnoreCase("DEFAULT")) {
                        this.pctincrease = new Integer((String)object);
                        this.isNull = false;
                    }
                } else {
                    this.pctincrease = new Integer(((Number)object).intValue());
                    this.isNull = false;
                }
            }
            if (ddicTable.equalsIgnoreCase("USER_TABLESPACES")) {
                return;
            }
            object = resultSet.getObject(prefix + "FREELISTS");
            if (!resultSet.wasNull()) {
                if (object.getClass().isInstance("")) {
                    if (!((String)object).equalsIgnoreCase("DEFAULT")) {
                        this.freelists = new Integer((String)object);
                        this.isNull = false;
                    }
                } else {
                    this.freelists = new Integer(((Number)object).intValue());
                    this.isNull = false;
                }
            }
            object = resultSet.getObject(prefix + "FREELIST_GROUPS");
            if (!resultSet.wasNull()) {
                if (object.getClass().isInstance("")) {
                    if (!((String)object).equalsIgnoreCase("DEFAULT")) {
                        this.freelistGroups = new Integer((String)object);
                        this.isNull = false;
                    }
                } else {
                    this.freelistGroups = new Integer(((Number)object).intValue());
                    this.isNull = false;
                }
            }
            String bufferPool = resultSet.getString(prefix + "BUFFER_POOL");
            if (!resultSet.wasNull()) {
                this.bufferPool = bufferPool;
                this.isNull = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.isNull = true;
        }
    }

    protected DbSqlStatement getDdlClause() {
        DbSqlStatement statement = new DbSqlStatement();
        statement.addLine(" STORAGE (");
        if (this.initial != null) {
            statement.addLine(" INITIAL " + this.initial);
        }
        if (this.next != null) {
            statement.addLine(" NEXT " + this.next);
        }
        if (this.minextents != null) {
            statement.addLine(" MINEXTENTS " + this.minextents);
        }
        if (this.maxextents != null) {
            statement.addLine(" MAXEXTENTS " + this.maxextents);
        }
        if (this.pctincrease != null) {
            statement.addLine(" PCTINCREASE " + this.pctincrease);
        }
        if (this.freelists != null && this.freelists != 0) {
            statement.addLine(" FREELISTS " + this.freelists);
        }
        if (this.freelistGroups != null && this.freelistGroups != 0) {
            statement.addLine(" FREELIST GROUPS " + this.freelistGroups);
        }
        if (this.bufferPool != null) {
            statement.addLine(" BUFFER_POOL " + this.bufferPool);
        }
        statement.addLine(" )");
        return statement;
    }

    public void writeContentToXmlFile(PrintWriter file, String offset0) {
        String offset1 = offset0 + XmlHelper.tabulate();
        file.println(offset0 + "<storage>");
        if (this.initial != null) {
            file.println(offset1 + "<initial>" + this.initial + "</initial>");
        }
        if (this.next != null) {
            file.println(offset1 + "<next>" + this.next + "</next>");
        }
        if (this.minextents != null) {
            file.println(offset1 + "<minextents>" + this.minextents + "</minextents>");
        }
        if (this.maxextents != null) {
            file.println(offset1 + "<maxextents>" + this.maxextents + "</maxextents>");
        }
        if (this.pctincrease != null) {
            file.println(offset1 + "<pctincrease>" + this.pctincrease + "</pctincrease>");
        }
        if (this.freelists != null) {
            file.println(offset1 + "<freelists>" + this.freelists + "</freelists>");
        }
        if (this.freelistGroups != null) {
            file.println(offset1 + "<freelist-groups>" + this.freelistGroups + "</freelist-groups>");
        }
        if (this.bufferPool != null) {
            file.println(offset1 + "<buffer-pool>" + this.bufferPool + "</buffer-pool>");
        }
        file.println(offset0 + "</storage>");
    }

    public String toString() {
        return "Initial               : " + this.initial + "\n" + "Next                  : " + this.next + "\n" + "Minextents            : " + this.minextents + "\n" + "Maxextents            : " + this.maxextents + "\n" + "Pctincrease           : " + this.pctincrease + "\n" + "Freelists             : " + this.freelists + "\n" + "FreelistGroups        : " + this.freelistGroups + "\n" + "bufferPool            : " + this.bufferPool + "\n";
    }

    public boolean equals(Object object) {
        if (!(object instanceof DbOraStorage)) {
            return false;
        }
        DbOraStorage storage = (DbOraStorage)object;
        if (storage.initial != this.initial) {
            return false;
        }
        if (storage.next != this.next) {
            return false;
        }
        if (storage.minextents != this.minextents) {
            return false;
        }
        if (storage.maxextents != this.maxextents) {
            return false;
        }
        if (storage.pctincrease != this.pctincrease) {
            return false;
        }
        if (storage.freelists != this.freelists) {
            return false;
        }
        if (storage.freelistGroups != this.freelistGroups) {
            return false;
        }
        return storage.bufferPool == this.bufferPool;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

