/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.ora;

import com.sap.dictionary.database.ora.DbOraPartitionColumn;
import com.sap.dictionary.database.ora.DbOraPartitioning;
import com.sap.dictionary.database.ora.DbOraPartitions;
import com.sap.dictionary.database.ora.DbOraTable;
import com.sap.sql.NativeSQLAccess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;

public class DbOraHashPartitioning
extends DbOraPartitioning {
    private ArrayList columnList = null;
    private ArrayList partitionList = null;
    private DbOraPartitions partitions = null;

    public ArrayList getColumnList() {
        return this.columnList;
    }

    public ArrayList getPartitionList() {
        return this.partitionList;
    }

    public DbOraPartitions getPartitions() {
        return this.partitions;
    }

    protected void setContentViaDbCatalog(Connection connection, DbOraTable table) {
        try {
            PreparedStatement preparedStatement = NativeSQLAccess.prepareNativeStatement((Connection)connection, (String)"SELECT * FROM   \"USER_PART_KEY_COLUMNS\" WHERE  \"NAME\" = ? ");
            preparedStatement.setString(1, table.getName().toUpperCase());
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<DbOraPartitionColumn> newColumnList = new ArrayList<DbOraPartitionColumn>();
            boolean newColumnListExists = false;
            while (resultSet.next()) {
                int position = resultSet.getInt("COLUMN_POSITION");
                String columnName = resultSet.getString("COLUMN_NAME");
                if (resultSet.wasNull()) continue;
                newColumnListExists = true;
                newColumnList.add(new DbOraPartitionColumn(columnName, position));
            }
            if (newColumnListExists) {
                Collections.sort(newColumnList);
                this.columnList = newColumnList;
            }
            preparedStatement.close();
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

