/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.opentools;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbObjectModificationAnalyser;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.DbsConstants;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.LoggingConfiguration;
import com.sap.dictionary.database.dbs.RuntimeObjectTable;
import com.sap.dictionary.database.opentools.OpenTools;
import com.sap.sql.services.OpenSQLServices;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;

public class DbTableOpenTools
implements OpenTools,
DbsConstants {
    private Connection con = null;
    private DbFactory factory = null;
    private static final Location loc = Location.getLocation((Class)(class$com$sap$dictionary$database$opentools$DbTableOpenTools == null ? (class$com$sap$dictionary$database$opentools$DbTableOpenTools = DbTableOpenTools.class$("com.sap.dictionary.database.opentools.DbTableOpenTools")) : class$com$sap$dictionary$database$opentools$DbTableOpenTools));
    private static final Category cat = Category.getCategory((String)"/Jddic/Database");
    private RuntimeObjectTable rt = null;
    static /* synthetic */ Class class$com$sap$dictionary$database$opentools$DbTableOpenTools;

    public DbTableOpenTools(Connection con) throws JddException {
        this.con = con;
        this.factory = new DbFactory(con);
        this.rt = new RuntimeObjectTable(this.factory, "BC_DDDBTABLERT");
        this.rt.createIfNecessary();
        if (!Logger.hasLogs(cat) && !Logger.hasLogs(loc)) {
            LoggingConfiguration.setProperty("default", "com.sap.dictionary.database.severity", "ERROR");
            Logger.setLoggingConfiguration("default");
        }
    }

    public boolean createTable(String name, File file) {
        loc.entering("opentools.createTable()");
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
        }
        catch (IOException ex) {
            JddException.log(ex, cat, 500, loc);
            loc.exiting();
            return false;
        }
        return this.createTable(name, stream);
    }

    public boolean createTable(String name, InputStream stream) {
        long tmst = 0L;
        boolean isOk = true;
        ByteArrayInputStream xmlStream = null;
        loc.entering("opentools.createTable()");
        try {
            String xmlString = this.saveStreamToString(stream);
            if (xmlString == null) {
                return false;
            }
            xmlStream = new ByteArrayInputStream(xmlString.getBytes());
            DbObjectModificationAnalyser analyser = new DbObjectModificationAnalyser(this.factory, xmlStream);
            DbObjectSqlStatements statements = analyser.modify();
            Action action = analyser.getAction();
            if (action == Action.CREATE) {
                cat.info(loc, DbsConstants.TABLE_CREATE, new Object[]{this.factory.getDatabaseName()});
                if (statements.execute(this.factory)) {
                    cat.info(loc, DbsConstants.TABLE_CREATE_SUCC, new Object[]{name});
                    tmst = new Date().getTime();
                    this.rt.setTimestamp(tmst);
                    if (xmlString == null) {
                        loc.exiting();
                        return false;
                    }
                    xmlStream = new ByteArrayInputStream(xmlString.getBytes());
                    if (this.rt.xmlWrite(name, xmlStream)) {
                        cat.info(loc, DbsConstants.RTXML_DBWRITE_SUCC, new Object[]{name});
                    } else {
                        cat.error(loc, DbsConstants.RTXML_DBWRITE_ERR, new Object[]{name});
                        isOk = false;
                    }
                    try {
                        Connection conn = this.factory.getConnection();
                        if (!conn.getAutoCommit()) {
                            conn.commit();
                        }
                    }
                    catch (SQLException ex) {
                        cat.error(loc, DbsConstants.COMMIT_NOT_SEND);
                        JddException.log(ex, cat, 500, loc);
                        isOk = false;
                        loc.exiting();
                    }
                    return isOk;
                }
                cat.info(loc, DbsConstants.TABLE_CREATE_ERR, new Object[]{name});
                loc.exiting();
                return false;
            }
            if (action == Action.NOTHING) {
                cat.info(loc, DbsConstants.TABLE_NOACTION);
                loc.exiting();
                return true;
            }
            cat.info(loc, DbsConstants.ACTION_NOT_POSSIBLE, new Object[]{action});
            loc.exiting();
            return false;
        }
        catch (Exception ex) {
            JddException.log(ex, cat, 500, loc);
            loc.exiting();
            return false;
        }
    }

    public boolean dropTable(String name) {
        boolean isOk = true;
        loc.entering("opentools.dropTable()");
        cat.info(loc, DbsConstants.TABLE_ANALYSE_START, new Object[]{name});
        try {
            DbTable table = this.factory.makeTable(name);
            DbObjectSqlStatements statements = table.getDdlStatementsForDrop();
            cat.info(loc, DbsConstants.TABLE_DELETE, new Object[]{this.factory.getDatabaseName()});
            if (statements.execute(this.factory)) {
                cat.info(loc, DbsConstants.TABLE_DELETE_SUCC, new Object[]{name});
                if (this.rt.xmlDelete(name)) {
                    cat.info(loc, DbsConstants.RTXML_DBDELETE_SUCC, new Object[]{name});
                } else {
                    isOk = false;
                    cat.warning(loc, DbsConstants.RTXML_DBDELETE_ERR, new Object[]{name});
                }
                Connection conn = this.factory.getConnection();
                try {
                    if (!conn.getAutoCommit()) {
                        conn.commit();
                    }
                }
                catch (SQLException ex) {
                    cat.error(loc, DbsConstants.COMMIT_NOT_SEND);
                    JddException.log(ex, cat, 500, loc);
                    isOk = false;
                }
                try {
                    OpenSQLServices.invalidateTable((Connection)conn, (String)name);
                }
                catch (SQLException ex) {
                    cat.warning(loc, DbsConstants.BUFFER_RESET_FAILURE, new Object[]{name});
                    JddException.log(ex, cat, 400, loc);
                }
                loc.exiting();
                return true;
            }
            cat.info(loc, DbsConstants.TABLE_DELETE_ERR, new Object[]{name});
            loc.exiting();
            return false;
        }
        catch (Exception ex) {
            cat.info(loc, DbsConstants.TABLE_DELETE_ERR, new Object[]{name});
            JddException.log(ex, cat, 500, loc);
            loc.exiting();
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    String saveStreamToString(InputStream inputStream) throws IOException {
        String s;
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer buffer = new StringBuffer();
        while ((s = br.readLine()) != null) {
            void var3_4;
            buffer.append((String)var3_4);
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

