/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.XmlMap;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlExtractor
extends DefaultHandler {
    private XMLReader xmlReader = null;
    private XmlMap currentVectorElement = null;
    private LinkedList stackOfOpenVectorElements = null;
    private HashMap currentSubelementsNames = null;
    private LinkedList stackOfSubelementsNames = null;
    private Event lastEvent = null;
    private Object currentValue = "";

    public XmlExtractor() {
        this.createXmlExtractor(false);
    }

    public XmlExtractor(boolean withValidation) {
        this.createXmlExtractor(withValidation);
    }

    private void createXmlExtractor(boolean withValidation) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.xmlReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace();
        }
        this.xmlReader.setContentHandler(this);
        this.xmlReader.setErrorHandler(new XMLErrorHandler(System.err));
        Thread.currentThread().setContextClassLoader(cl);
    }

    public XmlMap map(URL url) {
        try {
            this.xmlReader.parse(url.toString());
        }
        catch (SAXException se) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
        catch (Exception ex) {
            return null;
        }
        return this.currentVectorElement;
    }

    public XmlMap map(File file) {
        try {
            this.xmlReader.parse(file.toURL().toString());
        }
        catch (SAXException se) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
        catch (Exception ex) {
            return null;
        }
        return this.currentVectorElement;
    }

    public XmlMap map(InputSource source) {
        try {
            this.xmlReader.parse(source);
        }
        catch (SAXException se) {
            se.printStackTrace();
            return null;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return this.currentVectorElement;
    }

    public void startDocument() throws SAXException {
        this.stackOfOpenVectorElements = new LinkedList();
        this.stackOfSubelementsNames = new LinkedList();
        this.lastEvent = Event.ELEMENT_IN_PROCESS;
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
        if (this.lastEvent == Event.ELEMENT_IN_PROCESS) {
            this.openNewVectorElement();
        }
        this.lastEvent = Event.ELEMENT_IN_PROCESS;
        int i = 0;
        while (i < atts.getLength()) {
            if (i == 0) {
                this.openNewVectorElement();
                this.lastEvent = Event.END_ATTRIBUTES;
            }
            this.currentVectorElement.put(this.makeUniqueName(atts.getQName(i)), atts.getValue(i));
            ++i;
        }
        this.currentValue = "";
    }

    public void characters(char[] ch, int start, int length) {
        String s = new String(ch, start, length);
        this.currentValue = !this.currentValue.equals("") ? this.currentValue + s : this.currentValue + s;
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        if (this.lastEvent == Event.END_ELEMENT || this.lastEvent == Event.END_ATTRIBUTES) {
            if (this.lastEvent == Event.END_ATTRIBUTES) {
                this.currentVectorElement.put(this.makeUniqueName(rawName), this.currentValue);
            }
            this.currentValue = this.currentVectorElement;
            this.closeCurrentVectorElement();
        }
        this.currentVectorElement.put(this.makeUniqueName(rawName), this.currentValue);
        this.currentValue = "";
        this.lastEvent = Event.END_ELEMENT;
    }

    public void endDocument() throws SAXException {
    }

    public void openNewVectorElement() {
        if (this.currentVectorElement != null) {
            this.stackOfOpenVectorElements.addFirst(this.currentVectorElement);
        }
        this.currentVectorElement = new XmlMap();
        if (this.currentSubelementsNames != null) {
            this.stackOfSubelementsNames.addFirst(this.currentSubelementsNames);
        }
        this.currentSubelementsNames = new HashMap();
    }

    public void closeCurrentVectorElement() {
        this.currentVectorElement = (XmlMap)this.stackOfOpenVectorElements.removeFirst();
        this.currentSubelementsNames = (HashMap)this.stackOfSubelementsNames.removeFirst();
    }

    public String makeUniqueName(String basicName) {
        int counter = 0;
        String uniqueName = " ";
        Integer counterObject = (Integer)this.currentSubelementsNames.get(basicName);
        counter = counterObject == null ? 0 : counterObject;
        uniqueName = counter == 0 ? basicName : basicName + counter;
        this.currentSubelementsNames.put(basicName, new Integer(++counter));
        return uniqueName;
    }

    private static class Event {
        private String name = " ";
        public static final Event ELEMENT_IN_PROCESS = new Event("ELEMENT_IN_PROCESS");
        public static final Event END_ATTRIBUTES = new Event("END_ATTRIBUTES");
        public static final Event END_ELEMENT = new Event("END_ELEMENT");

        private Event(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class XMLErrorHandler
    implements ErrorHandler {
        private PrintStream out;

        XMLErrorHandler(PrintStream out) {
            this.out = out;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        public void warning(SAXParseException spe) throws SAXException {
            this.out.println("Warning: " + this.getParseExceptionInfo(spe));
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

