/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbMsgHandler;
import com.sap.dictionary.database.dbs.DbObjectModificationAnalyser;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbsConstants;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

public class RuntimeObject
implements DbsConstants {
    Connection con = null;
    DbFactory factory = null;
    XmlMap xmlMapH = null;
    XmlMap xmlMapX = null;
    String rtoNameH = null;
    String rtoNameX = null;
    long tmst = 0L;
    private static final Location loc = Location.getLocation((Class)(class$com$sap$dictionary$database$dbs$DbObjectModificationAnalyser == null ? (class$com$sap$dictionary$database$dbs$DbObjectModificationAnalyser = RuntimeObject.class$("com.sap.dictionary.database.dbs.DbObjectModificationAnalyser")) : class$com$sap$dictionary$database$dbs$DbObjectModificationAnalyser));
    private static final Category cat = Category.getCategory((String)"/Jddic/Database");
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$DbObjectModificationAnalyser;

    public RuntimeObject(DbFactory factory, XmlMap xmlMapH, String nameH, XmlMap xmlMapX, String nameX) {
        this.factory = factory;
        this.con = factory.getConnection();
        this.xmlMapH = xmlMapH;
        this.xmlMapX = xmlMapX;
        this.rtoNameH = nameH;
        this.rtoNameX = nameX;
    }

    public RuntimeObject(Connection con, XmlMap xmlMapH, String nameH, XmlMap xmlMapX, String nameX) {
        this.con = con;
        this.xmlMapH = xmlMapH;
        this.xmlMapX = xmlMapX;
        this.rtoNameH = nameH;
        this.rtoNameX = nameX;
    }

    public void setTimestamp(long tmst) {
        this.tmst = tmst;
    }

    public boolean create() {
        DbObjectSqlStatements statements = null;
        boolean isOk = false;
        try {
            DbObjectModificationAnalyser modifier;
            if (this.factory == null) {
                this.factory = new DbFactory(this.con);
            }
            if ((statements = (modifier = new DbObjectModificationAnalyser(this.factory, this.xmlMapH)).modify()) != null) {
                cat.info(loc, DbsConstants.INFO_GENERAL, new Object[]{statements.toString()});
                isOk = statements.execute(this.factory);
            } else if (modifier.getAction() == Action.NOTHING) {
                isOk = true;
            }
            if (!isOk) {
                return isOk;
            }
            modifier = new DbObjectModificationAnalyser(this.factory, this.xmlMapX);
            statements = modifier.modify();
            if (statements != null) {
                cat.info(loc, DbsConstants.INFO_GENERAL, new Object[]{statements.toString()});
                return statements.execute(this.factory) && isOk;
            }
        }
        catch (JddException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String xmlRead(String name) throws JddException {
        String xml = null;
        String statement = "SELECT \"XMLVALUE\" FROM \"&\" WHERE \"NAME\" = ?";
        statement = RuntimeObject.concat(statement, this.rtoNameX);
        try {
            PreparedStatement statementObject = NativeSQLAccess.prepareNativeStatement((Connection)this.con, (String)statement);
            statementObject.setString(1, name);
            ResultSet result = statementObject.executeQuery();
            if (result.next()) {
                Reader reader = result.getCharacterStream("XMLVALUE");
                try {
                    try {
                        BufferedReader bufferedReader = new BufferedReader(reader);
                        StringBuffer buffer = new StringBuffer();
                        while (true) {
                            void var8_11;
                            String s;
                            if ((s = bufferedReader.readLine()) == null) {
                                xml = buffer.toString();
                                break;
                            }
                            buffer.append((String)var8_11);
                        }
                    }
                    catch (IOException ex) {
                        throw new JddException(ExType.XML_ERROR, DbMsgHandler.get(DbsConstants.RTXML_ANALYSE_ERR, new Object[]{name}));
                    }
                    Object var11_12 = null;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    result.close();
                    throw throwable;
                }
                result.close();
            }
            statementObject.close();
            return xml;
        }
        catch (SQLException ex) {
            throw new JddException(ExType.SQL_ERROR, ex.getMessage());
        }
    }

    public String xmlReadWithLines(String name) throws JddException {
        String xml = "";
        String statement = "SELECT \"XMLLINE\" FROM \"&\" WHERE \"NAME\" = ?";
        statement = statement + " ORDER BY \"POSITION\"";
        statement = RuntimeObject.concat(statement, this.rtoNameX);
        try {
            PreparedStatement statementObject = NativeSQLAccess.prepareNativeStatement((Connection)this.con, (String)statement);
            statementObject.setString(1, name);
            ResultSet result = statementObject.executeQuery();
            while (result.next()) {
                xml = xml + result.getString("XMLLINE");
            }
            result.close();
            statementObject.close();
        }
        catch (SQLException ex) {
            throw new JddException(ExType.SQL_ERROR, ex.getMessage());
        }
        return xml;
    }

    public boolean xmlWriteHeader(String name) {
        String deleteStatement = "DELETE FROM \"&\" WHERE \"NAME\" = ?";
        String s = RuntimeObject.concat(deleteStatement, this.rtoNameH);
        String insertStatementH = "INSERT INTO \"&\" (NAME,TIMESTMP) VALUES (?, ?)";
        insertStatementH = RuntimeObject.concat(insertStatementH, this.rtoNameH);
        try {
            PreparedStatement delPstmt = NativeSQLAccess.prepareNativeStatement((Connection)this.con, (String)s);
            delPstmt.setString(1, name);
            delPstmt.executeUpdate();
            delPstmt.close();
            PreparedStatement insPstmt = NativeSQLAccess.prepareNativeStatement((Connection)this.con, (String)insertStatementH);
            insPstmt.setString(1, name);
            if (this.tmst == 0L) {
                this.tmst = new Date().getTime();
            }
            insPstmt.setLong(2, this.tmst);
            int rows = insPstmt.executeUpdate();
            insPstmt.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean xmlWrite(String name, InputStream stream) {
        String deleteStatement = "DELETE FROM \"&\" WHERE \"NAME\" = ?";
        deleteStatement = RuntimeObject.concat(deleteStatement, this.rtoNameX);
        String insertStatement = "INSERT INTO \"&\" (NAME,TIMESTMP,XMLVALUE) VALUES (?,?,?)";
        insertStatement = RuntimeObject.concat(insertStatement, this.rtoNameX);
        try {
            String s;
            PreparedStatement delPstmt = NativeSQLAccess.prepareNativeStatement((Connection)this.con, (String)deleteStatement);
            delPstmt.setString(1, name);
            delPstmt.executeUpdate();
            delPstmt.close();
            PreparedStatement insPstmt = NativeSQLAccess.prepareNativeStatement((Connection)this.con, (String)insertStatement);
            insPstmt.setString(1, name);
            if (this.tmst == 0L) {
                this.tmst = new Date().getTime();
            }
            insPstmt.setLong(2, this.tmst);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuffer buffer = new StringBuffer();
            while ((s = reader.readLine()) != null) {
                void var8_10;
                buffer.append((String)var8_10);
            }
            StringReader stringReader = new StringReader(buffer.toString());
            insPstmt.setCharacterStream(3, (Reader)stringReader, buffer.length());
            int rows = insPstmt.executeUpdate();
            insPstmt.close();
            return rows > 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JddException.log(ex, cat, 500, loc);
            return false;
        }
    }

    public boolean xmlWriteWithLines(String name, InputStream stream) {
        String deleteStatement = "DELETE FROM \"&\" WHERE \"NAME\" = ?";
        String s = RuntimeObject.concat(deleteStatement, this.rtoNameX);
        String insertStatementX = "INSERT INTO \"&\" (NAME,POSITION,XMLLINE) VALUES (?, ?, ?)";
        insertStatementX = RuntimeObject.concat(insertStatementX, this.rtoNameX);
        try {
            PreparedStatement delPstmt = NativeSQLAccess.prepareNativeStatement((Connection)this.con, (String)s);
            delPstmt.setString(1, name);
            delPstmt.executeUpdate();
            delPstmt.close();
            PreparedStatement insPstmt = NativeSQLAccess.prepareNativeStatement((Connection)this.con, (String)insertStatementX);
            insPstmt.setString(1, name);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            s = null;
            int position = 1;
            int rows = 0;
            insPstmt.setString(1, name);
            while ((s = reader.readLine()) != null) {
                insPstmt.setInt(2, position);
                if (s.indexOf("description") >= 0) continue;
                insPstmt.setString(3, s.trim());
                rows += insPstmt.executeUpdate();
                ++position;
            }
            insPstmt.close();
            return rows > 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JddException.log(ex, cat, 500, loc);
            return false;
        }
    }

    public boolean xmlDelete(String name) {
        Object statementObject = null;
        String statement = "DELETE FROM \"&\" WHERE NAME = ?";
        String s = RuntimeObject.concat(statement, this.rtoNameH);
        try {
            PreparedStatement delPstmt = NativeSQLAccess.prepareNativeStatement((Connection)this.con, (String)s);
            delPstmt.setString(1, name);
            delPstmt.execute();
            delPstmt.close();
            s = RuntimeObject.concat(statement, this.rtoNameX);
            delPstmt = NativeSQLAccess.prepareNativeStatement((Connection)this.con, (String)s);
            delPstmt.setString(1, name);
            delPstmt.execute();
            delPstmt.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    protected static String concat(String text, String replaceString) {
        int position = text.indexOf(38);
        return text.substring(0, position) + replaceString + text.substring(position + 1, text.length());
    }

    protected static String concat(String text, String replaceString1, String replaceString2) {
        String[] replaceStrings = new String[]{replaceString1, replaceString2};
        return RuntimeObject.concat(text, replaceStrings);
    }

    public static String concat(String text, String[] replaceString) {
        int position = 0;
        String before = text;
        String after = "";
        int i = 0;
        while (i < replaceString.length) {
            position = before.indexOf(38);
            after = after + before.substring(0, position) + replaceString[i];
            before = before.substring(position + 1, before.length());
            ++i;
        }
        return after;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

