/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.DbMsgHandler;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.GenExceptionInfo;
import com.sap.dictionary.database.dbs.IGenException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;

public class JddException
extends Exception
implements IGenException {
    GenExceptionInfo info = null;
    private static final ExType EX_TYPE_NULL = null;
    private static final Throwable CAUSE_NULL = null;
    private static final Object[] ARGS_NULL = null;

    public JddException() {
        this.info = new GenExceptionInfo(this, EX_TYPE_NULL, CAUSE_NULL);
    }

    public JddException(String message) {
        super(message);
        this.info = new GenExceptionInfo(this, EX_TYPE_NULL, CAUSE_NULL);
    }

    public JddException(ExType exType, String message) {
        super(message);
        this.info = new GenExceptionInfo(this, exType, CAUSE_NULL);
    }

    public JddException(ExType exType, Throwable cause) {
        this.info = new GenExceptionInfo(this, exType, cause);
    }

    public JddException(ExType exType, String message, Throwable cause) {
        super(message);
        this.info = new GenExceptionInfo(this, exType, cause);
    }

    public JddException(Object msgCode, Category cat, int severity, Location loc) {
        this(EX_TYPE_NULL, CAUSE_NULL, msgCode, ARGS_NULL, cat, severity, loc);
    }

    public JddException(Object msgCode, Object[] args, Category cat, int severity, Location loc) {
        this(EX_TYPE_NULL, CAUSE_NULL, msgCode, args, cat, severity, loc);
    }

    public JddException(Throwable cause, Object msgCode, Category cat, int severity, Location loc) {
        this(EX_TYPE_NULL, cause, msgCode, ARGS_NULL, cat, severity, loc);
    }

    public JddException(Throwable cause, Object msgCode, Object[] args, Category cat, int severity, Location loc) {
        this(EX_TYPE_NULL, cause, msgCode, args, cat, severity, loc);
    }

    public JddException(ExType exType, Object msgCode, Category cat, int severity, Location loc) {
        this(exType, CAUSE_NULL, msgCode, ARGS_NULL, cat, severity, loc);
    }

    public JddException(ExType exType, Object msgCode, Object[] args, Category cat, int severity, Location loc) {
        this(exType, CAUSE_NULL, msgCode, args, cat, severity, loc);
    }

    public JddException(ExType exType, Throwable cause, Object msgCode, Category cat, int severity, Location loc) {
        this(exType, cause, msgCode, null, cat, severity, loc);
    }

    public JddException(ExType exType, Throwable cause, Object msgCode, Object[] args, Category cat, int severity, Location loc) {
        super((msgCode == null ? "" : DbMsgHandler.get(msgCode, args)) + (cause == null ? "" : " Caused by: " + cause.getMessage()));
        this.info = new GenExceptionInfo(this, exType, cause, msgCode, args, cat, severity, loc);
    }

    public void printStackTrace() {
        if (this.info.getCause() != null) {
            this.info.getCause().printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    public static JddException createInstance(Throwable cause) {
        if (cause instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        if (cause instanceof JddException) {
            return (JddException)cause;
        }
        if (cause instanceof SQLException) {
            return new JddException(ExType.SQL_ERROR, cause.getMessage(), cause);
        }
        return new JddException(ExType.OTHER, cause.getMessage(), cause);
    }

    public static JddException createInstance(Throwable cause, Category cat, int severity, Location loc) {
        if (cause instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        if (cause instanceof IGenException) {
            IGenException iGenCause = (IGenException)((Object)cause);
            iGenCause.getInfo().intLog(cat, severity, loc);
        }
        if (cause instanceof JddException) {
            return (JddException)cause;
        }
        if (cause instanceof SQLException) {
            return new JddException(ExType.SQL_ERROR, cause, null, null, cat, severity, loc);
        }
        return new JddException(ExType.OTHER, cause, null, null, cat, severity, loc);
    }

    public static void log(Throwable cause, Category cat, int severity, Location loc) {
        JddException.createInstance(cause, cat, severity, loc);
    }

    public static void log(Throwable cause, Object msgCode, Category cat, int severity, Location loc) {
        JddException.log(cause, msgCode, null, cat, severity, loc);
    }

    public static void log(Throwable cause, Object msgCode, Object[] args, Category cat, int severity, Location loc) {
        cat.log(severity, loc, msgCode, args);
        JddException.createInstance(cause, cat, severity, loc);
    }

    public String getStackTraceString() {
        return this.info.getStackTraceString();
    }

    public ExType getExType() {
        return this.info.getExType();
    }

    public GenExceptionInfo getInfo() {
        return this.info;
    }
}

