/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.JavaSqlTypeInfo;
import java.lang.reflect.Field;
import java.util.HashMap;

public class JavaSqlTypes {
    private static final HashMap typesViaName = new HashMap();
    private static final HashMap typesViaIntValue = new HashMap();
    private final HashMap typesInfoViaName = new HashMap();
    private final HashMap typesInfoViaIntValue = new HashMap();

    public JavaSqlTypes(DbFactory factory) {
        try {
            Class<?> types = Class.forName("java.sql.Types");
            Field[] fields = types.getFields();
            JavaSqlTypeInfo info = null;
            int i = 0;
            while (i < fields.length) {
                String name = fields[i].getName();
                int value = fields[i].getInt(types);
                info = factory.makeJavaSqlTypeInfo(name, value);
                this.typesInfoViaName.put(name, info);
                this.typesInfoViaIntValue.put(new Integer(value), info);
                ++i;
            }
        }
        catch (Exception ex) {
            System.out.println("Exception caught in class JavaSqlTypes: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static String getName(int value) {
        return (String)typesViaIntValue.get(new Integer(value));
    }

    public static int getIntCode(String name) {
        Object type = typesViaName.get(name.toUpperCase());
        if (type == null) {
            return 1111;
        }
        return (Integer)type;
    }

    public JavaSqlTypeInfo getInfo(String name) {
        return (JavaSqlTypeInfo)this.typesInfoViaName.get(name.toUpperCase());
    }

    public JavaSqlTypeInfo getInfo(int value) {
        return (JavaSqlTypeInfo)this.typesInfoViaIntValue.get(new Integer(value));
    }

    static {
        try {
            Class<?> types = Class.forName("java.sql.Types");
            Field[] fields = types.getFields();
            int i = 0;
            while (i < fields.length) {
                String name = fields[i].getName();
                int value = fields[i].getInt(types);
                typesViaName.put(name, new Integer(value));
                typesViaIntValue.put(new Integer(value), name);
                ++i;
            }
        }
        catch (Exception ex) {
            System.out.println("Exception caught in class JavaSqlTypes: " + ex.getMessage());
            ex.printStackTrace();
        }
    }
}

