/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbColumnsDifference;
import com.sap.dictionary.database.dbs.DbIndexesDifference;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbPrimaryKeyDifference;
import com.sap.dictionary.database.dbs.DbTable;

public class DbTableDifference {
    private DbTable origin = null;
    private DbTable target = null;
    private Action action = null;
    private DbColumnsDifference columnsDifference = null;
    private DbIndexesDifference indexesDifference = null;
    private DbPrimaryKeyDifference primaryKeyDifference = null;

    public DbTableDifference(DbTable origin, DbTable target) {
        this.origin = origin;
        this.target = target;
    }

    public DbTableDifference(DbTable origin, DbTable target, Action action) {
        this.origin = origin;
        this.target = target;
        this.action = action;
    }

    public void setColumnsDifference(DbColumnsDifference difference) {
        this.columnsDifference = difference;
    }

    public void setIndexesDifference(DbIndexesDifference difference) {
        this.indexesDifference = difference;
    }

    public void setPrimaryKeyDifference(DbPrimaryKeyDifference difference) {
        this.primaryKeyDifference = difference;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public DbTable getOrigin() {
        return this.origin;
    }

    public DbTable getTarget() {
        return this.target;
    }

    public Action getAction() {
        return this.action;
    }

    public DbColumnsDifference getColumnsDifference() {
        return this.columnsDifference;
    }

    public DbIndexesDifference getIndexesDifference() {
        return this.indexesDifference;
    }

    public DbPrimaryKeyDifference getPrimaryKeyDifference() {
        return this.primaryKeyDifference;
    }

    public DbObjectSqlStatements getDdlStatements(String tableName) throws Exception {
        return this.getDdlStatements(tableName, null);
    }

    public DbObjectSqlStatements getDdlStatements(String tableName, DbTable tableForStorageInfo) throws Exception {
        DbObjectSqlStatements stmts = new DbObjectSqlStatements(tableName);
        if (this.columnsDifference != null) {
            stmts.merge(this.columnsDifference.getDdlStatementsForAlter(tableName));
        }
        if (this.indexesDifference != null) {
            stmts.merge(this.indexesDifference.getDdlStatements(tableName, tableForStorageInfo));
        }
        if (this.primaryKeyDifference != null) {
            stmts.merge(this.primaryKeyDifference.getDdlStatements(tableName, tableForStorageInfo));
        }
        return stmts;
    }

    public String toString() {
        return "Original Table   = " + (this.origin == null ? "null" : this.origin.getName()) + "\n" + "Target Table     = " + (this.target == null ? "null" : this.target.getName()) + "\n" + "Action           = " + (this.action == null ? "null" : this.action.getName()) + "\n" + "ColumnsAction    = " + (this.columnsDifference == null ? "null" : this.columnsDifference.getAction().getName()) + "\n" + "IndexesAction    = " + (this.indexesDifference == null ? "null" : "ALTER") + "\n" + "PrimaryKeyAction = " + (this.primaryKeyDifference == null ? "null" : this.primaryKeyDifference.getAction().getName()) + "\n";
    }
}

