/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbsConstants;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DbObjectModificationExecutor
implements DbsConstants {
    InputStream stream = null;
    Connection con = null;
    boolean positionIsRelevant = false;
    Action action = null;
    String tableName = null;
    String statements = "";
    boolean statementFromDb = false;
    int begin = 0;
    int end = 0;
    private static final Location loc = Location.getLocation((Class)(class$com$sap$dictionary$database$dbs$DbObjectModificationExecutor == null ? (class$com$sap$dictionary$database$dbs$DbObjectModificationExecutor = DbObjectModificationExecutor.class$("com.sap.dictionary.database.dbs.DbObjectModificationExecutor")) : class$com$sap$dictionary$database$dbs$DbObjectModificationExecutor));
    private static final Category cat = Category.getCategory((String)"/Jddic/Database");
    static /* synthetic */ Class class$com$sap$dictionary$database$dbs$DbObjectModificationExecutor;

    public DbObjectModificationExecutor(DbFactory factory, InputStream stream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String s = null;
        try {
            while ((s = reader.readLine()) != null) {
                this.statements = this.statements + " " + s;
            }
        }
        catch (IOException ex) {
            System.out.println("Exception caught during Statement-Reading from file\n" + ex.getMessage());
            cat.error(loc, DbsConstants.STATEMENT_RD_EX, new Object[]{ex.getMessage()});
            ex.printStackTrace();
        }
        this.con = factory.getConnection();
        this.tableName = this.tableName;
    }

    public DbObjectModificationExecutor(DbFactory factory, String tableName) {
        this.con = factory.getConnection();
        this.tableName = tableName;
        this.statements = this.getStatementsFromDb();
    }

    public boolean execute() throws JddException {
        Statement statementObject = null;
        try {
            statementObject = NativeSQLAccess.createNativeStatement((Connection)this.con);
        }
        catch (Exception ex) {
            System.out.println("Exception caught while preparing Statement\n" + this.statements);
            cat.error(loc, DbsConstants.STATEMENT_PREP_EX, new Object[]{this.statements});
            ex.printStackTrace();
            return false;
        }
        String statement = null;
        this.begin = 0;
        this.end = 0;
        while ((statement = this.getNextExecutableStatement()) != null) {
            try {
                statementObject.executeUpdate(statement.trim());
            }
            catch (Exception ex) {
                cat.error(loc, DbsConstants.STATEMENT_EXEC_EX, new Object[]{ex.getMessage(), statement});
                return false;
            }
        }
        try {
            statementObject.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return true;
    }

    private String getStatementsFromDb() {
        Statement statementObject = null;
        String getStatement = "select * from jddtddl where tablename = '" + this.tableName + "'";
        String statements = null;
        try {
            statementObject = NativeSQLAccess.createNativeStatement((Connection)this.con);
            ResultSet result = null;
            try {
                result = statementObject.executeQuery(getStatement);
                result.next();
                Clob clob = result.getClob("statements");
                statements = clob.getSubString(1L, 5000);
                statementObject.close();
            }
            catch (Exception ex) {
                cat.error(loc, DbsConstants.STATEMENT_EXEC_EX, new Object[]{ex.getMessage(), getStatement});
            }
        }
        catch (Exception ex) {
            System.out.println("Exception caught while preparing Statement\n" + getStatement);
            cat.error(loc, DbsConstants.STATEMENT_PREP_EX, new Object[]{getStatement});
        }
        return statements;
    }

    public String getNextExecutableStatement() {
        String s = null;
        this.end = this.statements.indexOf("***", this.begin);
        if (this.end != -1) {
            s = this.statements.substring(this.begin, this.end);
            this.begin = this.end + 3;
        }
        if (this.end >= this.statements.length()) {
            s = null;
        }
        return s;
    }

    public boolean deleteStatementsFromDb() {
        String deleteStatement = "delete from jddtddl where tablename = '" + this.tableName + "'";
        Statement statementObject = null;
        try {
            statementObject = NativeSQLAccess.createNativeStatement((Connection)this.con);
        }
        catch (Exception ex) {
            System.out.println("Exception caught while preparing Statement" + deleteStatement);
            cat.error(loc, DbsConstants.STATEMENT_PREP_EX, new Object[]{deleteStatement});
            ex.printStackTrace();
            return false;
        }
        try {
            statementObject.executeUpdate(deleteStatement);
            statementObject.close();
        }
        catch (Exception ex) {
            System.out.println("Exception caught during SQL-Execution\n" + ex.getMessage() + "\n" + deleteStatement);
            ex.printStackTrace();
            cat.error(loc, DbsConstants.STATEMENT_EXEC_EX, new Object[]{ex.getMessage(), deleteStatement});
            return false;
        }
        return true;
    }

    public boolean deleteStatementFile(String filename) {
        File file = new File(filename);
        return file.delete();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

