/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbIndexDifference;
import com.sap.dictionary.database.dbs.DbIndexes;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbTable;
import java.util.Iterator;
import java.util.LinkedList;

public class DbIndexesDifference {
    private LinkedList diffs = new LinkedList();
    private DbIndexes origin = null;
    private DbIndexes target = null;

    public DbIndexesDifference(DbIndexes origin, DbIndexes target) {
        this.origin = origin;
        this.target = target;
    }

    public boolean isEmpty() {
        return this.diffs.isEmpty();
    }

    public void add(DbIndexDifference difference) {
        this.diffs.add(difference);
    }

    protected DbObjectSqlStatements getDdlStatements(String tableName) throws Exception {
        return this.getDdlStatements(tableName, null);
    }

    protected DbObjectSqlStatements getDdlStatements(String tableName, DbTable tableForStorageInfo) throws Exception {
        DbObjectSqlStatements stmts = new DbObjectSqlStatements(tableName);
        if (this.origin == null) {
            return this.target.getDdlStatementsForCreate();
        }
        if (this.target == null) {
            return this.origin.getDdlStatementsForDrop();
        }
        Iterator iterator = this.diffs.iterator();
        DbIndexDifference diff = null;
        while (iterator.hasNext()) {
            diff = (DbIndexDifference)iterator.next();
            if (diff.getAction() == Action.DROP) {
                stmts.merge(diff.getOrigin().getDdlStatementsForDrop());
                continue;
            }
            if (diff.getAction() == Action.CREATE) {
                stmts.merge(diff.getTarget().getDdlStatementsForCreate());
                continue;
            }
            stmts.merge(diff.getDdlStatements(tableName, tableForStorageInfo));
        }
        return stmts;
    }

    public Iterator iterator() {
        return this.diffs.iterator();
    }

    public String toString() {
        String s = "";
        Iterator iterator = this.diffs.iterator();
        while (iterator.hasNext()) {
            s = s + iterator.next();
        }
        return s;
    }
}

