/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.dbs;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbDeploymentInfo;
import com.sap.dictionary.database.dbs.DbDeploymentStatus;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndexColumnInfo;
import com.sap.dictionary.database.dbs.DbIndexDifference;
import com.sap.dictionary.database.dbs.DbIndexes;
import com.sap.dictionary.database.dbs.DbMsgHandler;
import com.sap.dictionary.database.dbs.DbObject;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.DbsConstants;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class DbIndex
extends DbObject
implements DbsConstants {
    private DbFactory factory = null;
    private DbSchema schema = null;
    private String name = " ";
    private boolean isCaseSensitive = false;
    private String tableName = " ";
    private boolean tableNameIsCaseSensitive = false;
    private boolean isUnique = false;
    private ArrayList columnsInfo = null;
    private DbDeploymentInfo deploymentInfo = null;
    private DbDeploymentStatus deploymentStatus = null;
    private DbIndexes indexes = null;
    private boolean dbSpecificIsSet = false;
    private DbIndex next = null;
    private DbIndex previous = null;
    private boolean isSet = false;

    public DbIndex() {
    }

    public DbIndex(DbFactory factory) {
        this.factory = factory;
    }

    public DbIndex(DbFactory factory, DbIndex other) {
        this.factory = factory;
    }

    public DbIndex(DbFactory factory, String tableName, String name) {
        this.factory = factory;
        this.name = name;
        this.tableName = tableName;
    }

    public DbIndex(DbFactory factory, DbSchema schema, String tableName, String name) {
        this.factory = factory;
        this.schema = schema;
        this.name = name;
        this.tableName = tableName;
    }

    public void setContent(boolean isUnique, ArrayList columnsInfo) {
        this.isUnique = isUnique;
        this.columnsInfo = columnsInfo;
        this.isSet = true;
    }

    public void setCommonContentViaXml(XmlMap xmlMap) throws JddException {
        try {
            XmlMap index = xmlMap.getXmlMap("index");
            if (!index.isEmpty()) {
                xmlMap = index;
            }
            this.name = xmlMap.getString("name");
            this.name = XmlHelper.checkAndGetName(this.name, "Index");
            this.tableName = xmlMap.getString("tabname");
            this.tableName = XmlHelper.checkAndGetName(this.tableName, "Table");
            this.deploymentInfo = new DbDeploymentInfo(xmlMap, this.factory);
            this.deploymentStatus = DbDeploymentStatus.getInstance(xmlMap.getString("deployment-status"));
            this.isUnique = xmlMap.getBoolean("is-unique");
            XmlMap columns = xmlMap.getXmlMap("columns");
            XmlMap nextColumn = null;
            this.columnsInfo = new ArrayList();
            int i = 0;
            while (!(nextColumn = columns.getXmlMap("column" + (i == 0 ? "" : "" + i))).isEmpty()) {
                this.columnsInfo.add(new DbIndexColumnInfo(nextColumn));
                ++i;
            }
            if (this.columnsInfo.isEmpty()) {
                throw new JddException(ExType.XML_ERROR, DbMsgHandler.get(DbsConstants.RTXML_INDEXCOLS_MISS));
            }
            this.isSet = true;
        }
        catch (Exception ex) {
            throw JddException.createInstance(ex);
        }
    }

    public abstract void setSpecificContentViaXml(XmlMap var1) throws JddException;

    public abstract void setCommonContentViaDb() throws JddException;

    public abstract void setSpecificContentViaDb() throws JddException;

    public void setDbSpecificIsSet(boolean dbSpecificIsSet) {
        this.dbSpecificIsSet = dbSpecificIsSet;
    }

    public DbFactory getDbFactory() {
        return this.factory;
    }

    public String getName() {
        return this.name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public ArrayList getColumnNames() {
        return this.columnsInfo;
    }

    public boolean getDbSpecificIsSet() {
        return this.dbSpecificIsSet;
    }

    public DbIndexes getIndexes() {
        return this.indexes;
    }

    public DbIndex getNext() {
        return this.next;
    }

    public DbIndex getPrevious() {
        return this.previous;
    }

    public DbSchema getSchema() {
        return this.schema;
    }

    public DbDeploymentInfo getDeploymentInfo() {
        return this.deploymentInfo;
    }

    public void setIndexes(DbIndexes indexes) {
        this.indexes = indexes;
    }

    protected void setNext(DbIndex nextIndex) {
        this.next = nextIndex;
    }

    protected void setPrevious(DbIndex previousIndex) {
        this.previous = previousIndex;
    }

    public String toString() {
        String columnsInfoString = "";
        int i = 0;
        while (i < this.columnsInfo.size()) {
            columnsInfoString = columnsInfoString + (DbIndexColumnInfo)this.columnsInfo.get(i);
            ++i;
        }
        return "Index = " + this.name + "\n" + "TableName             : " + this.tableName + "\n" + this.deploymentInfo + this.deploymentStatus + "is Unique             : " + this.isUnique + "\n" + columnsInfoString + "\n";
    }

    public void writeCommonContentToXmlFile(PrintWriter file, String offset0) throws JddException {
        try {
            file.println(offset0 + "<index name=" + "\"" + this.name + "\"" + ">");
            String offset1 = offset0 + XmlHelper.tabulate();
            file.println(offset1 + "<tabname>" + this.tableName + "</tabname>");
            if (this.deploymentInfo != null) {
                this.deploymentInfo.writeContentToXmlFile(file, offset1);
            }
            if (this.deploymentStatus != null) {
                file.println(offset1 + "<deployment-status>" + this.deploymentStatus.getName() + "</deployment-status>");
            }
            file.println(offset1 + "<is-unique>" + this.isUnique + "</is-unique>");
            file.println(offset1 + "<columns>");
            int i = 0;
            while (i < this.columnsInfo.size()) {
                ((DbIndexColumnInfo)this.columnsInfo.get(i)).writeCommonContentToXmlFile(file, offset1 + XmlHelper.tabulate());
                ++i;
            }
            file.println(offset1 + "</columns>");
            file.println(offset0 + "</index>");
        }
        catch (Exception ex) {
            throw JddException.createInstance(ex);
        }
    }

    public DbObjectSqlStatements getDdlStatementsForCreate() {
        DbObjectSqlStatements indexDef = new DbObjectSqlStatements(this.name);
        DbSqlStatement createStatement = new DbSqlStatement();
        String unique = this.isUnique ? "UNIQUE " : "";
        createStatement.addLine("CREATE " + unique + "INDEX" + " " + "\"" + this.name + "\"" + " ON " + "\"" + this.tableName + "\"");
        createStatement.merge(this.getDdlColumnsClause());
        indexDef.add(createStatement);
        return indexDef;
    }

    public DbSqlStatement getDdlColumnsClause() {
        String line = "";
        Iterator iter = ((AbstractList)this.columnsInfo).iterator();
        DbSqlStatement colDef = new DbSqlStatement();
        colDef.addLine("(");
        while (iter.hasNext()) {
            DbIndexColumnInfo dbIndexColumnInfo = (DbIndexColumnInfo)iter.next();
            line = "\"" + dbIndexColumnInfo.getName() + "\"";
            if (iter.hasNext()) {
                line = line + ", ";
            }
            colDef.addLine(line);
        }
        colDef.addLine(")");
        return colDef;
    }

    public DbObjectSqlStatements getDdlStatementsForDrop() {
        DbObjectSqlStatements indexDef = new DbObjectSqlStatements(this.name);
        DbSqlStatement dropStatement = new DbSqlStatement(true);
        dropStatement.addLine("DROP INDEX \"" + this.name + "\"");
        indexDef.add(dropStatement);
        return indexDef;
    }

    public DbIndexDifference compareTo(DbIndex target) throws JddException {
        DbIndexDifference difference = null;
        try {
            if (this.isUnique != target.isUnique) {
                difference = this.factory.makeDbIndexDifference(this, target, Action.DROP_CREATE);
                return difference;
            }
            if (target.columnsInfo.size() != this.columnsInfo.size()) {
                difference = this.factory.makeDbIndexDifference(this, target, Action.DROP_CREATE);
                return difference;
            }
            int i = 0;
            while (i < this.columnsInfo.size()) {
                if (!((DbIndexColumnInfo)this.columnsInfo.get(i)).equals((DbIndexColumnInfo)target.columnsInfo.get(i))) {
                    difference = this.factory.makeDbIndexDifference(this, target, Action.DROP_CREATE);
                }
                ++i;
            }
            return difference;
        }
        catch (Exception ex) {
            throw JddException.createInstance(ex);
        }
    }

    public boolean check() {
        if (this.deploymentInfo.doNotCreate()) {
            return true;
        }
        return this.checkWidth() & this.checkNumberOfColumns() & this.checkNameLength() & this.checkNameForReservedWord();
    }

    public boolean checkWidth() {
        return true;
    }

    public boolean checkNameLength() {
        return true;
    }

    public boolean checkNumberOfColumns() {
        return true;
    }

    public boolean checkNameForReservedWord() {
        return true;
    }
}

