/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db6;

import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndexColumnInfo;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbPrimaryKey;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class DbDb6PrimaryKey
extends DbPrimaryKey {
    private String indName = null;
    private static Location loc = Logger.getLocation("db6.DbDb6PrimaryKey");

    public DbDb6PrimaryKey() {
    }

    public DbDb6PrimaryKey(DbFactory factory, DbPrimaryKey other) {
        super(factory, other);
    }

    public DbDb6PrimaryKey(DbFactory factory) {
        super(factory);
    }

    public DbDb6PrimaryKey(DbFactory factory, DbSchema schema, String tableName) {
        super(factory, schema, tableName);
    }

    public DbDb6PrimaryKey(DbFactory factory, String tableName) {
        super(factory, tableName);
    }

    public void setSpecificContentViaXml(XmlMap xmlMap) throws JddException {
    }

    public void setCommonContentViaDb() throws JddException {
        loc.entering("setCommonContentViaDb");
        Connection con = this.getDbFactory().getConnection();
        boolean isDescending = false;
        int startIndex = 0;
        int endIndex = 0;
        ArrayList<DbIndexColumnInfo> columnsInfo = new ArrayList<DbIndexColumnInfo>();
        try {
            String schemaName = "CURRENT SCHEMA";
            PreparedStatement ps = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)("SELECT INDNAME, COLNAMES, USER_DEFINED FROM SYSCAT.INDEXES WHERE TABSCHEMA = " + schemaName + " AND TABNAME = ? AND UNIQUERULE = 'P' "));
            ps.setString(1, this.getTableName().toUpperCase());
            ResultSet rset = ps.executeQuery();
            if (rset.next()) {
                if (rset.getInt(3) == 1) {
                    this.indName = rset.getString(1);
                }
                String colnames = rset.getString(2);
                int ii = 0;
                while (ii < colnames.length()) {
                    if (colnames.charAt(ii) == '-' || colnames.charAt(ii) == '+') {
                        if (ii > 0) {
                            endIndex = ii;
                            columnsInfo.add(new DbIndexColumnInfo(colnames.substring(startIndex, endIndex), isDescending));
                        }
                        isDescending = colnames.charAt(ii) == '-';
                        startIndex = ii + 1;
                    } else if (ii == colnames.length() - 1) {
                        endIndex = ii + 1;
                        columnsInfo.add(new DbIndexColumnInfo(colnames.substring(startIndex, endIndex), isDescending));
                    }
                    ++ii;
                }
            }
            rset.close();
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setCommonContentViaDb failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        this.setContent(columnsInfo);
        loc.exiting();
    }

    public void setSpecificContentViaDb() throws JddException {
    }

    public void writeSpecificContentToXmlFile(PrintWriter file, String offset0) {
    }

    public DbObjectSqlStatements getDdlStatementsForCreate() {
        DbObjectSqlStatements pkDef = new DbObjectSqlStatements("PK/CREATE/" + this.getTableName());
        DbSqlStatement createStatement = new DbSqlStatement();
        String tabName = this.getTableName();
        createStatement.addLine("ALTER TABLE \"" + tabName.toUpperCase() + '\"' + " ADD PRIMARY KEY");
        createStatement.merge(this.getDdlColumnsClause());
        pkDef.add(createStatement);
        return pkDef;
    }

    public DbObjectSqlStatements getDdlStatementsForDrop() {
        DbObjectSqlStatements pkDrop = new DbObjectSqlStatements("PK/DROP/" + this.getTableName());
        DbSqlStatement dropStatement = new DbSqlStatement(true);
        String tabName = this.getTableName();
        dropStatement.addLine("ALTER TABLE \"" + tabName.toUpperCase() + '\"' + " DROP PRIMARY KEY");
        pkDrop.add(dropStatement);
        if (this.indName != null) {
            DbSqlStatement indexStatement = new DbSqlStatement(true);
            String indName = this.indName;
            indexStatement.addLine("DROP INDEX \"" + indName.toUpperCase() + '\"');
            pkDrop.add(indexStatement);
        }
        return pkDrop;
    }

    public boolean checkWidth() {
        Object[] arguments;
        loc.entering("checkWidth");
        Iterator iter = ((AbstractList)this.getColumnNames()).iterator();
        String colName = null;
        DbColumns columns = this.getTable().getColumns();
        boolean check = true;
        int total = 0;
        while (iter.hasNext()) {
            colName = ((DbIndexColumnInfo)iter.next()).getName();
            DbColumn column = columns.getColumn(colName);
            if (column == null) {
                arguments = new Object[]{this.getTableName(), colName};
                loc.errorT("checkWidth for primary key on table {0}: no column named {1}.", arguments);
                check = false;
                continue;
            }
            switch (column.getJavaSqlType()) {
                case 2004: 
                case 2005: {
                    arguments = new Object[]{this.getTableName(), colName};
                    loc.errorT("checkWidth for primary key on table {0}: column type for column {1} is not allowed in an index.", arguments);
                    check = false;
                    break;
                }
                case -5: {
                    total += 10;
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    total = (int)((long)total + (column.getLength() + 2L));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    total = (int)((long)total + (column.getLength() * 3L + 2L));
                    break;
                }
                case 91: {
                    total += 6;
                    break;
                }
                case 92: {
                    total += 5;
                    break;
                }
                case 93: {
                    total += 12;
                    break;
                }
                case 2: 
                case 3: {
                    total = (int)((long)total + (column.getLength() / 2L + 3L));
                    break;
                }
                case 6: 
                case 8: {
                    total += 10;
                    break;
                }
                case 7: {
                    total += 6;
                    break;
                }
                case 4: {
                    total += 6;
                    break;
                }
                case -6: 
                case 5: {
                    total += 4;
                }
            }
        }
        if ((total += 2) >= 1024) {
            check = false;
            arguments = new Object[]{this.getTableName(), new Integer(total)};
            loc.errorT("checkWidth for primary key on table {0}: total width of all columns in primary key ({1}) including row overhead is greater than the allowed maximum (1023 byte) .", arguments);
        }
        loc.exiting();
        return check;
    }

    public boolean checkNumberOfColumns() {
        int numCols = this.getColumnNames().size();
        boolean check = numCols > 0 && numCols <= 16;
        loc.entering("checkNumberOfColumns");
        if (!check) {
            Object[] arguments = new Object[]{this.getTableName()};
            loc.errorT("checkNumberOfColumns for primary key on table {0}: only 16 primary key columns are allowed.");
        }
        loc.exiting();
        return check;
    }

    public boolean checkColumnsNotNull() {
        loc.entering("checkColumnsNotNull");
        Iterator iter = ((AbstractList)this.getColumnNames()).iterator();
        String colName = null;
        DbColumns columns = this.getTable().getColumns();
        boolean check = true;
        while (iter.hasNext()) {
            colName = ((DbIndexColumnInfo)iter.next()).getName();
            DbColumn column = columns.getColumn(colName);
            if (column != null && column.isNotNull()) continue;
            check = false;
            Object[] arguments = new Object[]{this.getTableName(), colName};
            loc.errorT("checkColumnsNotNull for primary key on table {0}: column {1} must not be nullable", arguments);
        }
        loc.exiting();
        return check;
    }
}

