/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db4;

import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnDifference;
import com.sap.dictionary.database.dbs.DbColumnDifferencePlan;
import com.sap.dictionary.database.dbs.DbColumnsDifference;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;

public class DbDb4ColumnsDifference
extends DbColumnsDifference {
    private static Location loc = Logger.getLocation("db4.DbDb4ColumnsDifference");
    private static Category cat = Logger.getCategory();

    public DbObjectSqlStatements getDdlStatementsForAlter(String tableName) throws Exception {
        loc.entering(cat, "getDdlStatementsForAlter({0})", new Object[]{tableName});
        DbObjectSqlStatements stmts = new DbObjectSqlStatements(tableName);
        DbColumnsDifference.MultiIterator multiIter = this.iterator();
        DbSqlStatement alterStmt = new DbSqlStatement();
        String action = "";
        try {
            if (!multiIter.hasNext()) {
                loc.debugT(cat, "Table {0} did not change.", new Object[]{tableName});
                loc.exiting();
                return null;
            }
            loc.debugT(cat, "'ALTER TABLE...'");
            alterStmt.addLine("ALTER TABLE \"" + tableName.trim().toUpperCase() + "\" ");
            while (multiIter.hasNext()) {
                DbColumnDifference diff = multiIter.next();
                if (!diff.getAction().equals(Action.ALTER)) {
                    loc.errorT(cat, "Action 'ALTER' expected. DbColumnDifference: {0}", new Object[]{diff});
                    loc.exiting();
                    throw new JddException(ExType.OTHER, "Action 'ALTER' expected. Got " + diff.getAction() + ".");
                }
                DbColumnDifferencePlan plan = diff.getDifferencePlan();
                boolean addOrDrop = false;
                if (plan != null) {
                    if (!plan.somethingIsChanged()) {
                        addOrDrop = true;
                    } else {
                        String typeLenDecClause = "ALTER COLUMN \"" + diff.getTarget().getName().trim().toUpperCase() + "\" ";
                        if (plan.typeLenDecIsChanged()) {
                            typeLenDecClause = typeLenDecClause + this.getTypeLenDecClause(diff.getTarget());
                        }
                        if (plan.nullabilityIsChanged()) {
                            typeLenDecClause = typeLenDecClause + this.getNullabilityClause(diff.getTarget());
                        }
                        if (plan.defaultValueIsChanged()) {
                            typeLenDecClause = typeLenDecClause + this.getDefValClause(diff.getTarget());
                        }
                        alterStmt.addLine(typeLenDecClause);
                    }
                }
                if (plan != null && !addOrDrop) continue;
                String addDropClause = "";
                String string = addDropClause = diff.getOrigin() == null ? this.getAddClause(diff.getTarget()) : this.getDropClause(diff.getOrigin());
                if (addDropClause.equals("")) {
                    loc.warningT(cat, "DbColumnDifference without change: {0}", new Object[]{diff.toString()});
                    continue;
                }
                alterStmt.addLine(addDropClause);
            }
        }
        catch (Exception e) {
            loc.errorT(cat, "Exception caught generating ALTER statement: {0}.", new Object[]{e.getMessage()});
            loc.exiting();
            throw JddException.createInstance(e);
        }
        stmts.add(alterStmt);
        loc.debugT(cat, "Generated: {0}", new Object[]{alterStmt});
        loc.exiting();
        return stmts;
    }

    private String getAddClause(DbColumn col) throws Exception {
        loc.debugT(cat, "'...ADD COLUMN...'");
        return "ADD COLUMN " + col.getDdlClause() + " ";
    }

    private String getDropClause(DbColumn col) throws Exception {
        loc.debugT(cat, "'...DROP COLUMN...'");
        return "DROP COLUMN \"" + col.getName().trim().toUpperCase() + "\" " + "CASCADE ";
    }

    private String getTypeLenDecClause(DbColumn target) throws Exception {
        loc.debugT(cat, "'...SET DATA TYPE...'");
        return "SET DATA TYPE " + target.getDdlTypeClause() + " ";
    }

    private String getNullabilityClause(DbColumn target) throws Exception {
        if (target.isNotNull()) {
            loc.debugT(cat, "'...SET NOT NULL...'");
            return "SET NOT NULL ";
        }
        loc.debugT(cat, "'...DROP NOT NULL...'");
        return "DROP NOT NULL ";
    }

    private String getDefValClause(DbColumn target) throws Exception {
        if (target.getJavaSqlTypeInfo().hasDefaultValue()) {
            loc.debugT(cat, "'...SET [DEFAULT]..'");
            return "SET " + target.getDdlDefaultValueClause() + " ";
        }
        loc.debugT(cat, "'...DROP DEFAULT..'");
        return "DROP DEFAULT ";
    }
}

