/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db4;

import com.sap.dictionary.database.db4.DbDb4Column;
import com.sap.dictionary.database.db4.DbDb4Environment;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class DbDb4Columns
extends DbColumns {
    private static Location loc = Logger.getLocation("db4.DbDb4Columns");
    private static Category cat = Logger.getCategory();

    public DbDb4Columns(DbFactory factory) {
        super(factory);
    }

    public DbDb4Columns(DbFactory factory, DbColumns other) {
        super(factory, other);
    }

    public DbDb4Columns(DbFactory factory, XmlMap xmlMap) throws Exception {
        super(factory, xmlMap);
    }

    /*
     * Loose catch block
     */
    public void setContentViaDb(DbFactory factory) throws JddException {
        block12: {
            String stmt;
            ResultSet rs;
            PreparedStatement ps;
            block11: {
                loc.entering(cat, "setContentViaDb(DbFactory)");
                Connection con = null;
                ps = null;
                rs = null;
                String tableName = null;
                stmt = "SELECT T2.COLUMN_NAME, T2.DATA_TYPE, T2.LENGTH, T2.NUMERIC_SCALE, T2.COLUMN_DEFAULT, T2.ORDINAL_POSITION, T2.IS_NULLABLE, T2.CCSID FROM SYSTABLES AS T1 JOIN SYSCOLUMNS AS T2 ON T1.TABLE_NAME = T2.TABLE_NAME WHERE T1.TABLE_NAME = ? AND T1.TABLE_TYPE = 'T' ORDER BY T2.ORDINAL_POSITION";
                if (this.getColumnCnt() > 0) {
                    loc.warningT(cat, "Columns are already set. - Return.");
                    loc.exiting();
                    return;
                }
                if (this.getTable() == null || (tableName = this.getTable().getName()) == null) {
                    loc.errorT(cat, "Empty table name.");
                    loc.exiting();
                    throw new JddException(ExType.OTHER, "Empty table name.");
                }
                tableName = tableName.trim().toUpperCase();
                if (factory == null || (con = factory.getConnection()) == null) {
                    loc.errorT(cat, "No connection.");
                    loc.exiting();
                    throw new JddException(ExType.OTHER, "No connection.");
                }
                ps = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmt);
                ps.setString(1, tableName);
                rs = ps.executeQuery();
                int numberOfColumns = 0;
                while (rs.next()) {
                    String colName = rs.getString(1).trim().toUpperCase();
                    String dbType = rs.getString(2).trim().toUpperCase();
                    int colSize = rs.getInt(3);
                    int decDigits = rs.getInt(4);
                    String defVal = rs.getString(5);
                    int pos = rs.getInt(6);
                    boolean isNotNull = rs.getString(7).trim().equalsIgnoreCase("N");
                    int ccsid = rs.getInt(8);
                    int sqlType = DbDb4Environment.mapToSqlType(dbType, colSize, ccsid);
                    defVal = DbDb4Environment.mapToJddicDefaultValue(defVal, sqlType);
                    DbDb4Column col = new DbDb4Column(factory, colName, pos, sqlType, dbType, colSize, decDigits, isNotNull, defVal);
                    this.add(col);
                    ++numberOfColumns;
                }
                if (numberOfColumns != 0) break block11;
                loc.warningT(cat, "Table {0} does not exist on database.", new Object[]{tableName});
            }
            Object var19_19 = null;
            try {
                rs.close();
                ps.close();
            }
            catch (Exception e) {
                loc.warningT(cat, "Exception caught closing statement resources:\n {0}", new Object[]{e.getMessage()});
            }
            break block12;
            {
                catch (Exception e) {
                    loc.errorT(cat, "Exception caught executing {0}\n: {1}", new Object[]{stmt, e.getMessage()});
                    loc.exiting();
                    throw JddException.createInstance(e);
                }
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                try {
                    rs.close();
                    ps.close();
                }
                catch (Exception e) {
                    loc.warningT(cat, "Exception caught closing statement resources:\n {0}", new Object[]{e.getMessage()});
                }
                throw throwable;
            }
        }
        loc.exiting();
    }

    public boolean checkNumber() {
        boolean numberOk = this.getColumnCnt() <= DbDb4Environment.getMaxColumnsPerTable();
        DbDb4Environment.traceCheckResult(true, numberOk, cat, loc, "checkNumber() returns {0}.", new Object[]{new Boolean(numberOk)});
        return numberOk;
    }
}

