/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db2;

import com.sap.dictionary.database.db2.DbDb2Environment;
import com.sap.dictionary.database.db2.DbDb2IdxAttr;
import com.sap.dictionary.database.db2.DbDb2Parameters;
import com.sap.dictionary.database.db2.DbDb2PartAttr;
import com.sap.dictionary.database.db2.DbDb2SqlStatement;
import com.sap.dictionary.database.db2.DbDb2Stogroup;
import com.sap.dictionary.database.db2.DbDb2Table;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnIterator;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbIndex;
import com.sap.dictionary.database.dbs.DbIndexColumnInfo;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbSchema;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.dictionary.database.dbs.XmlHelper;
import com.sap.dictionary.database.dbs.XmlMap;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class DbDb2Index
extends DbIndex {
    private DbDb2IdxAttr idxAttr;
    private Integer tabSizeCat;
    private Integer sizeCat;
    String schema;
    private boolean forPrimaryKey = false;
    private static Location loc = Logger.getLocation("db2.DbDb2Index");

    public DbDb2Index(DbFactory factory) {
        super(factory);
        this.setSchema(factory);
        this.setDefaultPartition();
        DbDb2Parameters.setValues(factory.getConnection());
    }

    public DbDb2Index(DbFactory factory, DbIndex other) {
        super(factory, other);
        this.setSchema(factory);
        this.setDefaultPartition();
        DbDb2Parameters.setValues(factory.getConnection());
    }

    public DbDb2Index(DbFactory factory, DbSchema schema, String tabname, String name) {
        super(factory, schema, tabname, name);
        this.setSchema(factory);
        this.setDefaultPartition();
        DbDb2Parameters.setValues(factory.getConnection());
    }

    public DbDb2Index(DbFactory factory, String tabname, String name) {
        super(factory, tabname, name);
        this.setSchema(factory);
        this.setDefaultPartition();
        DbDb2Parameters.setValues(factory.getConnection());
    }

    private void setDefaultPartition() {
        if (this.idxAttr == null) {
            this.idxAttr = new DbDb2IdxAttr();
            try {
                this.idxAttr.setPart();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public DbObjectSqlStatements getDdlStatementsForCreate() {
        loc.entering("getDdlStatementsForCreate");
        DbDb2PartAttr partAttr = this.idxAttr.getPart();
        if (partAttr == null) {
            // empty if block
        }
        String name = this.getName();
        String tableName = ((DbDb2Table)this.getIndexes().getTable()).getDbTableName();
        boolean isUnique = this.isUnique();
        DbObjectSqlStatements indexDef = new DbObjectSqlStatements(name);
        DbDb2SqlStatement createStatement = new DbDb2SqlStatement();
        DbFactory factory = this.getDbFactory();
        this.setSchema(factory);
        Connection con = factory.getConnection();
        String SapjStogroup = DbDb2Stogroup.getStogroup(con);
        String unique = isUnique ? "UNIQUE " : "";
        createStatement.addLine(" CREATE ");
        createStatement.addLine(unique + " INDEX ");
        createStatement.addLine(DbDb2Environment.quote(name));
        createStatement.addLine(" ON " + DbDb2Environment.quote(tableName) + " ");
        createStatement.merge(this.getDdlColumnsClause());
        if (DbDb2Parameters.isV8()) {
            createStatement.addLine(" NOT PADDED ");
        }
        createStatement.addLine(" USING STOGROUP " + SapjStogroup);
        if (DbDb2Parameters.isV7()) {
            createStatement.addLine(" PRIQTY " + partAttr.getPriQty());
            createStatement.addLine(" SECQTY " + partAttr.getSecQty());
        }
        createStatement.addLine(" FREEPAGE " + partAttr.getFreePage());
        createStatement.addLine(" PCTFREE " + partAttr.getPctFree());
        createStatement.addLine(" GBPCACHE " + partAttr.getGbpCache());
        createStatement.addLine(" DEFINE " + this.idxAttr.getDefine());
        if (0 == this.idxAttr.getClustering().compareToIgnoreCase("YES")) {
            createStatement.addLine(" CLUSTER ");
        }
        createStatement.addLine(" BUFFERPOOL " + this.idxAttr.getBufferPool());
        createStatement.addLine(" CLOSE " + this.idxAttr.getClose());
        createStatement.addLine(" DEFER " + this.idxAttr.getDefer());
        createStatement.addLine(" COPY " + this.idxAttr.getCopy());
        if (this.idxAttr.getPartitioned() == null) {
            createStatement.addLine(" PIECESIZE " + this.idxAttr.getPieceSize());
        }
        if (this.idxAttr.getPartitioned() != null) {
            createStatement.addLine(" " + this.idxAttr.getPartitioned() + " ");
        }
        indexDef.add(createStatement);
        loc.exiting();
        return indexDef;
    }

    public DbDb2IdxAttr getIdxAttr() {
        return this.idxAttr;
    }

    public DbSqlStatement getDdlColumnsClause() {
        loc.entering("getDdlColumnsClause");
        String line = "";
        Iterator iter = ((AbstractList)this.getColumnNames()).iterator();
        DbSqlStatement colDef = new DbSqlStatement();
        colDef.addLine("(");
        while (iter.hasNext()) {
            DbIndexColumnInfo dbIndexColumnInfo = (DbIndexColumnInfo)iter.next();
            line = DbDb2Environment.quote(dbIndexColumnInfo.getName());
            String idxorder = "";
            idxorder = dbIndexColumnInfo.isDescending() ? "DESC" : "ASC";
            line = line + " " + idxorder;
            if (iter.hasNext()) {
                line = line + ", ";
            }
            colDef.addLine(line);
        }
        colDef.addLine(")");
        loc.exiting();
        return colDef;
    }

    public void writeSpecificContentToXmlFile(PrintWriter file, String offset0) throws JddException {
        loc.entering("writeSpecificContentToXmlFile");
        try {
            if (this.forPrimaryKey) {
                file.println(offset0 + "<primary-key>");
            } else {
                file.println(offset0 + "<index name=" + "\"" + this.getName() + "\">");
            }
            DbDb2PartAttr partAttr = this.idxAttr.getPart();
            if (partAttr == null) {
                // empty if block
            }
            String offset1 = offset0 + XmlHelper.tabulate();
            String offset2 = offset1 + XmlHelper.tabulate();
            file.println(offset1 + "<priqty>" + partAttr.getPriQty() + "</priqty>");
            file.println(offset1 + "<secqty>" + partAttr.getSecQty() + "</secqty>");
            file.println(offset1 + "<pctfree>" + partAttr.getPctFree() + "</pctfree>");
            file.println(offset1 + "<bufferpool>" + this.idxAttr.getBufferPool() + "</bufferpool>");
            file.println(offset1 + "<freepage>" + partAttr.getFreePage() + "</freepage>");
            file.println(offset1 + "<close>" + this.idxAttr.getClose() + "</close>");
            file.println(offset1 + "<define>" + this.idxAttr.getDefine() + "</define>");
            file.println(offset1 + "<gbpcache>" + partAttr.getGbpCache() + "</gbpcache>");
            file.println(offset1 + "<clustering>" + this.idxAttr.getClustering() + "</clustering>");
            file.println(offset1 + "<defer>" + this.idxAttr.getDefer() + "</defer>");
            file.println(offset1 + "<piecesize>" + this.idxAttr.getPieceSize() + "</piecesize>");
            file.println(offset1 + "<copy>" + this.idxAttr.getCopy() + "</copy>");
            if (this.forPrimaryKey) {
                file.println(offset0 + "</primary-key>");
            } else {
                file.println(offset0 + "</index>");
            }
            loc.exiting();
            return;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("writeSpecificContentToXmlFile failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public void setSpecificContentViaXml(XmlMap xmlMap) throws JddException {
        loc.entering("setSpecificContentViaXml");
        try {
            if (this.idxAttr == null) {
                this.idxAttr = new DbDb2IdxAttr();
            }
            DbDb2PartAttr partAttr = this.idxAttr.setPart();
            partAttr.setPriQty(xmlMap.getIntegerObject("priqty"));
            partAttr.setSecQty(xmlMap.getIntegerObject("secqty"));
            partAttr.setPctFree(xmlMap.getIntegerObject("pctfree"));
            partAttr.setFreePage(xmlMap.getIntegerObject("freepage"));
            partAttr.setGbpCache(xmlMap.getString("gbpcache"));
            this.idxAttr.setBufferPool(xmlMap.getString("bufferpool"));
            this.idxAttr.setDefer(xmlMap.getString("defer"));
            this.idxAttr.setClose(xmlMap.getString("close"));
            this.idxAttr.setDefine(xmlMap.getString("define"));
            this.idxAttr.setPieceSize(xmlMap.getString("piecesize"));
            this.idxAttr.setClustering(xmlMap.getString("clustering"));
            this.idxAttr.setCopy(xmlMap.getString("copy"));
            this.idxAttr.setPartitioned(xmlMap.getString("partitioned"));
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setSpecificContentViaXml failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public void setCommonContentViaDb() throws JddException {
        loc.entering("setCommonContentViaDb");
        String stmtTxt = null;
        try {
            String tabname = ((DbDb2Table)this.getIndexes().getTable()).getDbTableName();
            String indname = this.getName();
            boolean isUnique = false;
            boolean isDescending = false;
            ArrayList<DbIndexColumnInfo> columnsInfo = new ArrayList<DbIndexColumnInfo>();
            DbFactory factory = this.getDbFactory();
            Connection conn = factory.getConnection();
            stmtTxt = "SELECT UNIQUERULE FROM SYSIBM.SYSINDEXES WHERE NAME = ? AND TBNAME = ? AND CREATOR = ? AND TBCREATOR = ? ";
            PreparedStatement ps = NativeSQLAccess.prepareNativeStatement((Connection)conn, (String)stmtTxt);
            ps.setString(1, indname);
            ps.setString(2, tabname);
            ps.setString(3, this.schema);
            ps.setString(4, this.schema);
            ResultSet rset = ps.executeQuery();
            if (rset.next()) {
                isUnique = !rset.getString(1).equals("D");
            }
            rset.close();
            stmtTxt = "SELECT COLNAME, ORDERING FROM SYSIBM.SYSKEYS WHERE IXNAME = ? AND IXCREATOR = ? ORDER BY COLSEQ";
            ps = NativeSQLAccess.prepareNativeStatement((Connection)conn, (String)stmtTxt);
            ps.setString(1, indname);
            ps.setString(2, this.schema);
            rset = ps.executeQuery();
            while (rset.next()) {
                isDescending = rset.getString(2).equals("D");
                DbIndexColumnInfo indexColumnInfo = new DbIndexColumnInfo(rset.getString(1), isDescending);
                columnsInfo.add(indexColumnInfo);
            }
            rset.close();
            ps.close();
            this.setContent(isUnique, columnsInfo);
            loc.exiting();
            return;
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{DbDb2Environment.getSQLError(ex, stmtTxt)};
            loc.errorT("setCommonContentViaDb failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setCommonContentViaDb failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public void setSpecificContentViaRef(DbDb2Index other) {
        loc.entering("copySpecificContent()");
        this.idxAttr = new DbDb2IdxAttr();
        DbDb2PartAttr partAttr = this.idxAttr.setPart();
        DbDb2IdxAttr otherIdxAttr = other.getIdxAttr();
        DbDb2PartAttr otherPartAttr = otherIdxAttr.getPart();
        partAttr.setPriQty(new Integer(otherPartAttr.getPriQty()));
        partAttr.setSecQty(new Integer(otherPartAttr.getSecQty()));
        partAttr.setFreePage(new Integer(otherPartAttr.getFreePage()));
        partAttr.setPctFree(new Integer(otherPartAttr.getPctFree()));
        partAttr.setGbpCache(new String(otherPartAttr.getGbpCache()));
        this.idxAttr.setDefine(new String(otherIdxAttr.getDefine()));
        this.idxAttr.setClustering(new String(otherIdxAttr.getClustering()));
        this.idxAttr.setDefer(new String(otherIdxAttr.getDefer()));
        this.idxAttr.setPieceSize(new String(otherIdxAttr.getPieceSize()));
        this.idxAttr.setCopy(new String(otherIdxAttr.getCopy()));
        this.idxAttr.setBufferPool(new String(otherIdxAttr.getBufferPool()));
        this.idxAttr.setClose(new String(otherIdxAttr.getClose()));
        this.sizeCat = other.sizeCat;
        loc.exiting();
    }

    public void setSpecificContentViaDb() throws JddException {
        loc.entering("setSpecificContentViaDb");
        String stmtTxt = null;
        try {
            String indname = this.getName();
            DbFactory factory = this.getDbFactory();
            Connection conn = factory.getConnection();
            stmtTxt = " SELECT B.PQTY,  case when B.secqtyi = 0 then B.sqty else B.secqtyi end,  B.FREEPAGE, B.PCTFREE,  case when B.GBPCACHE = 'A' then 'ALL'       when B.GBPCACHE = 'N' then 'NONE'       when B.GBPCACHE = 'S' then 'SYSTEM'       else 'CHANGED' end,  case when B.space = -1 then 'NO' else 'YES' end,  case when A.CLUSTERING = 'Y' then 'YES' else 'NO' end,  A.PIECESIZE ,  case when A.COPY = 'Y' then 'YES' else 'NO' end,  A.BPOOL ,  case when A.CLOSERULE = 'Y' then 'YES' else 'NO' end  FROM SYSIBM.SYSINDEXES A, SYSIBM.SYSINDEXPART B  WHERE A.NAME = ?  AND A.NAME =  B.IXNAME  AND A.CREATOR =  ?  AND B.IXCREATOR =  ?  FETCH FIRST ROW ONLY OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR";
            PreparedStatement stmt = NativeSQLAccess.prepareNativeStatement((Connection)conn, (String)stmtTxt);
            stmt.setString(1, indname);
            stmt.setString(2, this.schema);
            stmt.setString(3, this.schema);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                this.idxAttr = new DbDb2IdxAttr();
                DbDb2PartAttr partAttr = this.idxAttr.setPart();
                partAttr.setPriQty(new Integer(4 * rs.getInt(1)));
                partAttr.setSecQty(new Integer(4 * rs.getInt(2)));
                partAttr.setFreePage(new Integer(rs.getInt(4)));
                partAttr.setPctFree(new Integer(rs.getInt(4)));
                partAttr.setGbpCache(rs.getString(5).trim());
                this.idxAttr.setDefine(rs.getString(6).trim());
                this.idxAttr.setClustering(rs.getString(7).trim());
                this.idxAttr.setDefer("NO");
                int pieceSize = rs.getInt(8);
                this.idxAttr.setPieceSize("" + pieceSize + " K");
                this.idxAttr.setCopy(rs.getString(9).trim());
                this.idxAttr.setBufferPool(rs.getString(10).trim());
                this.idxAttr.setClose(rs.getString(11).trim());
                this.sizeCat = new Integer(this.SizeCategoryfromSecQty(partAttr.getSecQty()));
            } else {
                Object[] arguments = new Object[]{this.getName()};
                loc.errorT("Index {0} not found in catalog", arguments);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{DbDb2Environment.getSQLError(ex, stmtTxt)};
            loc.errorT("setSpecificContentViaDb: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("setSpecificContentViaDb: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public void setTabSizecat(int sizecat) {
        this.tabSizeCat = new Integer(sizecat);
    }

    int secSizeforSizeCategory(int sizeCategory) {
        switch (sizeCategory) {
            case 0: {
                return 40;
            }
            case 1: {
                return 160;
            }
            case 2: {
                return 640;
            }
            case 3: {
                return 2540;
            }
            case 4: {
                return 10240;
            }
            case 5: {
                return 20480;
            }
            case 6: {
                return 40960;
            }
            case 7: {
                return 81920;
            }
            case 8: {
                return 163840;
            }
        }
        return 327680;
    }

    public void setForPrimaryKey() {
        this.forPrimaryKey = true;
    }

    public boolean getForPrimaryKey() {
        return this.forPrimaryKey;
    }

    public boolean checkWidth() {
        loc.entering("checkWidth()");
        boolean check = true;
        Iterator iter = ((AbstractList)this.getColumnNames()).iterator();
        DbColumns columns = this.getIndexes().getTable().getColumns();
        String tabname = this.getIndexes().getTable().getName();
        int maxIndexWidth = DbDb2Parameters.maxIndexWidth;
        int rowLength = 0;
        if (DbDb2Environment.checkIndexException(tabname, this.getName())) {
            maxIndexWidth = 2000;
        }
        while (iter.hasNext()) {
            String colName = ((DbIndexColumnInfo)iter.next()).getName();
            DbColumn column = columns.getColumn(colName);
            if (column == null) {
                check = false;
                Object[] arguments = new Object[]{this.getName(), colName};
                loc.errorT("checkWidth {0}: no such column in table ( {1} ).", arguments);
                continue;
            }
            if (DbDb2Environment.isLob(column)) {
                check = false;
                Object[] arguments = new Object[]{this.getName(), colName};
                loc.errorT("checkWidth {0}: column of type LOB ({1}) not allowed in index", arguments);
                continue;
            }
            int l = DbDb2Environment.getByteLengthIndex(column);
            if (null != DbDb2Environment.checkUtf8FieldException(tabname, column.getName())) {
                l /= 2;
            }
            rowLength += l;
            if (column.isNotNull()) continue;
            ++rowLength;
        }
        if (rowLength > maxIndexWidth) {
            check = false;
            Object[] arguments = new Object[]{this.getName(), new Integer(rowLength), new Integer(maxIndexWidth)};
            loc.errorT("checkWidth {0}: total width of index ({1} bytes) greater than allowed maximum ({2} bytes)", arguments);
        }
        loc.exiting();
        return check;
    }

    public boolean checkNameLength() {
        loc.entering("checkNameLength()");
        String indexName = this.getName();
        boolean check = true;
        int length = indexName.length();
        if (length < 1 || length > DbDb2Parameters.maxIndexNameLen) {
            check = false;
            Object[] arguments = new Object[]{indexName, new Integer(length), new Integer(DbDb2Parameters.maxIndexNameLen)};
            loc.errorT("checkNameLength {0}: length of index name ({1}) not in allowed range [1,{2}]", arguments);
        }
        loc.exiting();
        return check;
    }

    public boolean checkNumberOfColumns() {
        loc.entering("checkNumberOfColumns()");
        boolean check = true;
        DbColumns columns = this.getIndexes().getTable().getColumns();
        DbColumnIterator iterator = columns.iterator();
        int colCount = 0;
        while (iterator.hasNext()) {
            ++colCount;
            iterator.next();
        }
        if (colCount > DbDb2Parameters.maxIndexColumns) {
            check = false;
            Object[] arguments = new Object[]{this.getName(), new Integer(colCount), new Integer(DbDb2Parameters.maxIndexColumns)};
            loc.errorT("checkNumberOfColumns {0}: number of index-columns ({1}) greater than allowed maximum ({2})", arguments);
        }
        this.setDbSpecificIsSet(true);
        loc.exiting();
        return check;
    }

    public boolean checkNameForReservedWord() {
        boolean check;
        loc.entering("checkNameForReservedWord");
        boolean bl = check = !DbDb2Environment.isReservedWord(this.getName());
        if (!check) {
            Object[] arguments = new Object[]{this.getName()};
            loc.errorT("checkNameForReservedWord {0}: reserved", arguments);
        }
        loc.exiting();
        return check;
    }

    private void setSchema(DbFactory factory) {
        String schema = null;
        DbSchema dbschema = this.getSchema();
        if (dbschema != null) {
            schema = dbschema.getSchemaName();
        }
        if (schema == null) {
            Connection con = factory.getConnection();
            this.schema = DbDb2Environment.getSchema(con);
        } else {
            this.schema = schema;
        }
    }

    public boolean isClustering() {
        return null != this.idxAttr.getClustering() && 0 == this.idxAttr.getClustering().compareToIgnoreCase("YES");
    }

    private int SizeCategoryfromSecQty(int qty) {
        if (qty <= 40) {
            return 0;
        }
        if (qty > 40 && qty <= 160) {
            return 1;
        }
        if (qty > 160 && qty <= 640) {
            return 2;
        }
        if (qty > 640 && qty <= 2560) {
            return 3;
        }
        if (qty > 2560 && qty <= 10240) {
            return 4;
        }
        if (qty > 10240 && qty <= 20480) {
            return 5;
        }
        if (qty > 20480 && qty <= 40960) {
            return 6;
        }
        if (qty > 40960 && qty <= 81920) {
            return 7;
        }
        if (qty > 81920 && qty <= 163840) {
            return 8;
        }
        return 9;
    }
}

