/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db2;

import com.sap.dictionary.database.db2.DbDb2Column;
import com.sap.dictionary.database.db2.DbDb2Parameters;
import com.sap.dictionary.database.db2.DbDb2SqlStatement;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnIterator;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbEnvironment;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.sql.NativeSQLAccess;
import com.sap.tc.logging.Location;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;

public class DbDb2Environment
extends DbEnvironment {
    public static final String fetch_first_row = " FETCH FIRST ROW ONLY";
    public static final String optimize_for_one_row = " OPTIMIZE FOR 1 ROW";
    public static final String fetch_only_with_ur = " FOR FETCH ONLY WITH UR";
    public static final String ccsid = " UNICODE ";
    private static final int db2ErrDefaultVargraphic = -574;
    private static final int db2ErrUndefinedName = -204;
    private static ArrayList reservedWords = null;
    private static Hashtable connections = new Hashtable();
    private static Properties defaultProperties;
    private static final String defaultFileName = "db2.properties";
    private static final String localFileName = "db2local.properties";
    private static Hashtable utf8FieldExceptions;
    private static Hashtable utf16FieldExceptions;
    private static Hashtable indexExceptions;
    private static boolean exceptionListSet;
    private static Location loc;
    private static Boolean tstsys;
    private static Boolean v8HasCharDefault;
    static /* synthetic */ Class class$com$sap$dictionary$database$db2$DbDb2Environment;

    public DbDb2Environment() {
    }

    public DbDb2Environment(Connection con) {
    }

    public static String getSchema(Connection con) {
        loc.entering("getSchema");
        try {
            if (con == null) {
                loc.exiting();
                return null;
            }
            if (connections.containsKey(con)) {
                loc.exiting();
                return (String)connections.get(con);
            }
            String schema = null;
            if (schema == null) {
                PreparedStatement pstmt1 = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)"SELECT CURRENT SQLID FROM SYSIBM.SYSDUMMY1");
                ResultSet rs = pstmt1.executeQuery();
                if (rs.next()) {
                    schema = rs.getString(1).trim();
                }
                rs.close();
                pstmt1.close();
            }
            connections.put(con, schema);
            loc.exiting();
            return schema;
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{DbDb2Environment.getSQLError(ex)};
            loc.errorT("getSchema failed: {0}", arguments);
            loc.exiting();
            return null;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getSchema failed: {0}", arguments);
            loc.exiting();
            return null;
        }
    }

    public static String getSQLError(SQLException exc, String text) {
        return text + DbDb2Environment.getSQLError(exc);
    }

    private static String getSQLError(SQLException exc) {
        return " ==> SQL-error=" + exc.getErrorCode() + ", SQL-state=" + exc.getSQLState() + ", SQL-message=" + exc.getMessage();
    }

    public static boolean isReservedWord(String id) {
        if (reservedWords == null) {
            reservedWords = new ArrayList();
            reservedWords.add("ADD");
            reservedWords.add("AFTER");
            reservedWords.add("ALL");
            reservedWords.add("ALLOCATE");
            reservedWords.add("ALLOW");
            reservedWords.add("ALTER");
            reservedWords.add("AND");
            reservedWords.add("ANY");
            reservedWords.add("AS");
            reservedWords.add("ASSOCIATE");
            reservedWords.add("ASUTIME");
            reservedWords.add("AUDIT");
            reservedWords.add("AUX");
            reservedWords.add("AUXILIARY");
            reservedWords.add("BEFORE");
            reservedWords.add("BEGIN");
            reservedWords.add("BETWEEN");
            reservedWords.add("BUFFERPOOL");
            reservedWords.add("BY");
            reservedWords.add("CALL");
            reservedWords.add("CAPTURE");
            reservedWords.add("CASCADED");
            reservedWords.add("CASE");
            reservedWords.add("CAST");
            reservedWords.add("CCSID");
            reservedWords.add("CHAR");
            reservedWords.add("CHARACTER");
            reservedWords.add("CHECK");
            reservedWords.add("CLOSE");
            reservedWords.add("CLUSTER");
            reservedWords.add("COLLECTION");
            reservedWords.add("COLLID");
            reservedWords.add("COLUMN");
            reservedWords.add("COMMENT");
            reservedWords.add("COMMIT");
            reservedWords.add("CONCAT");
            reservedWords.add("CONDITION");
            reservedWords.add("CONNECT");
            reservedWords.add("CONNECTION");
            reservedWords.add("CONSTRAINT");
            reservedWords.add("CONTAINS");
            reservedWords.add("CONTINUE");
            reservedWords.add("CREATE");
            reservedWords.add("CURRENT");
            reservedWords.add("CURRENT_DATE");
            reservedWords.add("CURRENT_LC_CTYPE");
            reservedWords.add("CURRENT_PATH");
            reservedWords.add("CURRENT_TIME");
            reservedWords.add("CURRENT_TIMESTAMP");
            reservedWords.add("CURSOR");
            reservedWords.add("DATA");
            reservedWords.add("DATABASE");
            reservedWords.add("DAY");
            reservedWords.add("DAYS");
            reservedWords.add("DBINFO");
            reservedWords.add("DB2SQL");
            reservedWords.add("DECLARE");
            reservedWords.add("DEFAULT");
            reservedWords.add("DELETE");
            reservedWords.add("DESCRIPTOR");
            reservedWords.add("DETERMINISTIC");
            reservedWords.add("DISALLOW");
            reservedWords.add("DISTINCT");
            reservedWords.add("DO");
            reservedWords.add("DOUBLE");
            reservedWords.add("DROP");
            reservedWords.add("DSNHATTR");
            reservedWords.add("DSSIZE");
            reservedWords.add("DYNAMIC");
            reservedWords.add("EDITPROC");
            reservedWords.add("ELSE");
            reservedWords.add("ELSEIF");
            reservedWords.add("ENCODING");
            reservedWords.add("END");
            reservedWords.add("END-EXEC(1)");
            reservedWords.add("ERASE");
            reservedWords.add("ESCAPE");
            reservedWords.add("EXCEPT");
            reservedWords.add("EXECUTE");
            reservedWords.add("EXISTS");
            reservedWords.add("EXIT");
            reservedWords.add("EXTERNAL");
            reservedWords.add("FENCED");
            reservedWords.add("FETCH");
            reservedWords.add("FIELDPROC");
            reservedWords.add("FINAL");
            reservedWords.add("FOR");
            reservedWords.add("FROM");
            reservedWords.add("FULL");
            reservedWords.add("FUNCTION");
            reservedWords.add("GENERAL");
            reservedWords.add("GENERATED");
            reservedWords.add("GET");
            reservedWords.add("GLOBAL");
            reservedWords.add("GO");
            reservedWords.add("GOTO");
            reservedWords.add("GRANT");
            reservedWords.add("GROUP");
            reservedWords.add("HANDLER");
            reservedWords.add("HAVING");
            reservedWords.add("HOUR");
            reservedWords.add("HOURS");
            reservedWords.add("IF");
            reservedWords.add("IMMEDIATE");
            reservedWords.add("IN");
            reservedWords.add("INDEX");
            reservedWords.add("INHERIT");
            reservedWords.add("INNER");
            reservedWords.add("INOUT");
            reservedWords.add("INSENSITIVE");
            reservedWords.add("INSERT");
            reservedWords.add("INTO");
            reservedWords.add("IS");
            reservedWords.add("ISOBID");
            reservedWords.add("JAR");
            reservedWords.add("JAVA");
            reservedWords.add("JOIN");
            reservedWords.add("KEY");
            reservedWords.add("LABEL");
            reservedWords.add("LANGUAGE");
            reservedWords.add("LC_CTYPE");
            reservedWords.add("LEAVE");
            reservedWords.add("LEFT");
            reservedWords.add("LIKE");
            reservedWords.add("LOCAL");
            reservedWords.add("LOCALE");
            reservedWords.add("LOCATOR");
            reservedWords.add("LOCATORS");
            reservedWords.add("LOCK");
            reservedWords.add("LOCKMAX");
            reservedWords.add("LOCKSIZE");
            reservedWords.add("LONG");
            reservedWords.add("LOOP");
            reservedWords.add("MICROSECOND");
            reservedWords.add("MICROSECONDS");
            reservedWords.add("MINUTE");
            reservedWords.add("MINUTES");
            reservedWords.add("MODIFIES");
            reservedWords.add("MONTH");
            reservedWords.add("MONTHS");
            reservedWords.add("NO");
            reservedWords.add("NOT");
            reservedWords.add("NULL");
            reservedWords.add("NULLS");
            reservedWords.add("NUMPARTS");
            reservedWords.add("OBID");
            reservedWords.add("OF");
            reservedWords.add("ON");
            reservedWords.add("OPEN");
            reservedWords.add("OPTIMIZATION");
            reservedWords.add("OPTIMIZE");
            reservedWords.add("OR");
            reservedWords.add("ORDER");
            reservedWords.add("OUT");
            reservedWords.add("OUTER");
            reservedWords.add("PACKAGE");
            reservedWords.add("PARAMETER");
            reservedWords.add("PART");
            reservedWords.add("PATH");
            reservedWords.add("PIECESIZE");
            reservedWords.add("PLAN");
            reservedWords.add("PRECISION");
            reservedWords.add("PREPARE");
            reservedWords.add("PRIQTY");
            reservedWords.add("PRIVILEGES");
            reservedWords.add("PROCEDURE");
            reservedWords.add("PROGRAM");
            reservedWords.add("PSID");
            reservedWords.add("QUERYNO");
            reservedWords.add("READS");
            reservedWords.add("REFERENCES");
            reservedWords.add("RELEASE");
            reservedWords.add("RENAME");
            reservedWords.add("REPEAT");
            reservedWords.add("RESTRICT");
            reservedWords.add("RESULT");
            reservedWords.add("RESULT_SET_LOCATOR");
            reservedWords.add("RETURN");
            reservedWords.add("RETURNS");
            reservedWords.add("REVOKE");
            reservedWords.add("RIGHT");
            reservedWords.add("ROLLBACK");
            reservedWords.add("RUN");
            reservedWords.add("SAVEPOINT");
            reservedWords.add("SCHEMA");
            reservedWords.add("SCRATCHPAD");
            reservedWords.add("SECOND");
            reservedWords.add("SECONDS");
            reservedWords.add("SECQTY");
            reservedWords.add("SECURITY");
            reservedWords.add("SELECT");
            reservedWords.add("SENSITIVE");
            reservedWords.add("SET");
            reservedWords.add("SIMPLE");
            reservedWords.add("SOME");
            reservedWords.add("SOURCE");
            reservedWords.add("SPECIFIC");
            reservedWords.add("STANDARD");
            reservedWords.add("STATIC");
            reservedWords.add("STAY");
            reservedWords.add("STOGROUP");
            reservedWords.add("STORES");
            reservedWords.add("STYLE");
            reservedWords.add("SUBPAGES");
            reservedWords.add("SYNONYM");
            reservedWords.add("SYSFUN");
            reservedWords.add("SYSIBM");
            reservedWords.add("SYSPROC");
            reservedWords.add("SYSTEM");
            reservedWords.add("TABLE");
            reservedWords.add("TABLESPACE");
            reservedWords.add("THEN");
            reservedWords.add("TO");
            reservedWords.add("TRIGGER");
            reservedWords.add("UNDO");
            reservedWords.add("UNION");
            reservedWords.add("UNIQUE");
            reservedWords.add("UNTIL");
            reservedWords.add("UPDATE");
            reservedWords.add("USER");
            reservedWords.add("USING");
            reservedWords.add("VALIDPROC");
            reservedWords.add("VALUES");
            reservedWords.add("VARIANT");
            reservedWords.add("VCAT");
            reservedWords.add("VIEW");
            reservedWords.add("VOLUMES");
            reservedWords.add("WHEN");
            reservedWords.add("WHERE");
            reservedWords.add("WHILE");
            reservedWords.add("WITH");
            reservedWords.add("WLM");
            reservedWords.add("YEAR");
            reservedWords.add("YEARS");
            Collections.sort(reservedWords);
        }
        return Collections.binarySearch(reservedWords, id) >= 0;
    }

    public static String quote(String s) {
        return "\"" + s + "\"";
    }

    private static void setDefaultProperties() {
        defaultProperties = new Properties();
        defaultProperties.setProperty("com.sap.sql.jdbc.db2.uft8fields", "CBS_REPOSITORY.URL.249:TAB11.F1.13");
        defaultProperties.setProperty("com.sap.sql.jdbc.db2.indexV8Check", "CBS_%.%");
        DbDb2Environment.mergeLocalProperties();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void mergeLocalProperties() {
        InputStream in;
        block9: {
            in = null;
            in = (class$com$sap$dictionary$database$db2$DbDb2Environment == null ? (class$com$sap$dictionary$database$db2$DbDb2Environment = DbDb2Environment.class$("com.sap.dictionary.database.db2.DbDb2Environment")) : class$com$sap$dictionary$database$db2$DbDb2Environment).getClassLoader().getResourceAsStream(localFileName);
            if (in == null) {
                in = new FileInputStream(localFileName);
            }
            if (in == null) break block9;
            Properties props = new Properties();
            props.load(in);
            ((Hashtable)defaultProperties).putAll(props);
        }
        Object var3_3 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException ex2) {}
        return;
        {
            catch (IOException ex) {
                Object var3_4 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static boolean checkIndexException(String table, String index) {
        loc.entering("checkIndexException");
        try {
            if (DbDb2Parameters.isV8()) {
                loc.exiting();
                return false;
            }
            if (!exceptionListSet) {
                DbDb2Environment.setExceptionList();
            }
            if (indexExceptions != null) {
                String id = table.trim() + "." + index.trim();
                if (indexExceptions.containsKey(id)) {
                    loc.exiting();
                    return true;
                }
                id = table.substring(0, 4) + "%.%";
                if (indexExceptions.containsKey(id)) {
                    loc.exiting();
                    return true;
                }
            }
            loc.exiting();
            return false;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("checkIndexException: {0}", arguments);
            loc.exiting();
            return false;
        }
    }

    public static Integer checkFieldException(String table, String field) {
        loc.entering("checkFieldException");
        try {
            if (DbDb2Parameters.isV8()) {
                loc.exiting();
                return null;
            }
            Integer i = null;
            i = DbDb2Environment.checkUtf16FieldException(table, field);
            if (i == null && (i = DbDb2Environment.checkUtf8FieldException(table, field)) != null && i == -1) {
                i = null;
            }
            loc.exiting();
            return i;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("checkFieldException: {0}", arguments);
            loc.exiting();
            return null;
        }
    }

    public static Integer checkUtf8FieldException(String table, String field) {
        String id;
        if (DbDb2Parameters.isV8() || !DbDb2Environment.getTstSys()) {
            loc.exiting();
            return null;
        }
        if (!exceptionListSet) {
            DbDb2Environment.setExceptionList();
        }
        if (utf8FieldExceptions != null && utf8FieldExceptions.containsKey(id = table.trim() + "." + field.trim())) {
            return (Integer)utf8FieldExceptions.get(id);
        }
        return null;
    }

    public static Integer checkUtf16FieldException(String table, String field) {
        String id;
        if (DbDb2Parameters.isV8()) {
            loc.exiting();
            return null;
        }
        if (!exceptionListSet) {
            DbDb2Environment.setExceptionList();
        }
        if (utf16FieldExceptions != null && utf16FieldExceptions.containsKey(id = table.trim() + "." + field.trim())) {
            Integer l = (Integer)utf16FieldExceptions.get(id);
            if (-1 == l) {
                l = new Integer(127);
            }
            return l;
        }
        return null;
    }

    private static void setExceptionList() {
        if (defaultProperties == null) {
            DbDb2Environment.setDefaultProperties();
        }
        if (defaultProperties != null && !((Hashtable)defaultProperties).isEmpty()) {
            utf8FieldExceptions = new Hashtable();
            utf16FieldExceptions = new Hashtable();
            indexExceptions = new Hashtable();
            String lst = null;
            lst = defaultProperties.getProperty("com.sap.sql.jdbc.db2.uft8fields");
            if (null != lst) {
                DbDb2Environment.addExceptionList(utf8FieldExceptions, lst);
            }
            if (null != (lst = defaultProperties.getProperty("com.sap.sql.jdbc.db2.utf16fields"))) {
                DbDb2Environment.addExceptionList(utf16FieldExceptions, lst);
            }
            if (null != (lst = defaultProperties.getProperty("com.sap.sql.jdbc.db2.indexV8Check"))) {
                DbDb2Environment.addExceptionList(indexExceptions, lst);
            }
        }
        exceptionListSet = true;
    }

    private static void addExceptionList(Hashtable fexc, String str) {
        if (str == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(str, ":");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            StringTokenizer stp = new StringTokenizer(tok, ".");
            int stpno = stp.countTokens();
            switch (stpno) {
                case 2: {
                    Integer i = new Integer(-1);
                    fexc.put(tok, i);
                    break;
                }
                case 3: {
                    Integer i;
                    String s1 = stp.nextToken();
                    String s2 = stp.nextToken();
                    String s3 = stp.nextToken();
                    String s = s1 + "." + s2;
                    try {
                        i = new Integer(s3);
                    }
                    catch (NumberFormatException ex) {
                        i = new Integer(-1);
                    }
                    fexc.put(s, i);
                }
            }
        }
    }

    public static int getRowLength(DbColumns cols) {
        int rowLength = 0;
        DbColumnIterator iterator = cols.iterator();
        while (iterator.hasNext()) {
            DbDb2Column column = (DbDb2Column)iterator.next();
            rowLength += DbDb2Environment.getByteLengthTable(column);
        }
        if (DbDb2Environment.hasLobs(cols)) {
            rowLength += 19;
        }
        return rowLength;
    }

    public static boolean hasLobs(DbTable tab) {
        if (tab == null) {
            return false;
        }
        DbColumns cols = tab.getColumns();
        if (cols == null) {
            return false;
        }
        return DbDb2Environment.hasLobs(cols);
    }

    public static boolean hasLobs(DbColumns cols) {
        if (cols == null) {
            return false;
        }
        DbColumnIterator iterator = cols.iterator();
        while (iterator.hasNext()) {
            DbColumn column = iterator.next();
            if (!DbDb2Environment.isLob(column)) continue;
            return true;
        }
        return false;
    }

    public static DbSqlStatement getFieldNames(DbColumns cols) {
        String line = "";
        DbColumnIterator iterator = cols.iterator();
        DbSqlStatement fieldNames = new DbSqlStatement();
        while (iterator.hasNext()) {
            line = iterator.next().getName();
            if (iterator.hasNext()) {
                line = line + ", ";
            }
            fieldNames.addLine(line);
        }
        return fieldNames;
    }

    public static int lobCount(DbColumns cols) {
        DbColumnIterator iterator = cols.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            DbColumn column = iterator.next();
            if (!DbDb2Environment.isLob(column)) continue;
            ++count;
        }
        return count;
    }

    public static boolean isLob(DbColumn col) {
        int j = col.getJavaSqlType();
        return j == 2005 || j == 2004 || j == 12 && col.getLength() > (long)DbDb2Parameters.maxLongChar;
    }

    public static DbSqlStatement getDdlClause(DbTable table, DbColumns cols) throws Exception {
        String line = "";
        DbColumnIterator iterator = cols.iterator();
        DbSqlStatement colDef = new DbSqlStatement();
        boolean hasLobs = DbDb2Environment.hasLobs(cols);
        DbFactory factory = table.getDbFactory();
        colDef.addLine("(");
        while (iterator.hasNext()) {
            String repStr;
            int i;
            DbColumn tempColumn = iterator.next();
            DbColumn tempColumn2 = null;
            Integer l = null;
            int len = (int)tempColumn.getLength();
            int type = tempColumn.getJavaSqlType();
            String defaultValue = tempColumn.getDefaultValue();
            boolean changeToUtf8 = false;
            boolean noChange = true;
            if (tempColumn.getJavaSqlType() == 12 && tempColumn.getLength() > (long)DbDb2Parameters.maxLongChar) {
                type = 2005;
                defaultValue = null;
                noChange = false;
            } else {
                if (null != DbDb2Environment.checkUtf8FieldException(table.getName(), tempColumn.getName())) {
                    changeToUtf8 = true;
                }
                if (null != (l = DbDb2Environment.checkFieldException(table.getName(), tempColumn.getName()))) {
                    len = l;
                    noChange = false;
                } else if (!DbDb2Parameters.isV8() && tempColumn.getJavaSqlType() == 12 && tempColumn.getLength() > (long)DbDb2Parameters.maxCharLengthV7 && tempColumn.getLength() < (long)DbDb2Parameters.longCharLengthV7) {
                    if (DbDb2Environment.getTstSys()) {
                        changeToUtf8 = true;
                    } else {
                        len = DbDb2Parameters.maxCharLengthV7;
                        noChange = false;
                    }
                }
            }
            tempColumn2 = noChange ? tempColumn : new DbDb2Column(factory, tempColumn.getName(), tempColumn.getPosition(), type, tempColumn.getDbType(), len, tempColumn.getDecimals(), tempColumn.isNotNull(), defaultValue);
            line = tempColumn2.getDdlClause();
            if (changeToUtf8 && (i = line.indexOf(repStr = "VARGRAPHIC")) >= 0) {
                line = line.substring(0, i) + "VARCHAR" + line.substring(i + repStr.length(), line.length());
            }
            if (iterator.hasNext()) {
                line = line + ", ";
            } else if (!DbDb2Parameters.isV8() && hasLobs) {
                line = line + ", ";
            }
            colDef.addLine(line);
        }
        if (!DbDb2Parameters.isV8() && hasLobs) {
            colDef.addLine(" \"#ROW\" ROWID GENERATED ALWAYS NOT NULL  ");
        }
        colDef.addLine(")");
        return colDef;
    }

    public static int getByteLengthIndex(DbColumn col) {
        return DbDb2Environment.getByteLength(col, false);
    }

    public static int getByteLengthTable(DbColumn col) {
        return DbDb2Environment.getByteLength(col, true);
    }

    private static int getByteLength(DbColumn col, boolean inTable) {
        switch (col.getJavaSqlTypeInfo().getIntCode()) {
            case -1: 
            case 1: 
            case 12: {
                int length = (int)col.getLength();
                if (length > DbDb2Parameters.maxLongChar) {
                    return 6;
                }
                if (inTable) {
                    return (int)(2L * col.getLength() + 2L);
                }
                return (int)(2L * col.getLength());
            }
            case -4: 
            case -3: 
            case -2: {
                if (inTable) {
                    return (int)(col.getLength() + 2L);
                }
                return (int)col.getLength();
            }
            case 5: {
                return 2;
            }
            case 7: {
                return 4;
            }
            case 6: 
            case 8: {
                return 8;
            }
            case 2: 
            case 3: {
                return col.getDecimals() / 2 + 1;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return 10;
            }
            case 92: {
                return 3;
            }
            case 91: {
                return 4;
            }
            case 93: {
                return 10;
            }
            case 2004: 
            case 2005: {
                return 6;
            }
        }
        return 0;
    }

    public static String getLobTabName(Connection con, String tabname) throws JddException {
        loc.entering("getLobTabName");
        try {
            String auxtbname = null;
            boolean done = false;
            int retry = 0;
            do {
                if (retry >= 30) {
                    Object[] arguments = new Object[]{tabname};
                    loc.errorT("getLobTabName: No table name for lob table {0} found after 30 retries.", arguments);
                    loc.exiting();
                    throw new JddException(ExType.NOT_ON_DB, "no lob table name found");
                }
                int len = tabname.length();
                if (len < DbDb2Parameters.maxTabNameLen && ++retry <= 1) {
                    auxtbname = "#" + tabname;
                    continue;
                }
                auxtbname = "#";
                len = Math.min(tabname.length(), DbDb2Parameters.maxTabNameLen - 4);
                auxtbname = auxtbname + tabname.substring(0, len);
                auxtbname = auxtbname + DbDb2Environment.getRandomString(3);
            } while (DbDb2Environment.tableExistsOnDb(con, auxtbname));
            Object[] arguments = new Object[]{auxtbname, tabname};
            loc.infoT("getLobTabName: use {0} for lob table name for table {1}", arguments);
            loc.exiting();
            return auxtbname;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getLobTabName: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public static String getLobAuxName(String tbname, ArrayList tblsps) {
        String tblsp = null;
        boolean done = false;
        while (!done) {
            char[] ltspname = new char[DbDb2Parameters.maxTspNameLen - 2];
            int j = tbname.indexOf("_");
            if (j > 0 && j < tbname.length() - 3) {
                tbname = tbname.substring(j + 1);
            }
            String tbnameUpper = tbname.toUpperCase();
            int len = Math.min(tbnameUpper.length(), 5);
            ltspname[0] = 76;
            tbnameUpper.getChars(0, len, ltspname, 1);
            int l = 1;
            while (l < len + 1) {
                if (-1 == "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".indexOf(ltspname[l])) {
                    ltspname[l] = 88;
                }
                ++l;
            }
            int l2 = len + 1;
            while (l2 < 6) {
                ltspname[l2] = 88;
                ++l2;
            }
            tblsp = new String(ltspname);
            if (Collections.binarySearch(tblsps, tblsp = tblsp + DbDb2Environment.getRandomString(2)) >= 0) continue;
            done = true;
            tblsps.add(tblsp);
            Collections.sort(tblsps);
        }
        return tblsp;
    }

    public static String getAuxTabName(Connection con, String colname) throws JddException {
        loc.entering("getAuxTabName");
        try {
            String auxtbname = null;
            int len = Math.min(colname.length(), 14);
            boolean done = false;
            int retry = 0;
            do {
                if (retry >= 30) {
                    Object[] arguments = new Object[]{colname};
                    loc.errorT("getAuxTabName: No table name for auxiliary lob table found for column {0} after 30 retries.", arguments);
                    loc.exiting();
                    throw new JddException(ExType.NOT_ON_DB, "no auxiliary lobtable found");
                }
                ++retry;
                auxtbname = "#";
                auxtbname = auxtbname + colname.substring(0, len);
            } while (DbDb2Environment.tableExistsOnDb(con, auxtbname = auxtbname + DbDb2Environment.getRandomString(3)));
            Object[] arguments = new Object[]{auxtbname, colname};
            loc.infoT("getAuxTabName: use {0} for auxiliary table for column {1}", arguments);
            loc.exiting();
            return auxtbname;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getAuxTabName: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public static String getDatabaseNameViaDb(Connection con, String tabName) throws JddException {
        loc.entering("getDatabaseNameViaDb");
        try {
            if (con == null) {
                return null;
            }
            String schema = DbDb2Environment.getSchema(con);
            String dbName = null;
            String stmtTxt = null;
            stmtTxt = " SELECT DBNAME  FROM SYSIBM.SYSTABLES  WHERE NAME = ?  AND CREATOR = ?  FETCH FIRST ROW ONLY OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR";
            PreparedStatement stmt = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
            stmt.setString(1, tabName);
            stmt.setString(2, schema);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                dbName = rs.getString(1).trim();
            } else {
                Object[] arguments = new Object[]{tabName};
                loc.infoT("Table {0} not found in catalog", arguments);
            }
            stmt.close();
            rs.close();
            loc.exiting();
            return dbName;
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{DbDb2Environment.getSQLError(ex)};
            loc.errorT("getDatabaseNameViaDb: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getDatabaseNameViaDb: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public static ArrayList getLobAuxTablespaces(Connection con, String tabName) throws JddException {
        loc.entering("getLobAuxTablespaces");
        try {
            if (con == null) {
                return new ArrayList();
            }
            String schema = DbDb2Environment.getSchema(con);
            String stmtTxt = null;
            ArrayList<String> tblsps = new ArrayList<String>();
            stmtTxt = " SELECT B.NAME  FROM SYSIBM.SYSTABLES A, SYSIBM.SYSTABLESPACE B  WHERE A.NAME = ?  AND A.CREATOR = ?  AND B.CREATOR = ?  AND A.DBNAME = B.DBNAME   FOR FETCH ONLY WITH UR";
            PreparedStatement stmt = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
            stmt.setString(1, tabName);
            stmt.setString(2, schema);
            stmt.setString(3, schema);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                tblsps.add(rs.getString(1).trim());
            }
            stmt.close();
            rs.close();
            Collections.sort(tblsps);
            if (tblsps.isEmpty()) {
                Object[] arguments = new Object[]{tabName};
                loc.errorT("getLobAuxTablespaces: Table {0} not found in catalog", arguments);
            }
            loc.exiting();
            return tblsps;
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{DbDb2Environment.getSQLError(ex)};
            loc.errorT("getDatabaseNameViaDb: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getDatabaseNameViaDb: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public static boolean getTstSys() {
        if (null == tstsys) {
            return false;
        }
        return tstsys;
    }

    public static ArrayList getLobAuxTablespacesInDatabase(Connection con, String dbName) throws JddException {
        loc.entering("getLobAuxTablespacesInDatabase");
        try {
            if (con == null) {
                return new ArrayList();
            }
            String schema = DbDb2Environment.getSchema(con);
            String stmtTxt = null;
            ArrayList<String> tblsps = new ArrayList<String>();
            stmtTxt = " SELECT NAME  FROM SYSIBM.SYSTABLESPACE  WHERE DBNAME = ?  AND CREATOR = ?  FOR FETCH ONLY WITH UR";
            PreparedStatement stmt = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
            stmt.setString(1, dbName);
            stmt.setString(2, schema);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                tblsps.add(rs.getString(1).trim());
            }
            stmt.close();
            rs.close();
            Collections.sort(tblsps);
            loc.exiting();
            return tblsps;
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{DbDb2Environment.getSQLError(ex)};
            loc.errorT("getLobAuxTablespacesInDatabase: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getLobAuxTablespacesInDatabase: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public static void setTstSys(Connection con) {
        loc.entering("getTstSys");
        try {
            if (tstsys == null) {
                if (con == null) {
                    tstsys = new Boolean(false);
                } else {
                    String stmtTxt = "SELECT NAME FROM SYSIBM.SYSTABLES  WHERE NAME = ?  AND CREATOR = ?  FETCH FIRST ROW ONLY OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR";
                    PreparedStatement stmt = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
                    stmt.setString(1, "#TSTSYS");
                    stmt.setString(2, "SAPR3");
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        tstsys = new Boolean(true);
                        loc.infoT("getTstSys: db2/390 test system");
                    } else {
                        tstsys = new Boolean(false);
                    }
                    rs.close();
                    stmt.close();
                    loc.exiting();
                }
            }
        }
        catch (SQLException ex) {
            tstsys = new Boolean(false);
            Object[] arguments = new Object[]{DbDb2Environment.getSQLError(ex)};
            loc.errorT("getTstSys: {0}", arguments);
            loc.exiting();
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getTstSys: {0}", arguments);
            loc.exiting();
        }
    }

    public static String getRandomString(int l) {
        char[] c = new char[l];
        Random rn = new Random(System.currentTimeMillis());
        int range = 36;
        int i = 0;
        while (i < l) {
            int ir = rn.nextInt(range);
            c[i] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".charAt(ir);
            ++i;
        }
        return new String(c, 0, l);
    }

    public static String getNameSpace(String tabName) {
        int j = tabName.indexOf("_");
        if (j > 0) {
            return tabName.substring(0, j);
        }
        return null;
    }

    public static String getTableSpaceName(String tabName) {
        int j = tabName.indexOf("_");
        if (j > 0) {
            return tabName.substring(0, j);
        }
        return null;
    }

    public static DbObjectSqlStatements getDdlStatementsForDrop(Connection con, String name, String schema) throws JddException {
        loc.entering("getDdlStatementsForDrop");
        String stmtTxt = null;
        String tabName = name;
        String dbName = null;
        String tspName = null;
        try {
            int ntables = 0;
            int tspCount = 0;
            DbObjectSqlStatements tableDef = new DbObjectSqlStatements(name);
            DbDb2SqlStatement dropLine = new DbDb2SqlStatement(true);
            if (con != null) {
                stmtTxt = "SELECT A.NAME, A.DBNAME, A.TSNAME, DIGITS(B.NTABLES),B.CREATOR  FROM SYSIBM.SYSTABLES A,SYSIBM.SYSTABLESPACE B  WHERE B.DBNAME  = A.DBNAME    AND B.NAME    = A.TSNAME    AND A.CREATOR = ?    AND B.CREATOR = ?    AND ( A.NAME  = ? OR A.NAME  = ? )    AND  A.TYPE  = 'T'  FETCH FIRST ROW ONLY OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR";
                PreparedStatement pstmt1 = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
                pstmt1.setString(1, schema);
                pstmt1.setString(2, schema);
                pstmt1.setString(3, name);
                pstmt1.setString(4, "#" + name.trim());
                ResultSet rs = pstmt1.executeQuery();
                if (rs.next()) {
                    tabName = rs.getString(1);
                    dbName = rs.getString(2);
                    tspName = rs.getString(3);
                    ntables = rs.getInt(4);
                }
                rs.close();
                pstmt1.close();
                if (ntables == 1) {
                    stmtTxt = "SELECT COUNT(*) FROM SYSIBM.SYSTABLESPACE WHERE TYPE <> 'O' AND DBNAME =? ";
                    PreparedStatement pstmtdb = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
                    pstmtdb.setString(1, dbName);
                    ResultSet rsdb = pstmtdb.executeQuery();
                    if (rsdb.next()) {
                        tspCount = rsdb.getInt(1);
                    }
                    rsdb.close();
                    pstmtdb.close();
                    if (tspCount == 1) {
                        dropLine.addLine("DROP DATABASE " + dbName);
                    } else {
                        dropLine.addLine("DROP TABLESPACE " + dbName + "." + tspName);
                    }
                } else {
                    dropLine.addLine("DROP TABLE " + DbDb2Environment.quote(tabName));
                }
                tableDef.add(dropLine);
                if (tspCount != 1) {
                    stmtTxt = "SELECT  B.DBNAME, B.TSNAME  FROM SYSIBM.SYSAUXRELS A,  SYSIBM.SYSTABLES B  WHERE A.TBNAME = ?  AND A.TBOWNER = ?  AND B.CREATOR = ?  AND A.AUXTBNAME = B.NAME  AND A.AUXTBOWNER = B.CREATOR  FOR FETCH ONLY WITH UR";
                    PreparedStatement pstmt2 = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
                    pstmt2.setString(1, name);
                    pstmt2.setString(2, schema);
                    pstmt2.setString(3, schema);
                    rs = pstmt2.executeQuery();
                    while (rs.next()) {
                        dbName = rs.getString(1).trim();
                        tspName = rs.getString(2).trim();
                        dropLine = new DbDb2SqlStatement(true);
                        dropLine.addLine("DROP TABLESPACE " + dbName + "." + tspName);
                        tableDef.add(dropLine);
                    }
                    rs.close();
                    pstmt2.close();
                }
            } else {
                dropLine.addLine("DROP TABLE " + DbDb2Environment.quote(name) + " +LOCATION ");
                tableDef.add(dropLine);
            }
            loc.exiting();
            return tableDef;
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{DbDb2Environment.getSQLError(ex, stmtTxt)};
            loc.errorT("getDdlStatementsForDrop: generation of create statement failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getDdlStatementsForDrop: generation of create statement failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public static String getTspName(String tbname) {
        char[] tsname = new char[DbDb2Parameters.maxTspNameLen];
        int j = tbname.indexOf("_");
        if (j > 0 && j < tbname.length() - 3) {
            tbname = tbname.substring(j + 1);
        }
        int len = Math.min(tbname.length(), DbDb2Parameters.maxTspNameLen - 1);
        int i = 0;
        while (i < len) {
            char c = tbname.toUpperCase().charAt(i);
            tsname[i] = -1 == "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".indexOf(c) ? 88 : c;
            ++i;
        }
        String str = new String(tsname, 0, len);
        return str;
    }

    public static String getDbName(Connection con, String tab, String tblsp, String schema, boolean[] dbExists) throws JddException {
        loc.entering("getDbName");
        String rdb = null;
        String rdbc = DbDb2Environment.getNameSpace(tab);
        if (rdbc != null) {
            if ((rdbc = rdbc.substring(0, Math.min(rdbc.length(), 3))).length() < 3) {
                rdbc = rdbc + "XX";
                rdbc = rdbc.substring(0, 3);
            }
        } else {
            rdbc = "JD0";
        }
        rdbc = rdbc + "XX";
        if (con == null) {
            rdb = rdbc + "___";
            dbExists[0] = false;
        } else {
            rdb = DbDb2Environment.checkExDb(con, rdbc, tblsp, schema);
            if (rdb == null) {
                String rs;
                int retry = 0;
                do {
                    if (retry >= 30) {
                        Object[] arguments = new Object[]{tab};
                        loc.errorT("No database found found for table {0} after 30 retries.", arguments);
                        loc.exiting();
                        throw new JddException(ExType.NOT_ON_DB, "no database found");
                    }
                    ++retry;
                    rs = DbDb2Environment.getRandomString(3);
                } while (DbDb2Environment.existsDb(con, rdb = rdbc + rs));
                dbExists[0] = false;
            } else {
                dbExists[0] = true;
            }
        }
        loc.exiting();
        return rdb;
    }

    private static boolean existsDb(Connection con, String db) throws JddException {
        loc.entering("existsDb");
        boolean dbExists = false;
        if (con == null) {
            return false;
        }
        String stmtTxt = null;
        try {
            stmtTxt = " SELECT NAME FROM SYSIBM.SYSDATABASE  WHERE NAME = ?  FETCH FIRST ROW ONLY OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR";
            PreparedStatement pstmt = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
            pstmt.setString(1, db);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                dbExists = true;
            }
            rs.close();
            pstmt.close();
            loc.exiting();
            return dbExists;
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{DbDb2Environment.getSQLError(ex, stmtTxt)};
            loc.errorT("dbExists: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("dbExists: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    private static String checkExDb(Connection con, String sdb, String tblsp, String schema) throws JddException {
        loc.entering("checkExDb");
        if (con == null) {
            return null;
        }
        String stmtTxt = null;
        String rdb = null;
        try {
            stmtTxt = " ( SELECT  0 AS C, NAME AS D  FROM SYSIBM.SYSDATABASE A  WHERE A.NAME LIKE ? AND NOT A.NAME IN  ( SELECT DBNAME FROM SYSIBM.SYSTABLESPACE ) AND A.CREATOR = ? )   UNION  ( SELECT  C, D  FROM  (SELECT DBNAME AS D, COUNT(*) AS C  FROM SYSIBM.SYSTABLESPACE A,  SYSIBM.SYSDATABASE B  GROUP BY A.DBNAME, B.NAME, B.CREATOR  HAVING B.NAME LIKE ? AND B.NAME = A.DBNAME AND NOT B.NAME IN  ( SELECT A.DBNAME  FROM SYSIBM.SYSTABLESPACE A   WHERE  A.DBNAME LIKE  ? AND A.NAME LIKE ? )  AND B.CREATOR = ? ) C WHERE C.C < 100  )   ORDER BY         C ASC  FETCH FIRST ROW ONLY OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR";
            PreparedStatement pstmt = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
            pstmt.setString(1, sdb + "%");
            pstmt.setString(2, schema);
            pstmt.setString(3, sdb + "%");
            pstmt.setString(4, sdb + "%");
            pstmt.setString(5, tblsp + "%");
            pstmt.setString(6, schema);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                rdb = rs.getString(2).trim();
            }
            rs.close();
            pstmt.close();
            loc.exiting();
            return rdb;
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{DbDb2Environment.getSQLError(ex, stmtTxt)};
            loc.errorT("checkExDb: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("checkExDb: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public static boolean tableExistsOnDb(Connection con, String name) {
        loc.entering("tableExistsOnDb");
        String stmtTxt = null;
        try {
            if (con == null) {
                loc.exiting();
                return false;
            }
            boolean exists = false;
            String schema = DbDb2Environment.getSchema(con);
            stmtTxt = "SELECT NAME  FROM SYSIBM.SYSTABLES WHERE  NAME = ? AND CREATOR = ? AND TYPE = 'T'  FETCH FIRST ROW ONLY OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR";
            PreparedStatement stmt = NativeSQLAccess.prepareNativeStatement((Connection)con, (String)stmtTxt);
            stmt.setString(1, name);
            stmt.setString(2, schema);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                exists = true;
            }
            rs.close();
            stmt.close();
            loc.exiting();
            return exists;
        }
        catch (SQLException ex) {
            Object[] arguments = new Object[]{DbDb2Environment.getSQLError(ex, stmtTxt)};
            loc.errorT("tableExistsOnDb: {0}", arguments);
            loc.exiting();
            return false;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("tableExistsOnDb: {0}", arguments);
            loc.exiting();
            return false;
        }
    }

    public static boolean checkV8CharDefault(Connection con) {
        loc.entering("checkV8CharDefault");
        String stmtTxt = null;
        try {
            Statement stmt;
            block9: {
                if (con == null) {
                    loc.exiting();
                    return false;
                }
                if (v8HasCharDefault != null) {
                    return v8HasCharDefault;
                }
                v8HasCharDefault = new Boolean(true);
                stmt = NativeSQLAccess.createNativeStatement((Connection)con);
                stmtTxt = " DROP TABLE \"#ZSAP\" ";
                try {
                    stmt.execute(stmtTxt);
                }
                catch (SQLException ex) {
                    if (ex.getErrorCode() == -204) break block9;
                    Object[] arguments = new Object[]{DbDb2Environment.getSQLError(ex, stmtTxt)};
                    loc.errorT("checkV8CharDefault drop table \"#ZSAP\": {0}", arguments);
                }
            }
            stmtTxt = " CREATE TABLE \"#ZSAP\" ( F1 VARGRAPHIC(1) DEFAULT 'X' )  CCSID UNICODE ";
            stmt = NativeSQLAccess.createNativeStatement((Connection)con);
            stmt.execute(stmtTxt);
            stmtTxt = " DROP TABLE \"#ZSAP\" ";
            stmt.execute(stmtTxt);
            stmt.close();
            loc.exiting();
            return true;
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == -574) {
                v8HasCharDefault = new Boolean(false);
            } else {
                Object[] arguments = new Object[]{DbDb2Environment.getSQLError(ex, stmtTxt)};
                loc.errorT("checkV8CharDefault: {0}", arguments);
            }
            loc.exiting();
            return false;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("checkV8CharDefault: {0}", arguments);
            loc.exiting();
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        utf8FieldExceptions = null;
        utf16FieldExceptions = null;
        indexExceptions = null;
        exceptionListSet = false;
        loc = Logger.getLocation("db2.DbDb2Environment");
        tstsys = null;
        v8HasCharDefault = null;
    }
}

