/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.db2;

import com.sap.dictionary.database.db2.DbDb2Column;
import com.sap.dictionary.database.db2.DbDb2Environment;
import com.sap.dictionary.database.db2.DbDb2Parameters;
import com.sap.dictionary.database.db2.DbDb2Stogroup;
import com.sap.dictionary.database.db2.DbDb2Table;
import com.sap.dictionary.database.dbs.Action;
import com.sap.dictionary.database.dbs.DbColumn;
import com.sap.dictionary.database.dbs.DbColumnDifference;
import com.sap.dictionary.database.dbs.DbColumnIterator;
import com.sap.dictionary.database.dbs.DbColumns;
import com.sap.dictionary.database.dbs.DbColumnsDifference;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.DbObjectSqlStatements;
import com.sap.dictionary.database.dbs.DbSqlStatement;
import com.sap.dictionary.database.dbs.DbTable;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.dictionary.database.dbs.Logger;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.util.ArrayList;

public class DbDb2ColumnsDifference
extends DbColumnsDifference {
    private static Location loc = Logger.getLocation("db2.DbDb2ColumnsDifference");

    public DbObjectSqlStatements getDdlStatementsForAlter(String tableName) throws Exception {
        loc.entering("getDdlStatementsForAlter");
        try {
            DbSqlStatement statement;
            DbColumnDifference diff;
            DbColumnDifference diff2;
            DbObjectSqlStatements statements = new DbObjectSqlStatements(tableName);
            boolean alterFlagAdd = false;
            boolean alterFlagLength = false;
            boolean hasLobs = false;
            boolean addLobs = false;
            boolean changeToLobTable = false;
            DbTable tableTarget = null;
            DbColumns columnsOrg = null;
            DbColumns columnsTarget = null;
            DbFactory factory = null;
            Connection con = null;
            String dbTableName = tableName;
            String dbName = null;
            ArrayList tblsps = null;
            DbColumnsDifference.MultiIterator iterator = this.iterator();
            iterator = this.iterator();
            if (iterator.hasNextWithAdd()) {
                if (iterator.hasNextWithAdd()) {
                    diff2 = iterator.nextWithAdd();
                    DbColumn columnTarget = diff2.getTarget();
                    columnsTarget = columnTarget.getColumns();
                    tableTarget = columnsTarget.getTable();
                    factory = tableTarget.getDbFactory();
                    con = factory.getConnection();
                }
                DbColumnIterator colIterator = columnsTarget.iterator();
                while (colIterator.hasNext()) {
                    DbDb2Column col = (DbDb2Column)colIterator.next();
                    if (!DbDb2Environment.isLob(col)) continue;
                    iterator = this.iterator();
                    boolean isNewCol = false;
                    while (iterator.hasNextWithAdd()) {
                        diff = iterator.nextWithAdd();
                        DbColumn colTarget = diff.getTarget();
                        if (!colTarget.equals(col)) continue;
                        isNewCol = true;
                        break;
                    }
                    if (isNewCol) continue;
                    hasLobs = true;
                    dbTableName = col.getLobTableName();
                    break;
                }
                iterator = this.iterator();
                while (iterator.hasNextWithAdd()) {
                    DbColumnDifference diff3 = iterator.nextWithAdd();
                    DbColumn colTarget = diff3.getTarget();
                    if (!DbDb2Environment.isLob(colTarget)) continue;
                    addLobs = true;
                    break;
                }
                if (addLobs && !hasLobs && !DbDb2Parameters.isV8()) {
                    changeToLobTable = true;
                    dbTableName = DbDb2Environment.getLobTabName(con, tableName);
                    if (tableTarget instanceof DbDb2Table) {
                        ((DbDb2Table)tableTarget).setDbTableName(dbTableName);
                    }
                }
                if (addLobs) {
                    statement = new DbSqlStatement();
                    statement.addLine(" SET CURRENT RULES = 'DB2' ");
                    statements.add(statement);
                }
                if (changeToLobTable) {
                    statement = new DbSqlStatement();
                    statement.addLine("RENAME TABLE " + DbDb2Environment.quote(tableName));
                    statement.addLine(" TO " + DbDb2Environment.quote(dbTableName));
                    statements.add(statement);
                    statement = new DbSqlStatement();
                    statement.addLine("ALTER TABLE " + DbDb2Environment.quote(dbTableName));
                    statement.addLine(" ADD ");
                    statement.addLine(" #ROW ROWID GENERATED ALWAYS NOT NULL ");
                    statements.add(statement);
                }
                if (addLobs) {
                    String tabName = null;
                    tabName = changeToLobTable ? tableName : dbTableName;
                    dbName = con != null ? DbDb2Environment.getDatabaseNameViaDb(con, tabName) : "________";
                    tblsps = DbDb2Environment.getLobAuxTablespaces(con, tabName);
                }
            }
            iterator = this.iterator();
            while (iterator.hasNextWithAdd()) {
                diff2 = iterator.nextWithAdd();
                statement = new DbSqlStatement();
                statement.addLine("ALTER TABLE " + DbDb2Environment.quote(dbTableName));
                statement.addLine(" ADD ");
                statement.addLine(diff2.getTarget().getDdlClause());
                statements.add(statement);
                if (DbDb2Environment.isLob(diff2.getTarget())) {
                    String lTspName = DbDb2Environment.getLobAuxName(tableName, tblsps);
                    statements.merge(this.getDdlStatementsForCreateLobAuxTables(con, tableName, dbTableName, lTspName, dbName, diff2.getTarget().getName()));
                }
                alterFlagAdd = true;
            }
            if (changeToLobTable) {
                DbObjectSqlStatements createLobView = this.getDdlStatementsForCreateLobView(tableName, dbTableName, columnsTarget);
                statements.merge(createLobView);
            }
            DbObjectSqlStatements statementsAlterLength = new DbObjectSqlStatements(tableName);
            boolean dropCreatePrimaryKey = false;
            boolean first = true;
            while (iterator.hasNextWithTypeLenDecChange()) {
                diff = iterator.nextWithTypeLenDecChange();
                DbColumn column = diff.getTarget();
                if (first) {
                    DbColumn columnOrg = diff.getOrigin();
                    columnsOrg = columnOrg.getColumns();
                    DbTable tableOrg = columnsOrg.getTable();
                    DbColumn columnTarget = diff.getTarget();
                    columnsTarget = columnTarget.getColumns();
                    hasLobs = DbDb2Environment.hasLobs(tableOrg);
                    if (hasLobs && !changeToLobTable) {
                        dbTableName = ((DbDb2Table)tableOrg).getDbTableName();
                    }
                }
                if (diff.getAction() != Action.ALTER) continue;
                statement = new DbSqlStatement();
                statement.addLine(" ALTER TABLE " + DbDb2Environment.quote(dbTableName));
                statement.addLine(" ALTER COLUMN " + DbDb2Environment.quote(column.getName()) + " SET DATA TYPE " + this.getAlterTypeClause(column));
                statementsAlterLength.add(statement);
                alterFlagLength = true;
            }
            if ((hasLobs || changeToLobTable) && !DbDb2Parameters.isV8()) {
                DbObjectSqlStatements dropLobView = this.getDdlStatementsForDropLobView(tableName);
                statements.merge(dropLobView);
            }
            if (alterFlagLength) {
                statements.merge(statementsAlterLength);
            }
            if ((hasLobs || changeToLobTable) && !DbDb2Parameters.isV8()) {
                DbObjectSqlStatements createLobView = this.getDdlStatementsForCreateLobView(tableName, dbTableName, columnsTarget);
                statements.merge(createLobView);
            }
            if (alterFlagAdd || alterFlagLength) {
                loc.exiting();
                return statements;
            }
            loc.exiting();
            return null;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getDdlStatementsForAlter failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public DbObjectSqlStatements getDdlStatementsForDropLobView(String viewName) throws JddException {
        loc.entering("getDdlStatementsForDropLobView");
        try {
            DbObjectSqlStatements dropViewStmts = new DbObjectSqlStatements(viewName);
            DbSqlStatement dropLine = new DbSqlStatement(false);
            dropLine.addLine("DROP  VIEW " + DbDb2Environment.quote(viewName));
            dropViewStmts.add(dropLine);
            loc.exiting();
            return dropViewStmts;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getDdlStatementsForDropLobView failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    public DbObjectSqlStatements getDdlStatementsForCreateLobView(String viewName, String tabName, DbColumns cols) throws JddException {
        loc.entering("getDdlStatementsForCreateLobView");
        try {
            DbObjectSqlStatements createViewStmts = new DbObjectSqlStatements(viewName);
            DbSqlStatement createView = new DbSqlStatement();
            createView.addLine("CREATE VIEW " + DbDb2Environment.quote(viewName) + " ( ");
            createView.merge(DbDb2Environment.getFieldNames(cols));
            createView.addLine(" ) AS SELECT ");
            createView.merge(DbDb2Environment.getFieldNames(cols));
            createView.addLine(" FROM " + DbDb2Environment.quote(tabName));
            createViewStmts.add(createView);
            loc.exiting();
            return createViewStmts;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getDdlStatementsForCreateLobView failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    private DbObjectSqlStatements getDdlStatementsForCreateLobAuxTables(Connection con, String tabName, String dbTableName, String lTspName, String dbName, String colName) throws JddException {
        loc.entering("getDdlStatementsForCreateLobAuxTables");
        try {
            String SapjStogroup = DbDb2Stogroup.getStogroup(con);
            if (SapjStogroup == null) {
                Object[] arguments = new Object[]{tabName, DbDb2Environment.getSchema(con)};
                loc.errorT("getDdlStatementsForAlter {0}: No stogroup for java percistency for schema " + DbDb2Environment.getSchema(con) + " found in catalog", arguments);
                loc.exiting();
                throw new JddException(ExType.NOT_ON_DB, "No stogroup for schema " + DbDb2Environment.getSchema(con));
            }
            DbObjectSqlStatements stmts = new DbObjectSqlStatements(tabName);
            String ltb = DbDb2Environment.getAuxTabName(con, colName.toUpperCase());
            DbSqlStatement createLobTspLine = new DbSqlStatement();
            createLobTspLine.addLine(" CREATE LOB TABLESPACE " + lTspName + " IN " + dbName);
            createLobTspLine.addLine(" USING STOGROUP " + SapjStogroup);
            if (DbDb2Parameters.isV7()) {
                createLobTspLine.addLine(" PRIQTY 200 SECQTY 10240 ");
            }
            createLobTspLine.addLine(" LOG YES LOCKMAX 0 GBPCACHE SYSTEM LOCKSIZE LOB ");
            createLobTspLine.addLine(" BUFFERPOOL BP40 ");
            stmts.add(createLobTspLine);
            DbSqlStatement createAuxTbLine = new DbSqlStatement();
            createAuxTbLine.addLine(" CREATE AUX TABLE " + DbDb2Environment.quote(ltb) + " IN " + dbName + "." + lTspName);
            createAuxTbLine.addLine(" STORES " + DbDb2Environment.quote(dbTableName) + " COLUMN " + DbDb2Environment.quote(colName));
            stmts.add(createAuxTbLine);
            DbSqlStatement createAuxIndLine = new DbSqlStatement();
            createAuxIndLine.addLine(" CREATE INDEX " + DbDb2Environment.quote(ltb) + " ON  " + DbDb2Environment.quote(ltb));
            createAuxIndLine.addLine(" USING STOGROUP " + SapjStogroup);
            if (DbDb2Parameters.isV7()) {
                createAuxIndLine.addLine(" PRIQTY 16 SECQTY 10240 ");
            }
            createAuxIndLine.addLine(" FREEPAGE 10 PCTFREE 10 GBPCACHE CHANGED ");
            createAuxIndLine.addLine(" BUFFERPOOL BP40 ");
            stmts.add(createAuxIndLine);
            return stmts;
        }
        catch (Exception ex) {
            Object[] arguments = new Object[]{ex.getMessage()};
            loc.errorT("getDdlStatementsForCreateLobAuxTables failed: {0}", arguments);
            loc.exiting();
            throw JddException.createInstance(ex);
        }
    }

    private String getAlterTypeClause(DbColumn column) throws Exception {
        String s = column.getDdlTypeClause();
        switch (column.getJavaSqlType()) {
            case -3: 
            case -2: {
                int i = s.indexOf("FOR BIT DATA");
                if (i <= 0) break;
                s = s.substring(0, i);
                break;
            }
        }
        return s;
    }
}

