/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.database.catalog;

import com.sap.dictionary.database.catalog.DbGeneralStructure;
import com.sap.dictionary.database.dbs.Database;
import com.sap.dictionary.database.dbs.DbFactory;
import com.sap.dictionary.database.dbs.ExType;
import com.sap.dictionary.database.dbs.JddException;
import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.catalog.Table;
import java.sql.Connection;
import java.sql.SQLException;

public class DbCatalogReader
implements CatalogReader {
    private Connection con = null;
    private Database database = null;
    private DbFactory factory = null;

    public DbCatalogReader(Connection con) {
        this.con = con;
        try {
            this.database = Database.getDatabase(con);
            this.factory = new DbFactory(con);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Table getTable(String tableName) throws SQLException {
        DbGeneralStructure gs = null;
        try {
            gs = new DbGeneralStructure(tableName, this.con, this.factory);
            if (tableName.compareTo(gs.getName()) != 0) {
                return null;
            }
        }
        catch (JddException ex) {
            if (ex.getExType() == ExType.SQL_ERROR) {
                throw new SQLException(ex.getMessage());
            }
            if (ex.getExType() == ExType.NOT_ON_DB) {
                return null;
            }
            return null;
        }
        return gs;
    }

    public Table getTable(String schemaName, String tableName) throws SQLException {
        DbGeneralStructure gs = null;
        try {
            gs = new DbGeneralStructure(tableName, this.con, this.factory);
            if (tableName.compareTo(gs.getName()) != 0) {
                return null;
            }
        }
        catch (JddException ex) {
            if (ex.getExType() == ExType.SQL_ERROR) {
                throw new SQLException(ex.getMessage());
            }
            if (ex.getExType() == ExType.NOT_ON_DB) {
                return null;
            }
            return null;
        }
        return gs;
    }

    public boolean existsTable(String tableName) throws SQLException {
        return this.getTable(tableName) != null;
    }

    public boolean existsTable(String schemaName, String tableName) throws SQLException {
        return this.getTable(schemaName, tableName) != null;
    }

    public boolean isLogicalCatalogReader() {
        return false;
    }
}

