/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class VersionReport {
    private final int BUFFER_SIZE = 1024;
    private static final String fileName = "." + File.separator + "version.txt";

    public static void main(String[] args) {
        VersionReport vr = new VersionReport();
        if (args.length > 1 || args.length == 1 && args[0].toLowerCase() != "-more") {
            System.out.println(vr.getUsage());
        }
        vr.getAloneJars();
    }

    public String getUsage() {
        return new String(" Displays the version release of the cluster. \n Usage: Version [more] \n Parameters: \n     [more]  -  generates and displays a detailed information of all jars. ");
    }

    public Properties getVersionHeaderDetails() throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        Properties result = new Properties();
        String versionFileLine = reader.readLine();
        while (versionFileLine != null) {
            if (!versionFileLine.startsWith("#")) {
                if (versionFileLine.startsWith("Cluster-Version:")) {
                    ((Hashtable)result).put("Cluster Version", versionFileLine.substring(16).trim());
                }
                if (versionFileLine.startsWith("Stand Alone-Version:")) {
                    ((Hashtable)result).put("Stand Alone Version", versionFileLine.substring(20).trim());
                }
                if (versionFileLine.startsWith("Build-On:")) {
                    ((Hashtable)result).put("Build-On", versionFileLine.substring(9).trim());
                }
                if (versionFileLine.startsWith("Perfroce-Server:")) {
                    ((Hashtable)result).put("Perfroce-Server", versionFileLine.substring(16).trim());
                }
                if (versionFileLine.startsWith("Project-Dir:")) {
                    ((Hashtable)result).put("Project-Dir", versionFileLine.substring(12).trim());
                }
                if (versionFileLine.startsWith("AppServer Change-List:")) {
                    ((Hashtable)result).put("AppServer Change-List", versionFileLine.substring(22).trim());
                }
                if (versionFileLine.startsWith("XMLInstall Change-List:")) {
                    ((Hashtable)result).put("XMLInstall Change-List", versionFileLine.substring(23).trim());
                }
            }
            versionFileLine = reader.readLine();
        }
        reader.close();
        return result;
    }

    private void getAloneJars() {
        Vector jars = new Vector();
        this.fillJars(jars, ".", 1);
        this.generateResult(jars);
    }

    private void generateResult(Vector jars) {
        String[][] result = null;
        try {
            PrintWriter pr = new PrintWriter(new FileOutputStream("VersionReport.html"));
            pr.println("<p> Automatically generated Version Report on " + new Date() + " </p>");
            pr.println("<p> SAP Builded Jars' Data (SAP_MANIFEST.MF): </p>");
            result = this.getDetailedInfo(jars, "META-INF/SAP_MANIFEST.MF");
            this.printMatrixHTML(result, pr);
            pr.println("<p> Original Jars' Data (MANIFEST.MF): </p>");
            result = this.getDetailedInfo(jars, "META-INF/MANIFEST.MF");
            this.printMatrixHTML(result, pr);
            pr.close();
            System.out.println(" File VersionReport.html is created.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String[][] putInMatrix(String[][] matrix, String rowName, String columnName, String value) {
        int rowIndex = matrix.length;
        int i = matrix.length - 1;
        while (i > 0) {
            if (matrix[i][0].toLowerCase().equals(rowName.toLowerCase())) {
                rowIndex = i;
                break;
            }
            --i;
        }
        if (rowIndex == matrix.length) {
            matrix = this.expandMatrixRows(matrix);
            matrix[rowIndex][0] = rowName;
        }
        if (columnName == null) {
            return matrix;
        }
        int columnIndex = matrix[0].length;
        int i2 = 0;
        while (i2 < matrix[0].length) {
            if (matrix[0][i2].toLowerCase().equals(columnName.toLowerCase())) {
                columnIndex = i2;
                break;
            }
            ++i2;
        }
        if (columnIndex == matrix[0].length) {
            matrix = this.expandMatrixColums(matrix);
            matrix[0][columnIndex] = columnName;
        }
        matrix[rowIndex][columnIndex] = value;
        return matrix;
    }

    private String[][] expandMatrixColums(String[][] matrix) {
        String[][] newMatrix = new String[matrix.length][];
        int i = 0;
        while (i < matrix.length) {
            newMatrix[i] = new String[matrix[0].length + 1];
            int j = 0;
            while (j < matrix[0].length) {
                newMatrix[i][j] = matrix[i][j];
                ++j;
            }
            ++i;
        }
        return newMatrix;
    }

    private String[][] expandMatrixRows(String[][] matrix) {
        String[][] newMatrix = new String[matrix.length + 1][];
        int i = 0;
        while (i < matrix.length) {
            newMatrix[i] = matrix[i];
            ++i;
        }
        newMatrix[matrix.length] = new String[matrix[0].length];
        return newMatrix;
    }

    private void printMatrixXLS(String[][] matrix) {
        String result = "";
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                if (matrix[i][j] == null) {
                    matrix[i][j] = " ";
                }
                result = result + matrix[i][j] + "\t";
                ++j;
            }
            result = result + "\n";
            ++i;
        }
        try {
            FileOutputStream fs = new FileOutputStream("VersionReport.xls");
            fs.write(result.getBytes());
            fs.flush();
            fs.close();
            System.out.println(" File VersionReport.xls is created.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void printMatrixHTML(String[][] matrix, PrintWriter pr) {
        pr.println("<table border=\"1\">");
        int i = 0;
        while (i < matrix.length) {
            pr.println("  <tr>");
            int j = 0;
            while (j < matrix[0].length) {
                if (matrix[i][j] == null) {
                    matrix[i][j] = "&nbsp;";
                }
                pr.println("    <td>" + matrix[i][j].replace('<', ' ').replace('>', ' ') + "</td>");
                ++j;
            }
            pr.println("  </tr>");
            ++i;
        }
        pr.println("</table>");
    }

    private String[][] getDetailedInfo(Vector jars, String manifest) {
        String[][] matrix = new String[1][1];
        matrix[0][0] = "";
        byte[] metaBytes = null;
        int i = 0;
        while (i < jars.size()) {
            metaBytes = null;
            try {
                metaBytes = this.readResourceFromJar(manifest, (File)jars.elementAt(i));
            }
            catch (IOException ex) {
                System.out.println(ex);
            }
            if (metaBytes == null) {
                String rowName = ((File)jars.elementAt(i)).getPath();
                matrix = this.putInMatrix(matrix, rowName, null, null);
            } else {
                BufferedReader bufReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(metaBytes)));
                String line = "";
                try {
                    while ((line = bufReader.readLine()) != null) {
                        int separator = line.indexOf(":");
                        if (separator == -1) continue;
                        String rowName = ((File)jars.elementAt(i)).getPath();
                        String columnName = line.substring(0, separator);
                        String value = line.substring(separator + 1);
                        matrix = this.putInMatrix(matrix, rowName, columnName, value);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            ++i;
        }
        return matrix;
    }

    private void fillJars(Vector jars, String directory, int deep) {
        File thisDir = new File(directory);
        File[] allFiles = thisDir.listFiles();
        int i = 0;
        while (i < allFiles.length) {
            if (allFiles[i].getName().toLowerCase().endsWith(".jar")) {
                jars.add(allFiles[i]);
            } else if (allFiles[i].isDirectory() && deep > 0) {
                this.fillJars(jars, allFiles[i].getName(), deep - 1);
            }
            ++i;
        }
    }

    private byte[] readResourceFromJar(String name, File jarFile) throws IOException {
        JarFile jar = new JarFile(jarFile);
        JarEntry entry = jar.getJarEntry(name);
        if (entry == null) {
            return null;
        }
        byte[] byteBuffer = new byte[1024];
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            InputStream in = jar.getInputStream(entry);
            int read = in.read(byteBuffer, 0, 1024);
            while (read != -1) {
                buffer.write(byteBuffer, 0, read);
                read = in.read(byteBuffer, 0, 1024);
            }
            in.close();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            return null;
        }
        try {
            byteBuffer = buffer.toByteArray();
            buffer.close();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        jar.close();
        return byteBuffer;
    }
}

