/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.frame.ServiceContext;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.adminadapter.shell.VersionReport;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class VersionCommand
implements Command {
    private ServiceContext sc;

    public VersionCommand(ServiceContext sc) {
        this.sc = sc;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter out = new PrintWriter(os, true);
        boolean more = false;
        if (params.length > 1) {
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> VERSION] Too much parameters.\r\n");
            return;
        }
        if (params.length == 1) {
            if (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
                out.println(this.getHelpMessage());
                return;
            }
            if (params[0].equalsIgnoreCase("-more")) {
                more = true;
            } else {
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> VERSION] Unknown parameter " + params[0] + ".\r\n");
                return;
            }
        }
        out.println("\r\nSAP J2EE Engine Version " + this.sc.getCoreContext().getCoreMonitor().getCoreVersion() + "\r\n");
        try {
            if (more) {
                Properties res = new VersionReport().getVersionHeaderDetails();
                Enumeration<?> en = res.propertyNames();
                while (en.hasMoreElements()) {
                    String name = (String)en.nextElement();
                    out.println("  " + name + this.spaces(25 - name.length()) + ((Hashtable)res).get(name));
                }
                out.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> VERSION] Can not display additional information.\r\n[Shell -> VERSION] Reason : " + e.getMessage() + "\r\n");
        }
    }

    private String spaces(int n) {
        if (n > 0) {
            StringBuffer ret = new StringBuffer(n);
            int i = 0;
            while (i < n) {
                ret.append(' ');
                ++i;
            }
            return ret.toString();
        }
        return "";
    }

    public String getHelpMessage() {
        return "\r\nDisplays the version of the cluster.\r\nUsage: VERSION [-more]\r\nParameters:\r\n  [-more] - Displays additional information.\r\n";
    }

    public String getGroup() {
        return "ADMIN";
    }

    public String getName() {
        return "VERSION";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

