/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.frame.cluster.ClusterContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.balance.Loadbalance;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class SuspendCommand
implements Command {
    private Loadbalance lb = null;
    private int clusterId = -1;

    public SuspendCommand(ClusterContext cc) {
        this.lb = cc.getLoadbalanceContext();
        this.clusterId = cc.getClusterMonitor().getCurrentParticipant().getClusterId();
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        try {
            PrintWriter out = new PrintWriter(os, true);
            boolean suspend = false;
            String mode = null;
            if (params.length == 0) {
                mode = this.getCurrentMode();
                out.println("\r\nSAP J2EE Cluster element is currently " + mode + "\r\n");
                return;
            }
            if (params.length > 1) {
                new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> SUSPEND] Wrong number or no parameters.\r\n");
                return;
            }
            if (params.length == 1) {
                if (params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
                    out.println(this.getHelpMessage());
                    return;
                }
                if (params[0].equalsIgnoreCase("-status")) {
                    suspend = true;
                } else {
                    new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> SUSPEND] Unknown parameter " + params[0] + ".\r\n");
                    return;
                }
            }
            if (suspend) {
                this.suspendClusterElement();
            }
            mode = this.getCurrentMode();
            out.println("\r\nSAP J2EE Cluster element is now " + mode + "\r\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            new PrintWriter(env.getErrorStream(), true).println("\r\n[Shell -> SUSPEND] Can not set/get Cluster element status.\r\n[Shell -> SUSPEND] Reason : " + e.getMessage() + "\r\n");
        }
    }

    public String getGroup() {
        return "ADMIN";
    }

    public String getHelpMessage() {
        return "\r\nSuspends a cluster element.\r\nUsage: SUSPEND [-status]\r\nParameters:\r\n  [-status] - Suspends the cluster element.\r\n  no parameter - Shows the current status.\r\n";
    }

    public String getName() {
        return "SUSPEND";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }

    private String getCurrentMode() throws Exception {
        String res = null;
        boolean isSuspended = false;
        ClusterElement[] suspended = this.lb.getSuspendedElements();
        if (suspended != null) {
            int i = 0;
            while (i < suspended.length) {
                if (suspended[i].getClusterId() == this.clusterId) {
                    isSuspended = true;
                    break;
                }
                ++i;
            }
        }
        res = isSuspended ? "suspended" : "resumed (active)";
        return res;
    }

    private void suspendClusterElement() throws Exception {
        this.lb.suspend(this.clusterId);
    }
}

