/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.adminadapter.shell;

import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.jmx.ObjectNameFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.management.MBeanServer;

public class StopCommand
implements Command {
    private ClusterMonitor cm;
    private int currentClusterID;
    private String sName;
    private MBeanServer server;

    public StopCommand(ClusterMonitor cm, MBeanServer server) {
        this.cm = cm;
        this.server = server;
        this.currentClusterID = cm.getCurrentParticipant().getClusterId();
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        boolean notFound;
        PrintWriter err = new PrintWriter(env.getErrorStream(), true);
        int clusterID = this.currentClusterID;
        if (params.length == 0) {
            err.println("\r\n[Shell -> STOPSERVICE] Missing service name!\r\n");
            return;
        }
        if (params.length == 1) {
            if (params[0].equalsIgnoreCase("-h") || params[0].equals("-?") || params[0].equalsIgnoreCase("-help")) {
                new PrintWriter(os, true).println(this.getHelpMessage());
                return;
            }
            this.sName = params[0];
        } else {
            if (params.length > 2) {
                err.println("\r\n[Shell -> STOPSERVICE] Too much parameters !\r\n");
                return;
            }
            try {
                clusterID = Integer.parseInt(params[0]);
            }
            catch (NumberFormatException e) {
                err.println("\r\n[Shell -> STOPSERVICE] Invalid ID!\r\n");
                return;
            }
            this.sName = params[1];
        }
        ClusterElement[] clusterElements = this.cm.getParticipants();
        boolean bl = notFound = clusterID != this.currentClusterID;
        if (clusterID == 0) {
            notFound = false;
        } else {
            int i = 0;
            while (i < clusterElements.length) {
                if (clusterElements[i].getClusterId() == clusterID) {
                    notFound = false;
                    break;
                }
                ++i;
            }
        }
        if (notFound) {
            err.println("\r\n[Shell -> STOPSERVICE] There is no such cluster ID : " + clusterID + "\r\n");
            return;
        }
        if (clusterID == 0) {
            try {
                this.server.invoke(ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServicePerNode", (String)this.sName, (String)String.valueOf(this.cm.getCurrentParticipant().getClusterId()), (String)"\"\""), "stop", new Object[0], new String[0]);
            }
            catch (Exception e) {
                err.println("[Shell -> STOPSERVICE] There is no such service " + this.sName);
            }
            int i = 0;
            while (i < clusterElements.length) {
                try {
                    this.server.invoke(ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServicePerNode", (String)this.sName, (String)String.valueOf(clusterElements[i].getClusterId()), (String)"\"\""), "stop", new Object[0], new String[0]);
                }
                catch (Exception e) {
                    err.println("[Shell -> STOPSERVICE] There is no such service " + this.sName + " on cluster element " + clusterElements[i].getClusterId());
                }
                ++i;
            }
        } else {
            try {
                this.server.invoke(ObjectNameFactory.getNameForServerChildPerNode((String)"SAP_J2EEServicePerNode", (String)this.sName, (String)String.valueOf(clusterID), (String)"\"\""), "stop", new Object[0], new String[0]);
            }
            catch (Exception ex) {
                err.println("\r\n[Shell -> STOPSERVICE] Could not stop the service '" + this.sName + "'!");
                err.println("[Shell -> STOPSERVICE] Reason : " + ex.getMessage() + "\r\n");
            }
        }
    }

    public String getHelpMessage() {
        return "\r\nStops a service on the specified cluster element.\r\nUsage: STOPSERVICE [ClusterID] <serviceName>\r\nParameters:\r\n  [ClusterID] - ID of the cluster element on which to stop the service. Default\r\n                value is the ID of the current cluster element. If [ClusterID]\r\n                is set to 0, the service stops on all cluster elements.\r\n  <serviceName> - the name of the service to be stopped.\r\n";
    }

    public String getGroup() {
        return "ADMIN";
    }

    public String getName() {
        return "STOPSERVICE";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

